/*
 * Decompiled with CFR 0.152.
 */
package trinity.entities;

import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import trinity.config.TrinityConfig;
import trinity.entities.EntityFalloutRain;
import trinity.entities.EntityShockwave;
import trinity.entities.EntityThermalBlast;
import trinity.explosion.ExplosionNukeGeneric;
import trinity.explosion.ExplosionNukeRay;

public class EntityNuclearExplosion
extends Entity {
    public int strength;
    public int count;
    public int speed;
    public int length;
    public boolean fallout = true;
    public boolean salted = false;
    public boolean thermonuclear = false;
    public boolean thermal = true;
    public boolean Void = false;
    public int chance = 0;
    ExplosionNukeRay explosion;

    public EntityNuclearExplosion(World p_i1582_1_) {
        super(p_i1582_1_);
    }

    public EntityNuclearExplosion(World world, int strength, int count, int speed, int length) {
        super(world);
        this.strength = strength;
        this.count = count;
        this.speed = speed;
        this.length = length;
    }

    public void func_70071_h_() {
        if (this.strength == 0) {
            this.func_70106_y();
            return;
        }
        BlockPos pos = new BlockPos(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187754_de, SoundCategory.AMBIENT, 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f, false);
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.AMBIENT, 10000.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.2f, false);
        }
        if (this.thermal) {
            ExplosionNukeGeneric.dealDamage(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.length * 10);
        } else if (!this.thermal) {
            ExplosionNukeGeneric.dealDamage(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.length * 2);
        }
        if (this.explosion == null) {
            this.explosion = new ExplosionNukeRay(this.field_70170_p, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, this.strength, this.count, this.speed, this.length, this.Void);
        }
        if (!this.explosion.isAusf3Complete) {
            this.explosion.collectTipMk4_5(this.speed * 10);
        } else if (this.explosion.getStoredSize() > 0) {
            this.explosion.processTip(1024);
        } else if (this.fallout) {
            EntityFalloutRain fallout;
            EntityShockwave shock = new EntityShockwave(this.field_70170_p);
            shock.field_70165_t = this.field_70165_t;
            shock.field_70163_u = this.field_70163_u;
            shock.field_70161_v = this.field_70161_v;
            shock.setScale(this.length * 2 * 100 / 100);
            this.field_70170_p.func_72838_d((Entity)shock);
            if (this.thermonuclear) {
                fallout = new EntityFalloutRain(this.field_70170_p);
                fallout.field_70165_t = this.field_70165_t;
                fallout.field_70163_u = this.field_70163_u;
                fallout.field_70161_v = this.field_70161_v;
                fallout.setScale((int)((double)this.length * TrinityConfig.fallout_multiplier) * 100 / 100);
                fallout.setThermonuclear(true);
                fallout.setIntensity(this.chance);
                this.field_70170_p.func_72838_d((Entity)fallout);
            }
            if (this.salted) {
                fallout = new EntityFalloutRain(this.field_70170_p);
                fallout.field_70165_t = this.field_70165_t;
                fallout.field_70163_u = this.field_70163_u;
                fallout.field_70161_v = this.field_70161_v;
                fallout.setScale((int)((double)this.length * TrinityConfig.fallout_multiplier) * 100 / 100);
                fallout.setSalted(true);
                this.field_70170_p.func_72838_d((Entity)fallout);
            } else if (!this.salted) {
                fallout = new EntityFalloutRain(this.field_70170_p);
                fallout.field_70165_t = this.field_70165_t;
                fallout.field_70163_u = this.field_70163_u;
                fallout.field_70161_v = this.field_70161_v;
                fallout.setScale((int)((double)this.length * TrinityConfig.fallout_multiplier) * 100 / 100);
                fallout.setSalted(false);
                this.field_70170_p.func_72838_d((Entity)fallout);
            }
            this.func_70106_y();
        } else {
            EntityShockwave shock = new EntityShockwave(this.field_70170_p);
            shock.field_70165_t = this.field_70165_t;
            shock.field_70163_u = this.field_70163_u;
            shock.field_70161_v = this.field_70161_v;
            shock.setScale((int)((double)this.length * 1.5) * 100 / 100);
            this.field_70170_p.func_72838_d((Entity)shock);
            if (this.thermal) {
                EntityThermalBlast fallout = new EntityThermalBlast(this.field_70170_p);
                fallout.field_70165_t = this.field_70165_t;
                fallout.field_70163_u = this.field_70163_u;
                fallout.field_70161_v = this.field_70161_v;
                fallout.setScale((int)((double)this.length * TrinityConfig.fallout_multiplier * 2.0) * 100 / 100);
                this.field_70170_p.func_72838_d((Entity)fallout);
            }
            this.func_70106_y();
        }
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
    }

    public static EntityNuclearExplosion statFac(World world, int r, double x, double y, double z) {
        if (r == 0) {
            r = 25;
        }
        EntityNuclearExplosion mk4 = new EntityNuclearExplosion(world);
        mk4.strength = r *= 2;
        mk4.count = (int)(Math.PI * 4 * Math.pow(mk4.strength, 2.0) * 25.0);
        mk4.speed = (int)Math.ceil(100000 / mk4.strength);
        mk4.func_70107_b(x, y, z);
        mk4.length = mk4.strength / 2;
        return mk4;
    }

    public static EntityNuclearExplosion statFacExperimental(World world, int r, double x, double y, double z) {
        EntityNuclearExplosion mk4 = new EntityNuclearExplosion(world);
        mk4.strength = r *= 2;
        mk4.count = (int)(Math.PI * 4 * Math.pow(mk4.strength, 2.0) * 25.0);
        mk4.speed = (int)Math.ceil(100000 / mk4.strength);
        mk4.func_70107_b(x, y, z);
        mk4.length = mk4.strength / 2;
        mk4.salted = false;
        return mk4;
    }

    public static EntityNuclearExplosion statFacNoRad(World world, int r, double x, double y, double z) {
        EntityNuclearExplosion mk4 = new EntityNuclearExplosion(world);
        mk4.strength = r *= 2;
        mk4.count = (int)(Math.PI * 4 * Math.pow(mk4.strength, 2.0) * 25.0);
        mk4.speed = (int)Math.ceil(100000 / mk4.strength);
        mk4.func_70107_b(x, y, z);
        mk4.length = mk4.strength / 2;
        mk4.fallout = false;
        mk4.thermal = false;
        return mk4;
    }

    public static EntityNuclearExplosion statFacAntimatter(World world, int r, double x, double y, double z) {
        EntityNuclearExplosion mk4 = new EntityNuclearExplosion(world);
        mk4.strength = r *= 2;
        mk4.count = (int)(Math.PI * 4 * Math.pow(mk4.strength, 2.0) * 25.0);
        mk4.speed = (int)Math.ceil(100000 / mk4.strength);
        mk4.func_70107_b(x, y, z);
        mk4.length = mk4.strength / 2;
        mk4.fallout = false;
        mk4.thermal = true;
        return mk4;
    }

    public static EntityNuclearExplosion statFacSalted(World world, int r, double x, double y, double z) {
        EntityNuclearExplosion mk4 = new EntityNuclearExplosion(world);
        mk4.strength = (int)((float)(r *= 2) * 0.75f);
        mk4.count = (int)(Math.PI * 4 * Math.pow(mk4.strength, 2.0) * 25.0);
        mk4.speed = (int)Math.ceil(100000 / mk4.strength);
        mk4.func_70107_b(x, y, z);
        mk4.length = mk4.strength / 2;
        mk4.salted = true;
        return mk4;
    }

    public static EntityNuclearExplosion statFacThermo(World world, int r, double x, double y, double z, int chance) {
        if (r == 0) {
            r = 25;
        }
        EntityNuclearExplosion mk4 = new EntityNuclearExplosion(world);
        mk4.strength = r *= 2;
        mk4.count = (int)(Math.PI * 4 * Math.pow(mk4.strength, 2.0) * 25.0);
        mk4.speed = (int)Math.ceil(100000 / mk4.strength);
        mk4.func_70107_b(x, y, z);
        mk4.length = mk4.strength / 2;
        mk4.thermonuclear = true;
        mk4.chance = chance;
        return mk4;
    }

    public static EntityNuclearExplosion statFacHyperspace(World world, int r, double x, double y, double z) {
        EntityNuclearExplosion mk4 = new EntityNuclearExplosion(world);
        mk4.strength = r *= 2;
        mk4.count = (int)(Math.PI * 4 * Math.pow(mk4.strength, 2.0) * 25.0);
        mk4.speed = (int)Math.ceil(100000 / mk4.strength);
        mk4.func_70107_b(x, y, z);
        mk4.length = mk4.strength / 2;
        mk4.fallout = false;
        mk4.thermal = false;
        mk4.Void = true;
        return mk4;
    }
}

