/*
 * Decompiled with CFR 0.152.
 */
package trinity.entities;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.BlockFluidClassic;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinity.handler.Vec3;

public class EntityShockwave
extends Entity {
    private static final DataParameter<Integer> SCALE = EntityDataManager.func_187226_a(EntityShockwave.class, (DataSerializer)DataSerializers.field_187192_b);
    public int revProgress;
    public int radProgress;

    public EntityShockwave(World p_i1582_1_) {
        super(p_i1582_1_);
        this.func_70105_a(0.0f, 0.0f);
        this.field_70178_ae = true;
    }

    public EntityShockwave(World p_i1582_1_, int maxAge) {
        super(p_i1582_1_);
        this.func_70105_a(0.0f, 0.0f);
        this.field_70178_ae = true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        double X = this.field_70165_t;
        double X2 = MathHelper.func_76128_c((double)(X - (double)this.getScale() - 1.0));
        double X3 = MathHelper.func_76128_c((double)(X + (double)this.getScale() - 1.0));
        double Y = this.field_70163_u;
        double Y2 = MathHelper.func_76128_c((double)(Y - (double)this.getScale() - 1.0));
        double Y3 = MathHelper.func_76128_c((double)(Y + (double)this.getScale() - 1.0));
        double Z = this.field_70161_v;
        double Z2 = MathHelper.func_76128_c((double)(Z - (double)this.getScale() - 1.0));
        double Z3 = MathHelper.func_76128_c((double)(Z + (double)this.getScale() - 1.0));
        AxisAlignedBB bb = new AxisAlignedBB(X2, Y2, Z2, X3, Y3, Z3);
        return bb;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos pos3 = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos pos4 = new BlockPos.MutableBlockPos();
            BlockPos.MutableBlockPos pos5 = new BlockPos.MutableBlockPos();
            for (int i = 0; i < 512; ++i) {
                Vec3 vec = Vec3.createVectorHelper((double)this.radProgress * 0.5, 0.0, 0.0);
                double circum = (double)(this.radProgress * 2) * Math.PI * 2.0;
                if (circum == 0.0) {
                    circum = 1.0;
                }
                double part = 360.0 / circum;
                vec.rotateAroundY((float)(part * (double)this.revProgress));
                int x = (int)(this.field_70165_t + vec.xCoord);
                int z = (int)(this.field_70161_v + vec.zCoord);
                double dist = (double)(this.radProgress * 100 / this.getScale()) * 0.5;
                pos.func_189532_c((double)x, this.field_70163_u, (double)z);
                pos2.func_189532_c((double)(x - 1), this.field_70163_u, (double)z);
                pos3.func_189532_c((double)(x + 1), this.field_70163_u, (double)z);
                pos4.func_189532_c((double)x, this.field_70163_u, (double)(z - 1));
                pos5.func_189532_c((double)x, this.field_70163_u, (double)(z - 1));
                this.blast(pos, dist);
                this.blast(pos2, dist);
                this.blast(pos3, dist);
                this.blast(pos4, dist);
                this.blast(pos5, dist);
                ++this.revProgress;
                if ((double)this.revProgress > circum) {
                    this.revProgress = 0;
                    ++this.radProgress;
                }
                if (!((double)this.radProgress > (double)this.getScale() * 2.0)) continue;
                this.func_70106_y();
            }
        }
    }

    private void blast(BlockPos.MutableBlockPos pos, double dist) {
        boolean depth = false;
        int topBlock = this.field_70170_p.func_175672_r((BlockPos)pos).func_177956_o();
        for (int y = topBlock - 8; y <= topBlock + 48; ++y) {
            pos.func_185336_p(y);
            IBlockState b = this.field_70170_p.func_180495_p((BlockPos)pos);
            BlockPos left = new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p());
            BlockPos right = new BlockPos(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p());
            BlockPos up = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
            BlockPos down2 = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
            BlockPos front = pos.func_177982_a(0, 0, 1);
            BlockPos back = pos.func_177982_a(0, 0, -1);
            boolean LR = this.field_70170_p.func_175623_d(left) && this.field_70170_p.func_175623_d(right);
            boolean FB = this.field_70170_p.func_175623_d(front) && this.field_70170_p.func_175623_d(back);
            IBlockState bd = this.field_70170_p.func_180495_p(down2);
            if ((b.func_185904_a() != Material.field_151579_a || b.func_177230_c() instanceof BlockFluidClassic) && bd.func_185904_a() == Material.field_151579_a && b.func_177230_c().func_149638_a(null) <= 100.0f) {
                this.field_70170_p.func_175698_g((BlockPos)pos);
                continue;
            }
            if (b.func_185904_a() != Material.field_151579_a && (LR || FB)) {
                this.field_70170_p.func_175698_g((BlockPos)pos);
                continue;
            }
            if (b.func_185904_a() != Material.field_151579_a) continue;
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SCALE, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
        this.setScale(p_70037_1_.func_74762_e("scale"));
        this.revProgress = p_70037_1_.func_74762_e("revProgress");
        this.radProgress = p_70037_1_.func_74762_e("radProgress");
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
        p_70014_1_.func_74768_a("scale", this.getScale());
        p_70014_1_.func_74768_a("revProgress", this.revProgress);
        p_70014_1_.func_74768_a("radProgress", this.radProgress);
    }

    public void setScale(int i) {
        this.field_70180_af.func_187227_b(SCALE, (Object)i);
    }

    public int getScale() {
        int scale = (Integer)this.field_70180_af.func_187225_a(SCALE);
        return scale == 0 ? 1 : scale;
    }
}

