/*
 * Decompiled with CFR 0.152.
 */
package trinity.entities;

import icbm.classic.api.ExplosiveRefs;
import icbm.classic.content.blast.BlastEMP;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinity.Trinity;
import trinity.config.TrinityConfig;
import trinity.entities.EntityFalloutRain;
import trinity.entities.EntityShockwave;
import trinity.handler.Vec3;

public class EntityThermonuclearBlast
extends Entity {
    private static final DataParameter<Integer> SCALE = EntityDataManager.func_187226_a(EntityThermonuclearBlast.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> INTENSITY = EntityDataManager.func_187226_a(EntityThermonuclearBlast.class, (DataSerializer)DataSerializers.field_187192_b);
    public int revProgress;
    public int radProgress;

    public EntityThermonuclearBlast(World p_i1582_1_) {
        super(p_i1582_1_);
        this.func_70105_a(0.0f, 0.0f);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
    }

    public EntityThermonuclearBlast(World p_i1582_1_, boolean salt) {
        super(p_i1582_1_);
        this.func_70105_a(0.0f, 0.0f);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
    }

    public EntityThermonuclearBlast(World p_i1582_1_, int maxAge) {
        super(p_i1582_1_);
        this.func_70105_a(0.0f, 0.0f);
        this.field_70158_ak = true;
        this.field_70178_ae = true;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        double X = this.field_70165_t;
        double X2 = MathHelper.func_76128_c((double)(X - (double)this.getScale() - 1.0));
        double X3 = MathHelper.func_76128_c((double)(X + (double)this.getScale() - 1.0));
        double Y = this.field_70163_u;
        double Y2 = MathHelper.func_76128_c((double)(Y - (double)this.getScale() - 1.0));
        double Y3 = MathHelper.func_76128_c((double)(Y + (double)this.getScale() - 1.0));
        double Z = this.field_70161_v;
        double Z2 = MathHelper.func_76128_c((double)(Z - (double)this.getScale() - 1.0));
        double Z3 = MathHelper.func_76128_c((double)(Z + (double)this.getScale() - 1.0));
        AxisAlignedBB bb = new AxisAlignedBB(X2, Y2, Z2, X3, Y3, Z3);
        return bb;
    }

    public void func_70071_h_() {
        boolean spawn = false;
        if (!this.field_70170_p.field_72995_K) {
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            for (int i = 0; i < 512; ++i) {
                Vec3 vec = Vec3.createVectorHelper((double)this.radProgress * 0.5, 0.0, 0.0);
                double circum = (double)(this.radProgress * 2) * Math.PI * 2.0;
                if (circum == 0.0) {
                    circum = 1.0;
                }
                double part = 360.0 / circum;
                vec.rotateAroundY((float)(part * (double)this.revProgress));
                int x = (int)(this.field_70165_t + vec.xCoord);
                int z = (int)(this.field_70161_v + vec.zCoord);
                double dist = (double)(this.radProgress * 100 / this.getScale()) * 0.5;
                pos.func_189532_c((double)x, this.field_70163_u, (double)z);
                this.contaminate(pos, dist);
                ++this.revProgress;
                if ((double)this.revProgress > circum) {
                    this.revProgress = 0;
                    ++this.radProgress;
                }
                if (!((double)this.radProgress > (double)this.getScale() * 2.0)) continue;
                this.func_70106_y();
                if (spawn) continue;
                spawn = true;
                EntityShockwave shock = new EntityShockwave(this.field_70170_p);
                shock.field_70165_t = this.field_70165_t;
                shock.field_70163_u = this.field_70163_u;
                shock.field_70161_v = this.field_70161_v;
                shock.setScale(this.getScale() * 2 * 100 / 100);
                this.field_70170_p.func_72838_d((Entity)shock);
                EntityFalloutRain fallout = new EntityFalloutRain(this.field_70170_p);
                fallout.field_70165_t = this.field_70165_t;
                fallout.field_70163_u = this.field_70163_u;
                fallout.field_70161_v = this.field_70161_v;
                fallout.setScale((int)((double)this.getScale() * TrinityConfig.fallout_multiplier) * 100 / 100);
                fallout.setThermonuclear(true);
                fallout.setIntensity(this.getIntensity());
                this.field_70170_p.func_72838_d((Entity)fallout);
            }
        }
    }

    private void contaminate(BlockPos.MutableBlockPos pos, double dist) {
        int depth = 0;
        int maxDepth = (int)(dist / 10.0);
        int topBlock = this.field_70170_p.func_175672_r((BlockPos)pos).func_177956_o();
        for (int y = topBlock + 35; y >= topBlock - maxDepth; --y) {
            pos.func_185336_p(y);
            IBlockState b = this.field_70170_p.func_180495_p((BlockPos)pos);
            if (b.func_177230_c() == Blocks.field_150350_a || !(b.func_177230_c().func_149638_a((Entity)this) <= 200.0f) || !((double)(++depth) <= dist / 10.0)) continue;
            this.field_70170_p.func_175698_g((BlockPos)pos);
            return;
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(SCALE, (Object)0);
        this.field_70180_af.func_187214_a(INTENSITY, (Object)0);
    }

    protected void func_70037_a(NBTTagCompound p_70037_1_) {
        this.setScale(p_70037_1_.func_74762_e("scale"));
        this.setIntensity(p_70037_1_.func_74762_e("intensity"));
        this.revProgress = p_70037_1_.func_74762_e("revProgress");
        this.radProgress = p_70037_1_.func_74762_e("radProgress");
    }

    protected void func_70014_b(NBTTagCompound p_70014_1_) {
        p_70014_1_.func_74768_a("scale", this.getScale());
        p_70014_1_.func_74768_a("intensity", this.getIntensity());
        p_70014_1_.func_74768_a("revProgress", this.revProgress);
        p_70014_1_.func_74768_a("radProgress", this.radProgress);
    }

    public void setIntensity(int i) {
        this.field_70180_af.func_187227_b(INTENSITY, (Object)i);
    }

    public int getIntensity() {
        int intensity = (Integer)this.field_70180_af.func_187225_a(INTENSITY);
        return intensity == 0 ? 1 : intensity;
    }

    public void setScale(int i) {
        this.field_70180_af.func_187227_b(SCALE, (Object)i);
        if (Trinity.ICBMLoaded) {
            new BlastEMP().setBlastWorld(this.field_70170_p).setBlastSource((Entity)this).setBlastPosition(this.field_70165_t, this.field_70163_u, this.field_70161_v).setBlastSize((double)(i * 2)).setExplosiveData(ExplosiveRefs.EMP).buildBlast().runBlast();
        }
    }

    public int getScale() {
        int scale = (Integer)this.field_70180_af.func_187225_a(SCALE);
        return scale == 0 ? 1 : scale;
    }
}

