/*
 * Decompiled with CFR 0.152.
 */
package trinity.explosion;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import trinity.handler.Vec3;

public class ExplosionNukeRay {
    List<FloatTriplet> affectedBlocks = new ArrayList<FloatTriplet>();
    int posX;
    int posY;
    int posZ;
    Random rand = new Random();
    World world;
    int strength;
    int count;
    int speed;
    int processed;
    int length;
    int startY;
    int startCir;
    boolean hyperspace;
    public boolean isAusf3Complete = false;

    public ExplosionNukeRay(World world, int x, int y, int z, int strength, int count, int speed, int length, boolean hyperspace) {
        this.world = world;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.strength = strength;
        this.count = count;
        this.speed = speed;
        this.length = length;
        this.hyperspace = hyperspace;
        this.startY = 0;
        this.startCir = 0;
    }

    public void processTip(int count) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int processedBlocks = 0;
        int braker = 0;
        for (int l = 0; l < Integer.MAX_VALUE; ++l) {
            if (processedBlocks >= count) {
                return;
            }
            if (braker >= count * 50) {
                return;
            }
            if (l > this.affectedBlocks.size() - 1) break;
            if (this.affectedBlocks.isEmpty()) {
                return;
            }
            int in = this.affectedBlocks.size() - 1;
            float x = this.affectedBlocks.get((int)in).xCoord;
            float y = this.affectedBlocks.get((int)in).yCoord;
            float z = this.affectedBlocks.get((int)in).zCoord;
            pos.func_189532_c((double)x, (double)y, (double)z);
            this.world.func_175698_g((BlockPos)pos);
            Vec3 vec = Vec3.createVectorHelper(x - (float)this.posX, y - (float)this.posY, z - (float)this.posZ);
            double pX = vec.xCoord / vec.lengthVector();
            double pY = vec.yCoord / vec.lengthVector();
            double pZ = vec.zCoord / vec.lengthVector();
            int i = 0;
            while ((double)i < vec.lengthVector()) {
                int x0 = (int)((double)this.posX + pX * (double)i);
                int y0 = (int)((double)this.posY + pY * (double)i);
                int z0 = (int)((double)this.posZ + pZ * (double)i);
                pos.func_181079_c(x0, y0, z0);
                if (!this.world.func_175623_d((BlockPos)pos)) {
                    this.world.func_175698_g((BlockPos)pos);
                    ++processedBlocks;
                }
                ++braker;
                ++i;
            }
            this.affectedBlocks.remove(in);
        }
        this.processed += count;
    }

    public void collectTip(int count) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        block0: for (int k = 0; k < count; ++k) {
            double phi = this.rand.nextDouble() * (Math.PI * 2);
            double costheta = this.rand.nextDouble() * 2.0 - 1.0;
            double theta = Math.acos(costheta);
            double x = Math.sin(theta) * Math.cos(phi);
            double y = Math.sin(theta) * Math.sin(phi);
            double z = Math.cos(theta);
            Vec3 vec = Vec3.createVectorHelper(x, y, z);
            int length = (int)Math.ceil(this.strength);
            float res = this.strength;
            FloatTriplet lastPos = null;
            for (int i = 0; i < length && i <= this.length; ++i) {
                float x0 = (float)((double)this.posX + vec.xCoord * (double)i);
                float y0 = (float)((double)this.posY + vec.yCoord * (double)i);
                float z0 = (float)((double)this.posZ + vec.zCoord * (double)i);
                pos.func_189532_c((double)x0, (double)y0, (double)z0);
                if (!this.hyperspace) {
                    res = !this.world.func_180495_p((BlockPos)pos).func_185904_a().func_76224_d() ? (float)((double)res - Math.pow(this.world.func_180495_p((BlockPos)pos).func_177230_c().getExplosionResistance(this.world, (BlockPos)pos, null, null), 1.25)) : (float)((double)res - Math.pow(Blocks.field_150350_a.getExplosionResistance(this.world, (BlockPos)pos, null, null), 1.25));
                }
                if (res > 0.0f && this.world.func_180495_p((BlockPos)pos).func_177230_c() != Blocks.field_150350_a) {
                    lastPos = new FloatTriplet(x0, y0, z0);
                }
                if (!(res <= 0.0f) && i + 1 < this.length) continue;
                if (this.affectedBlocks.size() >= 2147483547 || lastPos == null) continue block0;
                this.affectedBlocks.add(new FloatTriplet(lastPos.xCoord, lastPos.yCoord, lastPos.zCoord));
                continue block0;
            }
        }
    }

    public void collectTipExperimental(int count) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        block0: for (int k = 0; k < count; ++k) {
            double phi = this.rand.nextDouble() * (Math.PI * 2);
            double costheta = this.rand.nextDouble() * 2.0 - 1.0;
            double theta = Math.acos(costheta);
            double x = Math.sin(theta) * Math.cos(phi);
            double y = Math.sin(theta) * Math.sin(phi);
            double z = Math.cos(theta);
            Vec3 vec = Vec3.createVectorHelper(x, y, z);
            int length = (int)Math.ceil(this.strength);
            float res = this.strength;
            FloatTriplet lastPos = null;
            for (int i = 0; i < length && i <= this.length; ++i) {
                float x0 = (float)((double)this.posX + vec.xCoord * (double)i);
                float y0 = (float)((double)this.posY + vec.yCoord * (double)i);
                float z0 = (float)((double)this.posZ + vec.zCoord * (double)i);
                pos.func_189532_c((double)x0, (double)y0, (double)z0);
                double fac = 100.0 - (double)i / (double)length * 100.0;
                fac *= 0.07;
                if (!this.hyperspace) {
                    res = !this.world.func_180495_p((BlockPos)pos).func_185904_a().func_76224_d() ? (float)((double)res - Math.pow(this.world.func_180495_p((BlockPos)pos).func_177230_c().getExplosionResistance(this.world, (BlockPos)pos, null, null), 7.5 - fac)) : (float)((double)res - Math.pow(Blocks.field_150350_a.getExplosionResistance(this.world, (BlockPos)pos, null, null), 7.5 - fac));
                }
                if (res > 0.0f && this.world.func_180495_p((BlockPos)pos).func_177230_c() != Blocks.field_150350_a) {
                    lastPos = new FloatTriplet(x0, y0, z0);
                }
                if (!(res <= 0.0f) && i + 1 < this.length) continue;
                if (this.affectedBlocks.size() >= 2147483547 || lastPos == null) continue block0;
                this.affectedBlocks.add(new FloatTriplet(lastPos.xCoord, lastPos.yCoord, lastPos.zCoord));
                continue block0;
            }
        }
    }

    public void collectTipMk4_5(int count) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        int amountProcessed = 0;
        double bow = Math.PI * (double)this.strength;
        double bowCount = Math.ceil(bow);
        int v = this.startY;
        while ((double)v <= bowCount) {
            float part = (float)(Math.PI / bow);
            float rot = part * (float)(-v);
            Vec3 heightVec = Vec3.createVectorHelper(0.0, -this.strength, 0.0);
            heightVec.rotateAroundZ(rot);
            double y = heightVec.yCoord;
            double sectionRad = Math.sqrt(Math.pow(this.strength, 2.0) - Math.pow(y, 2.0));
            double circumference = Math.PI * 2 * sectionRad;
            int r = this.startCir;
            while ((double)r < circumference) {
                Vec3 vec = Vec3.createVectorHelper(sectionRad, y, 0.0);
                vec = vec.normalize();
                vec.rotateAroundY((float)(360.0 / circumference * (double)r));
                int length = (int)Math.ceil(this.strength);
                float res = this.strength;
                FloatTriplet lastPos = null;
                for (int i = 0; i < length && i <= this.length; ++i) {
                    float x0 = (float)((double)this.posX + vec.xCoord * (double)i);
                    float y0 = (float)((double)this.posY + vec.yCoord * (double)i);
                    float z0 = (float)((double)this.posZ + vec.zCoord * (double)i);
                    pos.func_189532_c((double)x0, (double)y0, (double)z0);
                    double fac = 100.0 - (double)i / (double)length * 100.0;
                    fac *= 0.07;
                    if (!this.hyperspace) {
                        res = !this.world.func_180495_p((BlockPos)pos).func_185904_a().func_76224_d() ? (float)((double)res - Math.pow(this.world.func_180495_p((BlockPos)pos).func_177230_c().getExplosionResistance(this.world, (BlockPos)pos, null, null), 7.5 - fac)) : (float)((double)res - Math.pow(Blocks.field_150350_a.getExplosionResistance(this.world, (BlockPos)pos, null, null), 7.5 - fac));
                    }
                    if (res > 0.0f && this.world.func_180495_p((BlockPos)pos).func_177230_c() != Blocks.field_150350_a) {
                        lastPos = new FloatTriplet(x0, y0, z0);
                    }
                    if (!(res <= 0.0f) && i + 1 < this.length) continue;
                    if (this.affectedBlocks.size() >= 2147483547 || lastPos == null) break;
                    this.affectedBlocks.add(new FloatTriplet(lastPos.xCoord, lastPos.yCoord, lastPos.zCoord));
                    break;
                }
                if (++amountProcessed >= count) {
                    this.startY = v;
                    ++this.startCir;
                    return;
                }
                ++r;
            }
            ++v;
        }
        this.isAusf3Complete = true;
    }

    public void deleteStorage() {
        this.affectedBlocks.clear();
    }

    public int getStoredSize() {
        return this.affectedBlocks.size();
    }

    public int getProgress() {
        return this.processed;
    }

    public class FloatTriplet {
        public float xCoord;
        public float yCoord;
        public float zCoord;

        public FloatTriplet(float x, float y, float z) {
            this.xCoord = x;
            this.yCoord = y;
            this.zCoord = z;
        }
    }
}

