/*
 * Decompiled with CFR 0.152.
 */
package trinity.fluid;

import java.util.ArrayList;
import java.util.List;
import nc.block.fluid.NCBlockFluid;
import nc.block.item.NCItemBlock;
import nc.enumm.FluidType;
import nc.util.ColorHelper;
import nc.util.NCUtil;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.Pair;
import trinity.Trinity;
import trinity.fluid.FluidTrinity;

public class TrinityFluids {
    public static FluidTrinity witherite_water;
    public static FluidTrinity nitric_oxide;
    public static FluidTrinity nitrogen_dioxide;
    public static FluidTrinity nitric_acid;
    public static FluidTrinity barium_nitrate_solution;
    public static FluidTrinity tnt;
    public static FluidTrinity baratol;
    public static List<Pair<Fluid, NCBlockFluid>> fluidPairList;

    public static void registerFluids() {
        tnt = new FluidTrinity("tnt", new ResourceLocation("trinity", "blocks/liquid_still"), new ResourceLocation("trinity", "blocks/liquid_flow"), 16590848);
        baratol = new FluidTrinity("baratol", new ResourceLocation("trinity", "blocks/liquid_still"), new ResourceLocation("trinity", "blocks/liquid_flow"), 16485718);
        FluidRegistry.registerFluid((Fluid)tnt);
        FluidRegistry.registerFluid((Fluid)baratol);
    }

    private static <T extends Fluid, V extends NCBlockFluid> void addFluidPair(FluidType fluidType, Object ... fluidArgs) {
        try {
            Fluid fluid = (Fluid)NCUtil.newInstance((Class)fluidType.getFluidClass(), (Object[])fluidArgs);
            NCBlockFluid block = (NCBlockFluid)NCUtil.newInstance((Class)fluidType.getBlockClass(), (Object[])new Object[]{fluid});
            fluidPairList.add((Pair<Fluid, NCBlockFluid>)Pair.of((Object)fluid, (Object)block));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void init() {
        try {
            TrinityFluids.addFluidPair(FluidType.SALT_SOLUTION, "witherite_water", TrinityFluids.waterBlend(12894626));
            TrinityFluids.addFluidPair(FluidType.GAS, "nitric_oxide", 11716234);
            TrinityFluids.addFluidPair(FluidType.GAS, "nitrogen_dioxide", 3677445);
            TrinityFluids.addFluidPair(FluidType.ACID, "nitric_acid", 689013);
            TrinityFluids.addFluidPair(FluidType.SALT_SOLUTION, "barium_nitrate_solution", TrinityFluids.waterBlend(0xBFBFBF));
            TrinityFluids.addFluidPair(FluidType.GAS, "deuterium-tritium_mixture", TrinityFluids.deuteriumBlend(6142934, 0.5f));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void renderFluids() {
    }

    public static void register() {
        for (Pair<Fluid, NCBlockFluid> fluidPair : fluidPairList) {
            Fluid fluid = (Fluid)fluidPair.getLeft();
            boolean defaultFluid = FluidRegistry.registerFluid((Fluid)fluid);
            if (!defaultFluid) {
                fluid = FluidRegistry.getFluid((String)fluid.getName());
            }
            FluidRegistry.addBucketForFluid((Fluid)fluid);
            TrinityFluids.registerBlock((NCBlockFluid)fluidPair.getRight());
        }
    }

    public static void registerBlock(NCBlockFluid block) {
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)TrinityFluids.withName(block));
        ForgeRegistries.ITEMS.register(new NCItemBlock((Block)block, TextFormatting.AQUA, new String[0]).setRegistryName(block.getRegistryName()));
        Trinity.proxy.registerFluidBlockRendering((Block)block, block.name);
    }

    public static <T extends NCBlockFluid> Block withName(T block) {
        return (Block)block.func_149663_c("trinity." + block.name).setRegistryName(new ResourceLocation("trinity", block.name));
    }

    private static int waterBlend(int soluteColor, float blendRatio) {
        return ColorHelper.blend((int)3097588, (int)soluteColor, (float)blendRatio);
    }

    private static int deuteriumBlend(int soluteColor, float blendRatio) {
        return ColorHelper.blend((int)10383343, (int)soluteColor, (float)blendRatio);
    }

    private static int waterBlend(int soluteColor) {
        return TrinityFluids.waterBlend(soluteColor, 0.5f);
    }

    static {
        fluidPairList = new ArrayList<Pair<Fluid, NCBlockFluid>>();
    }
}

