/*
 * Decompiled with CFR 0.152.
 */
package trinity.init;

import icbm.classic.api.EnumTier;
import icbm.classic.api.ExplosiveRefs;
import icbm.classic.content.blast.BlastEMP;
import icbm.classic.content.blast.threaded.BlastNuclear;
import icbm.classic.content.blocks.explosive.ItemBlockExplosive;
import icbm.classic.content.items.ItemMissile;
import java.util.List;
import nc.capability.radiation.entity.IEntityRads;
import nc.config.NCConfig;
import nc.network.PacketHandler;
import nc.network.radiation.PlayerRadsUpdatePacket;
import nc.radiation.RadiationHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.Explosion;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinity.Trinity;
import trinity.config.TrinityConfig;
import trinity.entities.EntityNuclearCloud;
import trinity.entities.EntityNuclearExplosion;
import trinity.explosion.ExplosionNukeGeneric;
import trinity.items.RadioactiveSource2;
import trinity.items.ShieldedContainerItem;
import trinity.tiles.TileEntityShieldedContainer;

@Mod.EventBusSubscriber(modid="trinity")
public class ModEvents {
    private static boolean renderingNukeEffects = false;
    public static String Pu_238 = "c95fdfd3-bea7-4255-a44b-d21bc3df95e3";

    @SubscribeEvent
    public void textureStitch(TextureStitchEvent.Pre evt) {
        evt.getMap().func_174942_a(new ResourceLocation("trinity", "blocks/liquid_still"));
        evt.getMap().func_174942_a(new ResourceLocation("trinity", "blocks/liquid_flow"));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void sealedRadiationSources(TickEvent.PlayerTickEvent event) {
        if (!NCConfig.radiation_enabled_public) {
            return;
        }
        if (event.phase != TickEvent.Phase.START || (event.player.field_70170_p.func_82737_E() + (long)event.player.func_110124_au().hashCode()) % (long)NCConfig.radiation_player_tick_rate != 0L) {
            return;
        }
        if (event.side == Side.SERVER && event.player instanceof EntityPlayerMP) {
            EntityPlayerMP player = (EntityPlayerMP)event.player;
            IEntityRads playerRads = RadiationHelper.getEntityRadiation((EntityLivingBase)player);
            if (player.func_110124_au().toString().equals(Pu_238) && playerRads.getInternalRadiationResistance() < 500.0) {
                playerRads.setInternalRadiationResistance(2800.0);
            }
            double radiationLevel = 0.0;
            List Tes = player.field_70170_p.field_147482_g;
            for (int i = 0; i < Tes.size(); ++i) {
                TileEntity tile = (TileEntity)Tes.get(i);
                int tileDim = tile.func_145831_w().field_73011_w.getDimension();
                int playerDim = player.func_130014_f_().field_73011_w.getDimension();
                if (!(tile instanceof TileEntityShieldedContainer) || tileDim != playerDim) continue;
                TileEntityShieldedContainer te = (TileEntityShieldedContainer)tile;
                double X = player.field_70165_t;
                double Y = player.field_70163_u;
                double Z = player.field_70161_v;
                double dist = te.func_145835_a(X, Y, Z);
                radiationLevel += Math.min(te.getRadiation(), te.getRadiation() / dist);
            }
            if (!player.func_110124_au().toString().equals(Pu_238)) {
                List entities = player.field_70170_p.field_73010_i;
                for (int i = 0; i < entities.size(); ++i) {
                    EntityPlayer p = (EntityPlayer)entities.get(i);
                    if (!p.func_110124_au().toString().equals(Pu_238)) continue;
                    double X = player.field_70165_t;
                    double Y = player.field_70163_u;
                    double Z = player.field_70161_v;
                    double dist = p.func_70092_e(X, Y, Z);
                    radiationLevel += Math.min(0.0115, 0.0115 / dist);
                }
            }
            InventoryPlayer inventory = player.field_71071_by;
            for (ItemStack stack : inventory.field_70462_a) {
                if (stack.func_190926_b()) continue;
                Item item = stack.func_77973_b();
                if (item instanceof RadioactiveSource2) {
                    radiationLevel += ((RadioactiveSource2)item).rads * (double)stack.func_190916_E();
                }
                if (!(item instanceof ShieldedContainerItem)) continue;
                radiationLevel += ((ShieldedContainerItem)item).getRadiation(stack) * (double)stack.func_190916_E();
            }
            double appliedRads = RadiationHelper.addRadsToEntity((IEntityRads)playerRads, (EntityLivingBase)player, (double)radiationLevel, (boolean)false, (boolean)false, (int)NCConfig.radiation_player_tick_rate);
            playerRads.setRadiationLevel(playerRads.getRadiationLevel() + appliedRads);
            PacketHandler.instance.sendTo((IMessage)new PlayerRadsUpdatePacket(playerRads), player);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void addAdditionalTooltips(ItemTooltipEvent event) {
        ItemStack stack;
        Item item;
        if (Trinity.ICBMLoaded && ((item = (stack = event.getItemStack()).func_77973_b()) instanceof ItemBlockExplosive || item instanceof ItemMissile) && stack.func_77952_i() == ExplosiveRefs.NUCLEAR.getRegistryID()) {
            ModEvents.addNukeTooltip(event.getToolTip(), stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static void addNukeTooltip(List<String> tooltip, ItemStack stack) {
        tooltip.add(TextFormatting.RED + "Warning: Trinity installed. ICBM nuclear explosives cause Trinity's explosions instead of ICBM's");
    }

    @SubscribeEvent
    public void explosion(ExplosionEvent.Start event) {
        Explosion exp;
        if (Trinity.ICBMLoaded && (exp = event.getExplosion()) instanceof BlastNuclear && ((BlastNuclear)exp).getExplosiveData().getTier() == EnumTier.THREE) {
            event.setCanceled(true);
            EntityNuclearCloud entity2 = new EntityNuclearCloud(exp.field_77287_j, 1000, (float)(Math.min(TrinityConfig.icbm_radius, TrinityConfig.max_radius) * 2) * 0.005f);
            entity2.field_70165_t = exp.field_77284_b;
            entity2.field_70163_u = exp.field_77285_c;
            entity2.field_70161_v = exp.field_77282_d;
            exp.field_77287_j.func_72838_d((Entity)entity2);
            new BlastEMP().setBlastWorld(event.getWorld()).setBlastSource(exp.field_77283_e).setBlastPosition(((BlastNuclear)exp).location.x(), ((BlastNuclear)exp).location.y(), ((BlastNuclear)exp).location.z()).setBlastSize((double)(((BlastNuclear)exp).getBlastRadius() * 2.0f)).setExplosiveData(ExplosiveRefs.EMP).buildBlast().runBlast();
            ExplosionNukeGeneric.irradiate(exp.field_77287_j, (int)exp.field_77284_b, (int)exp.field_77285_c, (int)exp.field_77282_d, Math.min(TrinityConfig.icbm_radius, TrinityConfig.max_radius) * 2);
            exp.field_77287_j.func_72838_d((Entity)EntityNuclearExplosion.statFac(exp.field_77287_j, Math.min(TrinityConfig.icbm_radius, TrinityConfig.max_radius), exp.field_77284_b + 0.0, exp.field_77285_c + 0.0, exp.field_77282_d + 0.0));
        }
    }
}

