/*
 * Decompiled with CFR 0.152.
 */
package trinity.items;

import java.util.List;
import javax.annotation.Nullable;
import lach_01298.qmd.item.IItemAmount;
import nc.capability.radiation.source.IRadiationSource;
import nc.config.NCConfig;
import nc.item.NCItem;
import nc.radiation.RadiationHelper;
import nc.util.Lang;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import trinity.config.TrinityConfig;
import trinity.init.ModItems;

public class RadioactiveSource
extends NCItem
implements IItemAmount {
    public double rads;
    private static final String RADIATION = Lang.localise((String)"item.nuclearcraft.rads");

    public RadioactiveSource(String nameIn, double radioactivity) {
        super(new String[0]);
        this.func_77655_b("trinity." + nameIn);
        this.rads = radioactivity;
        this.setRegistryName(new ResourceLocation("trinity", nameIn));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this == ModItems.neutron_initiator) {
            super.func_150895_a(tab, items);
        }
        if (this == ModItems.source_au_198 && this.func_194125_a(tab)) {
            ItemStack stack = new ItemStack((Item)this, 1, 0);
            RadioactiveSource cell = (RadioactiveSource)stack.func_77973_b();
            this.setAmountStored(stack, this.getCapacity(stack));
            items.add((Object)stack);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        IRadiationSource stackSource = RadiationHelper.getRadiationSource((ICapabilityProvider)stack);
        if (stackSource == null && this.rads > NCConfig.radiation_lowest_rate) {
            tooltip.add(RadiationHelper.getRadiationTextColor((double)(this.rads * (double)stack.func_190916_E())) + RADIATION + " " + RadiationHelper.radsPrefix((double)(this.rads * (double)stack.func_190916_E()), (boolean)true));
        }
    }

    public int getCapacity(ItemStack stack) {
        return TrinityConfig.capacity;
    }

    public ItemStack empty(ItemStack stack, int amount) {
        if (this.getAmountStored(stack) > amount) {
            this.setAmountStored(stack, this.getAmountStored(stack) - amount);
        } else if (this.getAmountStored(stack) == amount) {
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - MathHelper.func_151237_a((double)((double)this.getAmountStored(stack) / (double)this.getCapacity(stack)), (double)0.0, (double)1.0);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getAmountStored(stack) > 0;
    }
}

