/*
 * Decompiled with CFR 0.152.
 */
package trinity.items;

import java.util.List;
import nc.config.NCConfig;
import nc.radiation.RadiationHelper;
import nc.util.Lang;
import nc.util.NCMath;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import trinity.blocks.ShieldedContainer;

public class ShieldedContainerItem
extends ItemBlock {
    private static final String RADIATION = Lang.localise((String)"item.nuclearcraft.rads");

    public ShieldedContainerItem(Block block) {
        super(block);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        double rads = this.getRadiation(stack);
        if (rads > 0.0 && rads >= NCConfig.radiation_lowest_rate) {
            tooltip.add(RadiationHelper.getRadiationTextColor((double)(rads * (double)stack.func_190916_E())) + RADIATION + " " + RadiationHelper.radsPrefix((double)(rads * (double)stack.func_190916_E()), (boolean)true));
        }
    }

    public void setRadioactivity(ItemStack stack, double radioactivity) {
        if (stack.func_77978_p() == null) {
            // empty if block
        }
    }

    public double getRadioactivity(ItemStack stack) {
        if (stack.func_77942_o()) {
            double radioactivity = stack.func_77978_p().func_74769_h("Radioactivity");
            return radioactivity;
        }
        return 0.0;
    }

    public double getShielding() {
        Block block = this.field_150939_a;
        if (block instanceof ShieldedContainer) {
            ShieldedContainer shield = (ShieldedContainer)block;
            return shield.shielding;
        }
        return 0.0;
    }

    public double getRadiation(ItemStack stack) {
        double rads = this.getRadioactivity(stack);
        double shieldedRads = 0.0;
        shieldedRads = NCMath.sq((double)rads) / (rads + (Math.exp(this.getShielding()) - 1.0));
        return shieldedRads;
    }
}

