/*
 * Decompiled with CFR 0.152.
 */
package trinity.proxy;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import trinity.config.TrinityConfig;
import trinity.entities.EntityBlackHole;
import trinity.entities.EntityDirtyBomb;
import trinity.entities.EntityFalloutRain;
import trinity.entities.EntityNuclearCloud;
import trinity.entities.EntityThermalBlast;
import trinity.fluid.TrinityFluids;
import trinity.handler.INuclearEffect;
import trinity.init.ModBlocks;
import trinity.init.ModEvents;
import trinity.init.ModItems;
import trinity.proxy.CommonProxy;
import trinity.render.AdvancedModelLoader;
import trinity.render.HmfModelLoader;
import trinity.render.entity.RenderBlackHole;
import trinity.render.entity.RenderFalloutRainFactory;
import trinity.render.entity.RenderNuclearExplosion;
import trinity.render.entity.RenderPrimedDirtyBomb;
import trinity.render.entity.RenderThermalBlastFactory;

public class ClientProxy
extends CommonProxy {
    private final Minecraft mc = Minecraft.func_71410_x();

    @Override
    public void preInit(FMLPreInitializationEvent preEvent) {
        super.preInit(preEvent);
        TrinityConfig.clientPreInit();
        ModItems.registerRenders();
        ModBlocks.registerRenders();
        MinecraftForge.EVENT_BUS.register((Object)new ModEvents());
        TrinityFluids.renderFluids();
    }

    @Override
    public void registerRenderInfo() {
        MinecraftForge.EVENT_BUS.register((Object)new NuclearRender());
        AdvancedModelLoader.registerModelHandler(new HmfModelLoader());
        RenderingRegistry.registerEntityRenderingHandler(EntityNuclearCloud.class, (IRenderFactory)new RenderSmallNukeMK3Factory());
        RenderingRegistry.registerEntityRenderingHandler(EntityFalloutRain.class, (IRenderFactory)new RenderFalloutRainFactory());
        RenderingRegistry.registerEntityRenderingHandler(EntityDirtyBomb.class, (IRenderFactory)new RenderDirtyBombFactory());
        RenderingRegistry.registerEntityRenderingHandler(EntityThermalBlast.class, (IRenderFactory)new RenderThermalBlastFactory());
        RenderingRegistry.registerEntityRenderingHandler(EntityBlackHole.class, (IRenderFactory)new RenderBlackHoleFactory());
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
    }

    @Override
    public void postInit(FMLPostInitializationEvent postEvent) {
        super.postInit(postEvent);
    }

    @Override
    public void registerFluidBlockRendering(Block block, String name) {
        super.registerFluidBlockRendering(block, name);
        FluidStateMapper mapper = new FluidStateMapper(name);
        Item item = Item.func_150898_a((Block)block);
        ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[0]);
        ModelLoader.setCustomMeshDefinition((Item)item, (ItemMeshDefinition)mapper);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)mapper);
    }

    public static class FluidStateMapper
    extends StateMapperBase
    implements ItemMeshDefinition {
        public final ModelResourceLocation location;

        public FluidStateMapper(String name) {
            this.location = new ModelResourceLocation("trinity:fluids", name);
        }

        protected ModelResourceLocation func_178132_a(IBlockState state) {
            return this.location;
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            return this.location;
        }
    }

    public class NuclearRender {
        @SubscribeEvent(priority=EventPriority.LOWEST)
        public void renderNuclearEffects(RenderWorldLastEvent event) {
            List list = Minecraft.func_71410_x().field_71441_e.field_72996_f;
            for (Entity entity : list) {
                if (!(entity instanceof INuclearEffect)) continue;
                float partialTicks = Minecraft.func_71410_x().func_184121_ak();
                double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
                double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
                double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
                float f = entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * partialTicks;
                Entity entity2 = Minecraft.func_71410_x().func_175606_aa();
                double d3 = entity2.field_70142_S + (entity2.field_70165_t - entity2.field_70142_S) * (double)partialTicks;
                double d4 = entity2.field_70137_T + (entity2.field_70163_u - entity2.field_70137_T) * (double)partialTicks;
                double d5 = entity2.field_70136_U + (entity2.field_70161_v - entity2.field_70136_U) * (double)partialTicks;
                Render render = Minecraft.func_71410_x().func_175598_ae().func_78713_a(entity);
                render.func_76986_a(entity, d0 - d3, d1 - d4, d2 - d5, f, partialTicks);
            }
        }
    }

    public class RenderDirtyBombFactory
    implements IRenderFactory<EntityDirtyBomb> {
        public Render<? super EntityDirtyBomb> createRenderFor(RenderManager manager) {
            return new RenderPrimedDirtyBomb(manager);
        }
    }

    public class RenderBlackHoleFactory
    implements IRenderFactory<EntityBlackHole> {
        public Render<? super EntityBlackHole> createRenderFor(RenderManager manager) {
            return new RenderBlackHole(manager);
        }
    }

    public class RenderSmallNukeMK3Factory
    implements IRenderFactory<EntityNuclearCloud> {
        public Render<? super EntityNuclearCloud> createRenderFor(RenderManager manager) {
            return new RenderNuclearExplosion(manager);
        }
    }
}

