/*
 * Decompiled with CFR 0.152.
 */
package trinity.render;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinity.handler.Vec3;
import trinity.render.HmfController;
import trinity.render.Tessellator;
import trinity.render.TextureCoordinate;
import trinity.render.Vertex;

public class Face2 {
    public Vertex[] vertices;
    public Vertex[] vertexNormals;
    public Vertex faceNormal;
    public TextureCoordinate[] textureCoordinates;

    @SideOnly(value=Side.CLIENT)
    public void addFaceForRender(Tessellator tessellator) {
        this.addFaceForRender(tessellator, 5.0E-4f);
    }

    @SideOnly(value=Side.CLIENT)
    public void addFaceForRender(Tessellator tessellator, float textureOffset) {
        if (this.faceNormal == null) {
            this.faceNormal = this.calculateFaceNormal();
        }
        tessellator.setNormal(this.faceNormal.x, this.faceNormal.y, this.faceNormal.z);
        float averageU = 0.0f;
        float averageV = 0.0f;
        if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
            for (int i = 0; i < this.textureCoordinates.length; ++i) {
                averageU += this.textureCoordinates[i].u;
                averageV += this.textureCoordinates[i].v;
            }
            averageU /= (float)this.textureCoordinates.length;
            averageV /= (float)this.textureCoordinates.length;
        }
        for (int i = 0; i < this.vertices.length; ++i) {
            if (this.textureCoordinates != null && this.textureCoordinates.length > 0) {
                float offsetU = textureOffset;
                float offsetV = textureOffset;
                if (this.textureCoordinates[i].u > averageU) {
                    offsetU = -offsetU;
                }
                if (this.textureCoordinates[i].v > averageV) {
                    offsetV = -offsetV;
                }
                tessellator.addVertexWithUV(this.vertices[i].x, this.vertices[i].y, this.vertices[i].z, this.textureCoordinates[i].u + offsetU, (double)(this.textureCoordinates[i].v + offsetV) + (double)System.currentTimeMillis() % HmfController.modoloMod / HmfController.quotientMod);
                continue;
            }
            tessellator.addVertex(this.vertices[i].x, this.vertices[i].y, this.vertices[i].z);
        }
    }

    public Vertex calculateFaceNormal() {
        Vec3 v1 = Vec3.createVectorHelper(this.vertices[1].x - this.vertices[0].x, this.vertices[1].y - this.vertices[0].y, this.vertices[1].z - this.vertices[0].z);
        Vec3 v2 = Vec3.createVectorHelper(this.vertices[2].x - this.vertices[0].x, this.vertices[2].y - this.vertices[0].y, this.vertices[2].z - this.vertices[0].z);
        Vec3 normalVector = null;
        normalVector = v1.crossProduct(v2).normalize();
        return new Vertex((float)normalVector.xCoord, (float)normalVector.yCoord, (float)normalVector.zCoord);
    }
}

