/*
 * Decompiled with CFR 0.152.
 */
package trinity.render;

import java.util.ArrayList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import trinity.render.Face;
import trinity.render.Tessellator;

public class GroupObject {
    public String name;
    public ArrayList<Face> faces = new ArrayList();
    public int glDrawingMode;

    public GroupObject() {
        this("");
    }

    public GroupObject(String name) {
        this(name, -1);
    }

    public GroupObject(String name, int glDrawingMode) {
        this.name = name;
        this.glDrawingMode = glDrawingMode;
    }

    @SideOnly(value=Side.CLIENT)
    public void render() {
        if (this.faces.size() > 0) {
            Tessellator tessellator = Tessellator.instance;
            tessellator.startDrawing(this.glDrawingMode);
            this.render(tessellator);
            tessellator.draw();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void render(Tessellator tessellator) {
        if (this.faces.size() > 0) {
            for (Face face : this.faces) {
                face.addFaceForRender(tessellator);
            }
        }
    }
}

