/*
 * Decompiled with CFR 0.152.
 */
package trinity.render.entity;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.IRenderHandler;
import org.lwjgl.opengl.GL11;
import trinity.config.TrinityConfig;
import trinity.entities.EntityFalloutRain;
import trinity.handler.Vec3;

public class RenderFallout
extends Render<EntityFalloutRain> {
    private Minecraft mc;
    private Random random = new Random();
    float[] rainXCoords;
    float[] rainYCoords;
    private int rendererUpdateCount;
    private DynamicTexture lightmapTexture;
    private ResourceLocation locationLightMap;
    long lastTime = System.nanoTime();
    private static final ResourceLocation BLACK_RAIN_TEXTURES = new ResourceLocation("textures/environment/snow.png");
    private static final ResourceLocation falloutTexture = new ResourceLocation("trinity", "textures/fallout.png");
    private float previousPartialTicks = -1.0f;

    public RenderFallout(RenderManager renderManager) {
        super(renderManager);
        this.mc = Minecraft.func_71410_x();
        this.rainXCoords = new float[1024];
        this.rainYCoords = new float[1024];
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                this.rainXCoords[i << 5 | j] = -f1 / f2;
                this.rainYCoords[i << 5 | j] = f / f2;
            }
        }
    }

    public boolean shouldRender(EntityFalloutRain livingEntity, ICamera camera, double camX, double camY, double camZ) {
        return TrinityConfig.fallout_rendering;
    }

    public void doRender(EntityFalloutRain entity, double x, double y, double z, float entityYaw, float partialTicks) {
        if (TrinityConfig.fallout_rendering) {
            if (this.previousPartialTicks == partialTicks) {
                return;
            }
            this.previousPartialTicks = partialTicks;
            GL11.glPushMatrix();
            GL11.glDisable((int)2884);
            Entity ent = this.mc.func_175606_aa();
            Vec3 vector = Vec3.createVectorHelper(ent.field_70165_t - entity.field_70165_t, ent.field_70163_u - entity.field_70163_u, ent.field_70161_v - entity.field_70161_v);
            double d = vector.lengthVector();
            if (d <= (double)entity.getScale()) {
                ++this.rendererUpdateCount;
                long time = System.nanoTime();
                float t = (time - this.lastTime) / 50000000L;
                if (t <= 1.0f) {
                    this.renderRainSnow2(t);
                } else {
                    this.renderRainSnow2(1.0f);
                }
                this.lastTime = time;
            }
            GL11.glPopMatrix();
        }
    }

    protected void renderRainSnow(float p_78474_1_) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        IRenderHandler renderer = null;
        renderer = this.mc.field_71441_e.field_73011_w.getWeatherRenderer();
        if (renderer != null) {
            renderer.render(p_78474_1_, this.mc.field_71441_e, this.mc);
            return;
        }
        float f1 = 1.0f;
        if (f1 > 0.0f) {
            if (this.rainXCoords == null) {
                this.rainXCoords = new float[1024];
                this.rainYCoords = new float[1024];
                for (int i = 0; i < 32; ++i) {
                    for (int j = 0; j < 32; ++j) {
                        float f2 = j - 16;
                        float f3 = i - 16;
                        float f4 = MathHelper.func_76129_c((float)(f2 * f2 + f3 * f3));
                        this.rainXCoords[i << 5 | j] = -f3 / f4;
                        this.rainYCoords[i << 5 | j] = f2 / f4;
                    }
                }
            }
            Entity entitylivingbase = this.mc.func_175606_aa();
            WorldClient worldclient = this.mc.field_71441_e;
            int k2 = MathHelper.func_76128_c((double)entitylivingbase.field_70165_t);
            int l2 = MathHelper.func_76128_c((double)entitylivingbase.field_70163_u);
            int i3 = MathHelper.func_76128_c((double)entitylivingbase.field_70161_v);
            Tessellator tessellator = Tessellator.func_178181_a();
            GL11.glDisable((int)2884);
            GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glEnable((int)3042);
            OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
            GL11.glAlphaFunc((int)516, (float)0.1f);
            double d0 = entitylivingbase.field_70142_S + (entitylivingbase.field_70165_t - entitylivingbase.field_70142_S) * (double)p_78474_1_;
            double d1 = entitylivingbase.field_70137_T + (entitylivingbase.field_70163_u - entitylivingbase.field_70137_T) * (double)p_78474_1_;
            double d2 = entitylivingbase.field_70136_U + (entitylivingbase.field_70161_v - entitylivingbase.field_70136_U) * (double)p_78474_1_;
            int k = MathHelper.func_76128_c((double)d1);
            int b0 = 5;
            if (this.mc.field_71474_y.field_74347_j) {
                b0 = 10;
            }
            boolean flag = false;
            int b1 = -1;
            float f5 = (float)this.rendererUpdateCount + p_78474_1_;
            if (this.mc.field_71474_y.field_74347_j) {
                b0 = 10;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            flag = false;
            for (int l = i3 - b0; l <= i3 + b0; ++l) {
                for (int i1 = k2 - b0; i1 <= k2 + b0; ++i1) {
                    int j1 = (l - i3 + 16) * 32 + i1 - k2 + 16;
                    float f6 = this.rainXCoords[j1] * 0.5f;
                    float f7 = this.rainYCoords[j1] * 0.5f;
                    pos.func_181079_c(i1, 50, l);
                    Biome biomegenbase = worldclient.getBiomeForCoordsBody((BlockPos)pos);
                    int k1 = worldclient.func_175725_q((BlockPos)pos).func_177956_o();
                    int l1 = l2 - b0;
                    int i2 = l2 + b0;
                    if (l1 < k1) {
                        l1 = k1;
                    }
                    if (i2 < k1) {
                        i2 = k1;
                    }
                    float f8 = 1.0f;
                    int j2 = k1;
                    if (k1 < k) {
                        j2 = k;
                    }
                    if (l1 == i2) continue;
                    pos.func_185336_p(l1);
                    this.random.setSeed(i1 * i1 * 3121 + i1 * 45238971 ^ l * l * 418711 + l * 13761);
                    float f9 = biomegenbase.func_180626_a((BlockPos)pos);
                    if (b1 != 1) {
                        if (b1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        b1 = 1;
                        this.mc.func_110434_K().func_110577_a(falloutTexture);
                        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_181707_g);
                    }
                    float f10 = ((float)(this.rendererUpdateCount & 0x1FF) + p_78474_1_) / 512.0f;
                    float f16 = this.random.nextFloat() + f5 * 0.01f * (float)this.random.nextGaussian();
                    float f11 = this.random.nextFloat() + f5 * (float)this.random.nextGaussian() * 0.001f;
                    double d4 = (double)((float)i1 + 0.5f) - entitylivingbase.field_70165_t;
                    double d5 = (double)((float)l + 0.5f) - entitylivingbase.field_70161_v;
                    float f14 = MathHelper.func_76133_a((double)(d4 * d4 + d5 * d5)) / (float)b0;
                    float f15 = 1.0f;
                    BufferBuilder buf = tessellator.func_178180_c();
                    int bright = (int)(worldclient.func_175724_o((BlockPos)pos.func_181079_c(i1, j2, l)) * 3.0f + 3932220.0f);
                    buf.func_181666_a(f15, f15, f15, ((1.0f - f14 * f14) * 0.3f + 0.5f) * f1);
                    buf.func_178969_c(-d0 * 1.0, -d1 * 1.0, -d2 * 1.0);
                    buf.func_181662_b((double)((float)i1 - f6) + 0.5, (double)l1, (double)((float)l - f7) + 0.5).func_187315_a((double)(0.0f * f8 + f16), (double)((float)l1 * f8 / 4.0f + f10 * f8 + f11)).func_181675_d();
                    buf.func_181662_b((double)((float)i1 + f6) + 0.5, (double)l1, (double)((float)l + f7) + 0.5).func_187315_a((double)(1.0f * f8 + f16), (double)((float)l1 * f8 / 4.0f + f10 * f8 + f11)).func_181675_d();
                    buf.func_181662_b((double)((float)i1 + f6) + 0.5, (double)i2, (double)((float)l + f7) + 0.5).func_187315_a((double)(1.0f * f8 + f16), (double)((float)i2 * f8 / 4.0f + f10 * f8 + f11)).func_181675_d();
                    buf.func_181662_b((double)((float)i1 - f6) + 0.5, (double)i2, (double)((float)l - f7) + 0.5).func_187315_a((double)(0.0f * f8 + f16), (double)((float)i2 * f8 / 4.0f + f10 * f8 + f11)).func_181675_d();
                    buf.func_178969_c(0.0, 0.0, 0.0);
                }
            }
            if (b1 >= 0) {
                tessellator.func_78381_a();
            }
            GL11.glEnable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glAlphaFunc((int)516, (float)0.1f);
        }
    }

    protected void renderRainSnow2(float partialTicks) {
        float f = 1.0f;
        if (f > 0.0f) {
            GL11.glEnable((int)2896);
            Entity entity = this.mc.func_175606_aa();
            WorldClient world = this.mc.field_71441_e;
            int i = MathHelper.func_76128_c((double)entity.field_70165_t);
            int j = MathHelper.func_76128_c((double)entity.field_70163_u);
            int k = MathHelper.func_76128_c((double)entity.field_70161_v);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            GlStateManager.func_179129_p();
            GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            double d0 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double d1 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double d2 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            int l = MathHelper.func_76128_c((double)d1);
            int i1 = 5;
            if (this.mc.field_71474_y.field_74347_j) {
                i1 = 10;
            }
            int j1 = -1;
            float f1 = (float)this.rendererUpdateCount + partialTicks;
            bufferbuilder.func_178969_c(-d0, -d1, -d2);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
            for (int k1 = k - i1; k1 <= k + i1; ++k1) {
                for (int l1 = i - i1; l1 <= i + i1; ++l1) {
                    int i2 = (k1 - k + 16) * 32 + l1 - i + 16;
                    double d3 = (double)this.rainXCoords[i2] * 0.5;
                    double d4 = (double)this.rainYCoords[i2] * 0.5;
                    blockpos$mutableblockpos.func_181079_c(l1, 0, k1);
                    Biome biome = world.func_180494_b((BlockPos)blockpos$mutableblockpos);
                    int j2 = world.func_175725_q((BlockPos)blockpos$mutableblockpos).func_177956_o();
                    int k2 = j - i1;
                    int l2 = j + i1;
                    if (k2 < j2) {
                        k2 = j2;
                    }
                    if (l2 < j2) {
                        l2 = j2;
                    }
                    int i3 = j2;
                    if (j2 < l) {
                        i3 = l;
                    }
                    if (k2 == l2) continue;
                    this.random.setSeed(l1 * l1 * 3121 + l1 * 45238971 ^ k1 * k1 * 418711 + k1 * 13761);
                    blockpos$mutableblockpos.func_181079_c(l1, k2, k1);
                    float f2 = biome.func_180626_a((BlockPos)blockpos$mutableblockpos);
                    if (j1 != 1) {
                        if (j1 >= 0) {
                            tessellator.func_78381_a();
                        }
                        j1 = 1;
                        this.mc.func_110434_K().func_110577_a(falloutTexture);
                        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    double d8 = -((float)(this.rendererUpdateCount & 0x1FF) + partialTicks) / 512.0f;
                    double d9 = this.random.nextDouble() + (double)f1 * 0.01 * (double)((float)this.random.nextGaussian());
                    double d10 = this.random.nextDouble() + (double)(f1 * (float)this.random.nextGaussian()) * 0.001;
                    double d11 = (double)((float)l1 + 0.5f) - entity.field_70165_t;
                    double d12 = (double)((float)k1 + 0.5f) - entity.field_70161_v;
                    float f6 = MathHelper.func_76133_a((double)(d11 * d11 + d12 * d12)) / (float)i1;
                    float f5 = ((1.0f - f6 * f6) * 0.3f + 0.5f) * f;
                    blockpos$mutableblockpos.func_181079_c(l1, i3, k1);
                    int i4 = (world.func_175626_b((BlockPos)blockpos$mutableblockpos, 0) * 3 + 0xF000F0) / 4;
                    int j4 = i4 >> 16 & 0xFFFF;
                    int k4 = i4 & 0xFFFF;
                    bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)l2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)l2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)k2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 + d3 + 0.5, (double)k2, (double)k1 + d4 + 0.5).func_187315_a(1.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                    bufferbuilder.func_181662_b((double)l1 - d3 + 0.5, (double)k2, (double)k1 - d4 + 0.5).func_187315_a(0.0 + d9, (double)l2 * 0.25 + d8 + d10).func_181666_a(1.0f, 1.0f, 1.0f, f5).func_187314_a(j4, k4).func_181675_d();
                }
            }
            if (j1 >= 0) {
                tessellator.func_78381_a();
            }
            bufferbuilder.func_178969_c(0.0, 0.0, 0.0);
            GlStateManager.func_179089_o();
            GlStateManager.func_179084_k();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GL11.glDisable((int)2896);
        }
    }

    protected ResourceLocation getEntityTexture(EntityFalloutRain entity) {
        return null;
    }
}

