/*
 * Decompiled with CFR 0.152.
 */
package trinity.render.entity;

import java.util.Random;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import trinity.entities.EntityNuclearCloud;
import trinity.render.AdvancedModelLoader;
import trinity.render.IModelCustom;
import trinity.render.Tessellator;
import trinity.util.ResourceManager;

public class RenderNuclearExplosion
extends Render<EntityNuclearCloud> {
    private IModelCustom blastModel = AdvancedModelLoader.loadModel(ResourceManager.objTesterModelRL);
    private IModelCustom ringModel = AdvancedModelLoader.loadModel(ResourceManager.ringModelRL);
    private IModelCustom ringBigModel = AdvancedModelLoader.loadModel(ResourceManager.ringBigModelRL);
    public float scale = 0.0f;
    public float ring = 0.0f;
    private float previousPartialTicks = -1.0f;

    public RenderNuclearExplosion(RenderManager renderManager) {
        super(renderManager);
    }

    public boolean shouldRender(EntityNuclearCloud livingEntity, ICamera camera, double camX, double camY, double camZ) {
        return true;
    }

    public void doRender(EntityNuclearCloud cloud, double x, double y, double z, float entityYaw, float partialTicks) {
        float f1;
        if (this.previousPartialTicks == partialTicks) {
            return;
        }
        this.previousPartialTicks = partialTicks;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)16448);
        GL11.glTranslatef((float)((float)x), (float)((float)y + 0.25f), (float)((float)z));
        GL11.glDisable((int)2896);
        GL11.glEnable((int)2884);
        float size = ((Float)cloud.func_184212_Q().func_187225_a(EntityNuclearCloud.SCALE)).floatValue();
        GL11.glScalef((float)size, (float)size, (float)size);
        int age = cloud.age;
        int shockScale = age * 4;
        int fireScale = (int)((double)(age - 25) * 1.5);
        if (age < 50) {
            GL11.glPushMatrix();
            GL11.glColor4f((float)0.2f, (float)0.2f, (float)0.2f, (float)0.9f);
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glScalef((float)shockScale, (float)shockScale, (float)shockScale);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            for (float i = 0.9f; i <= 1.0f; i += 0.05f) {
                GL11.glScalef((float)i, (float)i, (float)i);
                ResourceManager.sphere_ruv.renderAll();
                ResourceManager.sphere_iuv.renderAll();
                GL11.glScalef((float)(1.0f / i), (float)(1.0f / i), (float)(1.0f / i));
            }
            GL11.glDisable((int)3042);
            GL11.glColor4f((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
            GL11.glScalef((float)0.6f, (float)(1.0f / (float)shockScale * 5.0f), (float)0.6f);
            this.ringModel.renderAll();
            GL11.glScalef((float)1.1f, (float)1.0f, (float)1.1f);
            this.ringModel.renderAll();
            GL11.glScalef((float)1.1f, (float)1.0f, (float)1.1f);
            this.ringModel.renderAll();
            GL11.glEnable((int)3553);
            GL11.glPopMatrix();
            Tessellator tessellator = Tessellator.instance;
            RenderHelper.func_74518_a();
            f1 = ((float)cloud.field_70173_aa + 2.0f) / 200.0f;
            float f2 = 0.0f;
            int count = 250;
            if (cloud.field_70173_aa < 250) {
                count = cloud.field_70173_aa * 3;
            }
            if (f1 > 0.8f) {
                f2 = (f1 - 0.8f) / 0.2f;
            }
            Random random = new Random(432L);
            GL11.glDisable((int)3553);
            GL11.glShadeModel((int)7425);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glDisable((int)3008);
            GL11.glEnable((int)2884);
            GL11.glDepthMask((boolean)false);
            GL11.glPushMatrix();
            GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
            GL11.glScalef((float)shockScale, (float)shockScale, (float)shockScale);
            for (int i = 0; i < count; ++i) {
                GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)(random.nextFloat() * 360.0f), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(random.nextFloat() * 360.0f + f1 * 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
                tessellator.startDrawing(6);
                float f3 = random.nextFloat() * 20.0f + 5.0f + f2 * 10.0f;
                float f4 = random.nextFloat() * 2.0f + 1.0f + f2 * 2.0f;
                tessellator.setColorRGBA_I(59345715, (int)(255.0f * (1.0f - f2)));
                tessellator.addVertex(0.0, 0.0, 0.0);
                tessellator.setColorRGBA_I(59345735, 0);
                tessellator.addVertex(-0.866 * (double)f4, f3, -0.5f * f4);
                tessellator.addVertex(0.866 * (double)f4, f3, -0.5f * f4);
                tessellator.addVertex(0.0, f3, 1.0f * f4);
                tessellator.addVertex(-0.866 * (double)f4, f3, -0.5f * f4);
                tessellator.draw();
            }
            GL11.glPopMatrix();
            GL11.glDepthMask((boolean)true);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3042);
            GL11.glShadeModel((int)7424);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            GL11.glEnable((int)3008);
            RenderHelper.func_74519_b();
        }
        if (age >= 50 && age < 150) {
            GL11.glPushMatrix();
            if ((Byte)cloud.func_184212_Q().func_187225_a(EntityNuclearCloud.SOMETHING) == 1) {
                GL11.glColor4f((float)0.2f, (float)0.7f, (float)0.0f, (float)0.9f);
            } else {
                GL11.glColor4f((float)0.4f, (float)0.15f, (float)0.0f, (float)0.9f);
            }
            GL11.glDisable((int)3553);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)1);
            GL11.glTranslatef((float)0.0f, (float)((float)fireScale * 0.75f), (float)0.0f);
            GL11.glScalef((float)((float)fireScale * 0.85f), (float)fireScale, (float)((float)fireScale * 0.85f));
            for (float i = 0.6f; i <= 1.0f; i += 0.2f) {
                GL11.glScalef((float)i, (float)i, (float)i);
                ResourceManager.sphere_ruv.renderAll();
                GL11.glScalef((float)(1.0f / i), (float)(1.0f / i), (float)(1.0f / i));
            }
            GL11.glDisable((int)3042);
            GL11.glEnable((int)3553);
            GL11.glPopMatrix();
        }
        if (age >= 150) {
            GL11.glPushMatrix();
            this.func_110776_a(this.getEntityTexture(cloud));
            GL11.glTranslatef((float)0.0f, (float)-40.0f, (float)0.0f);
            GL11.glScalef((float)6.0f, (float)6.0f, (float)6.0f);
            GL11.glDisable((int)2884);
            this.blastModel.renderAll();
            GL11.glEnable((int)2884);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glDisable((int)3553);
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            GL11.glColor4f((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
            GL11.glScalef((float)10.0f, (float)10.0f, (float)10.0f);
            float f = 1.8f + (float)Math.sin((double)age / 20.0 + 90.0) * 0.25f * 0.5f;
            f1 = 1.0f + (float)Math.sin((double)age / 10.0) * 0.15f;
            GL11.glScalef((float)f, (float)1.0f, (float)f);
            GL11.glTranslatef((float)0.0f, (float)(3.5f + f1 * 0.25f), (float)0.0f);
            this.ringModel.renderAll();
            GL11.glTranslatef((float)0.0f, (float)(-f1 * 0.25f * 2.0f), (float)0.0f);
            this.ringModel.renderAll();
            GL11.glEnable((int)3553);
            GL11.glPopMatrix();
        }
        if (age >= 50) {
            GL11.glPushMatrix();
            GL11.glDisable((int)3553);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            GL11.glColor4f((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
            float f = (float)Math.min((double)(age - 50) * 0.5, 20.0);
            GL11.glScalef((float)f, (float)15.0f, (float)f);
            GL11.glScalef((float)1.5f, (float)1.0f, (float)1.5f);
            GL11.glTranslatef((float)0.0f, (float)-0.15f, (float)0.0f);
            GL11.glScalef((float)1.5f, (float)1.0f, (float)1.5f);
            GL11.glTranslatef((float)0.0f, (float)-0.15f, (float)0.0f);
            GL11.glEnable((int)3553);
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glDisable((int)3553);
            GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
            GL11.glColor4f((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
            float f0 = (float)Math.min((double)(age - 50) * 0.25, 20.0) * 5.0f;
            GL11.glScalef((float)f0, (float)15.0f, (float)f0);
            GL11.glTranslatef((float)0.0f, (float)3.5f, (float)0.0f);
            this.ringBigModel.renderAll();
            GL11.glTranslatef((float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glScalef((float)0.65f, (float)1.0f, (float)0.65f);
            this.ringModel.renderAll();
            GL11.glEnable((int)3553);
            GL11.glPopMatrix();
        }
        GL11.glEnable((int)2896);
        GL11.glDisable((int)2884);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    protected ResourceLocation getEntityTexture(EntityNuclearCloud entity) {
        return ResourceManager.fireball;
    }
}

