/*
 * Decompiled with CFR 0.152.
 */
package trinity.tiles;

import java.util.Arrays;
import nc.capability.radiation.resistance.IRadiationResistance;
import nc.capability.radiation.source.IRadiationSource;
import nc.radiation.RadiationHelper;
import nc.util.NCMath;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import trinity.blocks.ShieldedContainer;
import trinity.items.RadioactiveSource2;

public class TileEntityShieldedContainer
extends TileEntity
implements IInventory {
    private final int NUMBER_OF_SLOTS = 9;
    private ItemStack[] itemStacks = new ItemStack[9];

    public TileEntityShieldedContainer() {
        this.func_174888_l();
    }

    public int func_70302_i_() {
        return this.itemStacks.length;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.itemStacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void onLoad() {
        IRadiationResistance resistance = (IRadiationResistance)this.getCapability(IRadiationResistance.CAPABILITY_RADIATION_RESISTANCE, null);
        if (resistance == null) {
            return;
        }
        Block block = this.func_145838_q();
        if (block instanceof ShieldedContainer) {
            ShieldedContainer shield = (ShieldedContainer)block;
            resistance.setShieldingRadResistance(Math.exp(Double.POSITIVE_INFINITY));
        }
    }

    public ItemStack func_70301_a(int slotIndex) {
        return this.itemStacks[slotIndex];
    }

    public ItemStack func_70298_a(int slotIndex, int count) {
        ItemStack itemStackRemoved;
        ItemStack itemStackInSlot = this.func_70301_a(slotIndex);
        if (itemStackInSlot.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (itemStackInSlot.func_190916_E() <= count) {
            itemStackRemoved = itemStackInSlot;
            this.func_70299_a(slotIndex, ItemStack.field_190927_a);
        } else {
            itemStackRemoved = itemStackInSlot.func_77979_a(count);
            if (itemStackInSlot.func_190916_E() == 0) {
                this.func_70299_a(slotIndex, ItemStack.field_190927_a);
            }
        }
        this.func_70296_d();
        return itemStackRemoved;
    }

    public void func_70299_a(int slotIndex, ItemStack itemstack) {
        this.itemStacks[slotIndex] = itemstack;
        if (itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
            itemstack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        double X_CENTRE_OFFSET = 0.5;
        double Y_CENTRE_OFFSET = 0.5;
        double Z_CENTRE_OFFSET = 0.5;
        double MAXIMUM_DISTANCE_SQ = 64.0;
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    public boolean func_94041_b(int slotIndex, ItemStack itemstack) {
        return true;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound parentNBTTagCompound) {
        super.func_189515_b(parentNBTTagCompound);
        NBTTagList dataForAllSlots = new NBTTagList();
        for (int i = 0; i < this.itemStacks.length; ++i) {
            if (this.itemStacks[i].func_190926_b()) continue;
            NBTTagCompound dataForThisSlot = new NBTTagCompound();
            dataForThisSlot.func_74774_a("Slot", (byte)i);
            this.itemStacks[i].func_77955_b(dataForThisSlot);
            dataForAllSlots.func_74742_a((NBTBase)dataForThisSlot);
        }
        parentNBTTagCompound.func_74782_a("Items", (NBTBase)dataForAllSlots);
        return parentNBTTagCompound;
    }

    public double getRadioactivity() {
        double rads = 0.0;
        for (int i = 0; i < this.itemStacks.length; ++i) {
            IRadiationSource stackSource;
            if (this.itemStacks[i].func_190926_b() || (stackSource = RadiationHelper.getRadiationSource((ICapabilityProvider)this.itemStacks[i])) == null && !(this.itemStacks[i].func_77973_b() instanceof RadioactiveSource2)) continue;
            rads += stackSource.getRadiationLevel() * (double)this.itemStacks[i].func_190916_E();
        }
        return rads;
    }

    public double getShielding() {
        Block block = this.func_145838_q();
        if (block instanceof ShieldedContainer) {
            ShieldedContainer shield = (ShieldedContainer)block;
            return shield.shielding;
        }
        return 0.0;
    }

    public double getRadiation() {
        double rads = this.getRadioactivity();
        double shieldedRads = 0.0;
        shieldedRads = NCMath.sq((double)rads) / (rads + (Math.exp(this.getShielding()) - 1.0));
        return shieldedRads;
    }

    public void func_145839_a(NBTTagCompound parentNBTTagCompound) {
        super.func_145839_a(parentNBTTagCompound);
        int NBT_TYPE_COMPOUND = 10;
        NBTTagList dataForAllSlots = parentNBTTagCompound.func_150295_c("Items", 10);
        Arrays.fill(this.itemStacks, ItemStack.field_190927_a);
        for (int i = 0; i < dataForAllSlots.func_74745_c(); ++i) {
            NBTTagCompound dataForOneSlot = dataForAllSlots.func_150305_b(i);
            int slotIndex = dataForOneSlot.func_74771_c("Slot") & 0xFF;
            if (slotIndex < 0 || slotIndex >= this.itemStacks.length) continue;
            this.itemStacks[slotIndex] = new ItemStack(dataForOneSlot);
        }
    }

    public void func_174888_l() {
        Arrays.fill(this.itemStacks, ItemStack.field_190927_a);
    }

    public String func_70005_c_() {
        return "container.nuclear_pig.name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return this.func_145818_k_() ? new TextComponentString(this.func_70005_c_()) : new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    public ItemStack func_70304_b(int slotIndex) {
        ItemStack itemStack = this.func_70301_a(slotIndex);
        if (!itemStack.func_190926_b()) {
            this.func_70299_a(slotIndex, ItemStack.field_190927_a);
        }
        return itemStack;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }
}

