/*
 * Decompiled with CFR 0.152.
 */
package trinity.util;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import trinity.blocks.ThermonuclearCore;

public class ThermonuclearBomb {
    public int blastRadius;
    public boolean salted;
    private static Set<Block> lead = null;
    private static Set<Block> uranium238 = null;
    private static Set<Block> neptunium = null;
    private static Set<Block> plutonium = null;
    private static Set<Block> salt = null;

    public static Set<Block> getSaltingBlocks() {
        if (salt != null) {
            return salt;
        }
        salt = Sets.newHashSet();
        NonNullList zinc = OreDictionary.getOres((String)"blockZinc");
        for (Object stack : zinc) {
            ItemBlock itemBlock;
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemBlock) || (itemBlock = (ItemBlock)item).func_179223_d() == null) continue;
            salt.add(itemBlock.func_179223_d());
        }
        NonNullList cobalt = OreDictionary.getOres((String)"blockCobalt");
        for (ItemStack stack : cobalt) {
            ItemBlock itemBlock;
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemBlock) || (itemBlock = (ItemBlock)item).func_179223_d() == null) continue;
            salt.add(itemBlock.func_179223_d());
        }
        NonNullList gold = OreDictionary.getOres((String)"blockGold");
        for (ItemStack stack : gold) {
            ItemBlock itemBlock;
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemBlock) || (itemBlock = (ItemBlock)item).func_179223_d() == null) continue;
            salt.add(itemBlock.func_179223_d());
        }
        return null;
    }

    public static Set<Block> getPlutoniumBlocks() {
        if (plutonium != null) {
            return plutonium;
        }
        plutonium = Sets.newHashSet();
        NonNullList stacks = OreDictionary.getOres((String)"blockPlutonium242");
        for (ItemStack stack : stacks) {
            ItemBlock itemBlock;
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemBlock) || (itemBlock = (ItemBlock)item).func_179223_d() == null) continue;
            plutonium.add(itemBlock.func_179223_d());
        }
        return plutonium;
    }

    public static Set<Block> getNeptuniumBlocks() {
        if (neptunium != null) {
            return neptunium;
        }
        neptunium = Sets.newHashSet();
        NonNullList stacks = OreDictionary.getOres((String)"blockNeptunium237");
        for (ItemStack stack : stacks) {
            ItemBlock itemBlock;
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemBlock) || (itemBlock = (ItemBlock)item).func_179223_d() == null) continue;
            neptunium.add(itemBlock.func_179223_d());
        }
        return neptunium;
    }

    public static Set<Block> getUranium238Blocks() {
        if (uranium238 != null) {
            return uranium238;
        }
        uranium238 = Sets.newHashSet();
        NonNullList stacks2 = OreDictionary.getOres((String)"blockUranium238");
        for (ItemStack stack : stacks2) {
            ItemBlock itemBlock;
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemBlock) || (itemBlock = (ItemBlock)item).func_179223_d() == null) continue;
            uranium238.add(itemBlock.func_179223_d());
        }
        return uranium238;
    }

    public static Set<Block> getLeadBlocks() {
        if (lead != null) {
            return lead;
        }
        lead = Sets.newHashSet();
        NonNullList stacks = OreDictionary.getOres((String)"blockLead");
        for (ItemStack stack : stacks) {
            ItemBlock itemBlock;
            Item item = stack.func_77973_b();
            if (!(item instanceof ItemBlock) || (itemBlock = (ItemBlock)item).func_179223_d() == null) continue;
            lead.add(itemBlock.func_179223_d());
        }
        return lead;
    }

    public static boolean isSaltingAgent(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return ThermonuclearBomb.getSaltingBlocks() != null && ThermonuclearBomb.getSaltingBlocks().contains(block);
    }

    public static boolean isFissionable(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (ThermonuclearBomb.getUranium238Blocks() != null && ThermonuclearBomb.getUranium238Blocks().contains(block)) {
            return true;
        }
        if (ThermonuclearBomb.getNeptuniumBlocks() != null && ThermonuclearBomb.getNeptuniumBlocks().contains(block)) {
            return true;
        }
        return ThermonuclearBomb.getPlutoniumBlocks() != null && ThermonuclearBomb.getPlutoniumBlocks().contains(block);
    }

    public static boolean isLead(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return ThermonuclearBomb.getLeadBlocks() != null && ThermonuclearBomb.getLeadBlocks().contains(block);
    }

    public static boolean isValidTamper(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (ThermonuclearBomb.getLeadBlocks() != null && ThermonuclearBomb.getLeadBlocks().contains(block)) {
            return true;
        }
        if (ThermonuclearBomb.getUranium238Blocks() != null && ThermonuclearBomb.getUranium238Blocks().contains(block)) {
            return true;
        }
        if (ThermonuclearBomb.getNeptuniumBlocks() != null && ThermonuclearBomb.getNeptuniumBlocks().contains(block)) {
            return true;
        }
        if (ThermonuclearBomb.getPlutoniumBlocks() != null && ThermonuclearBomb.getPlutoniumBlocks().contains(block)) {
            return true;
        }
        return ThermonuclearBomb.getSaltingBlocks() != null && ThermonuclearBomb.getSaltingBlocks().contains(block);
    }

    public static double ThermonuclearMultiplier(World world, BlockPos pos, boolean salt) {
        int z;
        int x;
        boolean t4;
        boolean t3;
        boolean t2;
        boolean b1;
        IBlockState s5;
        IBlockState s4;
        IBlockState s3;
        IBlockState s2;
        IBlockState s1;
        BlockPos p5;
        BlockPos p4;
        BlockPos p3;
        BlockPos p2;
        BlockPos p1;
        int y;
        int fission1 = 0;
        int inert1 = 0;
        int salted1 = 0;
        int fission2 = 0;
        int inert2 = 0;
        int salted2 = 0;
        int fission3 = 0;
        int inert3 = 0;
        int salted3 = 0;
        int fission4 = 0;
        int inert4 = 0;
        int salted4 = 0;
        int fission = 0;
        int inert = 0;
        int salted = 0;
        int startpoint = pos.func_177956_o() + 1;
        int endpoint = pos.func_177956_o() + 3;
        int startpoint2 = pos.func_177956_o() - 1;
        int endpoint2 = pos.func_177956_o() - 3;
        int startpoint3 = pos.func_177958_n() + 1;
        int endpoint3 = pos.func_177958_n() + 3;
        int startpoint4 = pos.func_177958_n() - 1;
        int endpoint4 = pos.func_177958_n() - 3;
        int startpoint5 = pos.func_177952_p() + 1;
        int endpoint5 = pos.func_177952_p() + 3;
        int startpoint6 = pos.func_177952_p() - 1;
        int endpoint6 = pos.func_177952_p() - 3;
        int depth1 = 0;
        int depth2 = 0;
        int depth3 = 0;
        int depth4 = 0;
        for (y = startpoint; y <= endpoint; ++y) {
            p1 = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
            p2 = new BlockPos(pos.func_177958_n() + 1, y, pos.func_177952_p());
            p3 = new BlockPos(pos.func_177958_n() - 1, y, pos.func_177952_p());
            p4 = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p() + 1);
            p5 = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p() - 1);
            s1 = world.func_180495_p(p1);
            s2 = world.func_180495_p(p1);
            s3 = world.func_180495_p(p1);
            s4 = world.func_180495_p(p1);
            s5 = world.func_180495_p(p1);
            b1 = s1.func_177230_c() instanceof ThermonuclearCore && (s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.UP || s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.DOWN);
            Block block = world.func_180495_p(pos).func_177230_c();
            boolean t1 = ThermonuclearBomb.isValidTamper(world, p2);
            boolean t22 = ThermonuclearBomb.isValidTamper(world, p3);
            boolean t32 = ThermonuclearBomb.isValidTamper(world, p4);
            boolean t42 = ThermonuclearBomb.isValidTamper(world, p5);
            if (t1 && ++depth1 <= 3) {
                if (ThermonuclearBomb.isLead(world, p2)) {
                    ++inert1;
                }
                if (ThermonuclearBomb.isFissionable(world, p2)) {
                    ++fission1;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p2)) {
                    ++salted1;
                }
            }
            if (t22 && ++depth2 <= 3) {
                if (ThermonuclearBomb.isLead(world, p3)) {
                    ++inert2;
                }
                if (ThermonuclearBomb.isFissionable(world, p3)) {
                    ++fission2;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p3)) {
                    ++salted2;
                }
            }
            if (t32 && ++depth3 <= 3) {
                if (ThermonuclearBomb.isLead(world, p4)) {
                    ++inert3;
                }
                if (ThermonuclearBomb.isFissionable(world, p4)) {
                    ++fission3;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p4)) {
                    ++salted3;
                }
            }
            if (t42) {
                if (++depth4 <= 3) {
                    if (ThermonuclearBomb.isLead(world, p5)) {
                        ++inert4;
                    }
                    if (ThermonuclearBomb.isFissionable(world, p5)) {
                        ++fission4;
                    }
                    if (ThermonuclearBomb.isSaltingAgent(world, p5)) {
                        ++salted4;
                    }
                }
            } else {
                if (!b1 || !t1 || !t22 || !t32 || !t42) break;
                return 0.0;
            }
            inert = inert1 + inert2 + inert3 + inert4;
            fission = fission1 + fission2 + fission3 + fission4;
            salted = salted1 + salted2 + salted3 + salted4;
        }
        for (y = endpoint2; y <= startpoint2; ++y) {
            p1 = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
            p2 = new BlockPos(pos.func_177958_n() + 1, y, pos.func_177952_p());
            p3 = new BlockPos(pos.func_177958_n() - 1, y, pos.func_177952_p());
            p4 = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p() + 1);
            p5 = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p() - 1);
            s1 = world.func_180495_p(p1);
            s2 = world.func_180495_p(p1);
            s3 = world.func_180495_p(p1);
            s4 = world.func_180495_p(p1);
            s5 = world.func_180495_p(p1);
            b1 = s1.func_177230_c() instanceof ThermonuclearCore && (s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.UP || s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.DOWN);
            boolean t1 = ThermonuclearBomb.isValidTamper(world, p2);
            t2 = ThermonuclearBomb.isValidTamper(world, p3);
            t3 = ThermonuclearBomb.isValidTamper(world, p4);
            t4 = ThermonuclearBomb.isValidTamper(world, p5);
            if (t1 && ++depth1 <= 3) {
                if (ThermonuclearBomb.isLead(world, p2)) {
                    ++inert1;
                }
                if (ThermonuclearBomb.isFissionable(world, p2)) {
                    ++fission1;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p2)) {
                    ++salted1;
                }
            }
            if (t2 && ++depth2 <= 3) {
                if (ThermonuclearBomb.isLead(world, p3)) {
                    ++inert2;
                }
                if (ThermonuclearBomb.isFissionable(world, p3)) {
                    ++fission2;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p3)) {
                    ++salted2;
                }
            }
            if (t3 && ++depth3 <= 3) {
                if (ThermonuclearBomb.isLead(world, p4)) {
                    ++inert3;
                }
                if (ThermonuclearBomb.isFissionable(world, p4)) {
                    ++fission3;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p4)) {
                    ++salted3;
                }
            }
            if (t4) {
                if (++depth4 <= 3) {
                    if (ThermonuclearBomb.isLead(world, p5)) {
                        ++inert4;
                    }
                    if (ThermonuclearBomb.isFissionable(world, p5)) {
                        ++fission4;
                    }
                    if (ThermonuclearBomb.isSaltingAgent(world, p5)) {
                        ++salted4;
                    }
                }
            } else {
                if (!b1 || !t1 || !t2 || !t3 || !t4) break;
                return 0.0;
            }
            fission = fission1 + fission2 + fission3 + fission4;
            inert = inert1 + inert2 + inert3 + inert4;
            salted = salted1 + salted2 + salted3 + salted4;
        }
        for (x = startpoint3; x <= endpoint3; ++x) {
            p1 = new BlockPos(x, pos.func_177956_o(), pos.func_177952_p());
            p2 = new BlockPos(x, pos.func_177956_o() + 1, pos.func_177952_p());
            p3 = new BlockPos(x, pos.func_177956_o() - 1, pos.func_177952_p());
            p4 = new BlockPos(x, pos.func_177956_o(), pos.func_177952_p() + 1);
            p5 = new BlockPos(x, pos.func_177956_o(), pos.func_177952_p() - 1);
            s1 = world.func_180495_p(p1);
            s2 = world.func_180495_p(p1);
            s3 = world.func_180495_p(p1);
            s4 = world.func_180495_p(p1);
            s5 = world.func_180495_p(p1);
            b1 = s1.func_177230_c() instanceof ThermonuclearCore && (s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.WEST || s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.EAST);
            boolean t1 = ThermonuclearBomb.isValidTamper(world, p2);
            t2 = ThermonuclearBomb.isValidTamper(world, p3);
            t3 = ThermonuclearBomb.isValidTamper(world, p4);
            t4 = ThermonuclearBomb.isValidTamper(world, p5);
            if (t1 && ++depth1 <= 3) {
                if (ThermonuclearBomb.isLead(world, p2)) {
                    ++inert1;
                }
                if (ThermonuclearBomb.isFissionable(world, p2)) {
                    ++fission1;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p2)) {
                    ++salted1;
                }
            }
            if (t2 && ++depth2 <= 3) {
                if (ThermonuclearBomb.isLead(world, p3)) {
                    ++inert2;
                }
                if (ThermonuclearBomb.isFissionable(world, p3)) {
                    ++fission2;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p3)) {
                    ++salted2;
                }
            }
            if (t3 && ++depth3 <= 3) {
                if (ThermonuclearBomb.isLead(world, p4)) {
                    ++inert3;
                }
                if (ThermonuclearBomb.isFissionable(world, p4)) {
                    ++fission3;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p4)) {
                    ++salted3;
                }
            }
            if (t4) {
                if (++depth4 <= 3) {
                    if (ThermonuclearBomb.isLead(world, p5)) {
                        ++inert4;
                    }
                    if (ThermonuclearBomb.isFissionable(world, p5)) {
                        ++fission4;
                    }
                    if (ThermonuclearBomb.isSaltingAgent(world, p5)) {
                        ++salted4;
                    }
                }
            } else {
                if (!b1 || !t1 || !t2 || !t3 || !t4) break;
                return 0.0;
            }
            fission = fission1 + fission2 + fission3 + fission4;
            inert = inert1 + inert2 + inert3 + inert4;
            salted = salted1 + salted2 + salted3 + salted4;
        }
        for (x = endpoint4; x <= startpoint4; ++x) {
            p1 = new BlockPos(x, pos.func_177956_o(), pos.func_177952_p());
            p2 = new BlockPos(x, pos.func_177956_o() + 1, pos.func_177952_p());
            p3 = new BlockPos(x, pos.func_177956_o() - 1, pos.func_177952_p());
            p4 = new BlockPos(x, pos.func_177956_o(), pos.func_177952_p() + 1);
            p5 = new BlockPos(x, pos.func_177956_o(), pos.func_177952_p() - 1);
            s1 = world.func_180495_p(p1);
            s2 = world.func_180495_p(p1);
            s3 = world.func_180495_p(p1);
            s4 = world.func_180495_p(p1);
            s5 = world.func_180495_p(p1);
            b1 = s1.func_177230_c() instanceof ThermonuclearCore && (s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.WEST || s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.EAST);
            boolean t1 = ThermonuclearBomb.isValidTamper(world, p2);
            t2 = ThermonuclearBomb.isValidTamper(world, p3);
            t3 = ThermonuclearBomb.isValidTamper(world, p4);
            t4 = ThermonuclearBomb.isValidTamper(world, p5);
            if (t1 && ++depth1 <= 3) {
                if (ThermonuclearBomb.isLead(world, p2)) {
                    ++inert1;
                }
                if (ThermonuclearBomb.isFissionable(world, p2)) {
                    ++fission1;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p2)) {
                    ++salted1;
                }
            }
            if (t2 && ++depth2 <= 3) {
                if (ThermonuclearBomb.isLead(world, p3)) {
                    ++inert2;
                }
                if (ThermonuclearBomb.isFissionable(world, p3)) {
                    ++fission2;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p3)) {
                    ++salted2;
                }
            }
            if (t3 && ++depth3 <= 3) {
                if (ThermonuclearBomb.isLead(world, p4)) {
                    ++inert3;
                }
                if (ThermonuclearBomb.isFissionable(world, p4)) {
                    ++fission3;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p4)) {
                    ++salted3;
                }
            }
            if (t4) {
                if (++depth4 <= 3) {
                    if (ThermonuclearBomb.isLead(world, p5)) {
                        ++inert4;
                    }
                    if (ThermonuclearBomb.isFissionable(world, p5)) {
                        ++fission4;
                    }
                    if (ThermonuclearBomb.isSaltingAgent(world, p5)) {
                        ++salted4;
                    }
                }
            } else {
                if (!b1 || !t1 || !t2 || !t3 || !t4) break;
                return 0.0;
            }
            fission = fission1 + fission2 + fission3 + fission4;
            inert = inert1 + inert2 + inert3 + inert4;
            salted = salted1 + salted2 + salted3 + salted4;
        }
        for (z = startpoint5; z <= endpoint5; ++z) {
            p1 = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), z);
            p2 = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, z);
            p3 = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, z);
            p4 = new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), z);
            p5 = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), z);
            s1 = world.func_180495_p(p1);
            s2 = world.func_180495_p(p1);
            s3 = world.func_180495_p(p1);
            s4 = world.func_180495_p(p1);
            s5 = world.func_180495_p(p1);
            b1 = s1.func_177230_c() instanceof ThermonuclearCore && (s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.NORTH || s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.SOUTH);
            boolean t1 = ThermonuclearBomb.isValidTamper(world, p2);
            t2 = ThermonuclearBomb.isValidTamper(world, p3);
            t3 = ThermonuclearBomb.isValidTamper(world, p4);
            t4 = ThermonuclearBomb.isValidTamper(world, p5);
            if (t1 && ++depth1 <= 3) {
                if (ThermonuclearBomb.isLead(world, p2)) {
                    ++inert1;
                }
                if (ThermonuclearBomb.isFissionable(world, p2)) {
                    ++fission1;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p2)) {
                    ++salted1;
                }
            }
            if (t2 && ++depth2 <= 3) {
                if (ThermonuclearBomb.isLead(world, p3)) {
                    ++inert2;
                }
                if (ThermonuclearBomb.isFissionable(world, p3)) {
                    ++fission2;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p3)) {
                    ++salted2;
                }
            }
            if (t3 && ++depth3 <= 3) {
                if (ThermonuclearBomb.isLead(world, p4)) {
                    ++inert3;
                }
                if (ThermonuclearBomb.isFissionable(world, p4)) {
                    ++fission3;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p4)) {
                    ++salted3;
                }
            }
            if (t4) {
                if (++depth4 <= 3) {
                    if (ThermonuclearBomb.isLead(world, p5)) {
                        ++inert4;
                    }
                    if (ThermonuclearBomb.isFissionable(world, p5)) {
                        ++fission4;
                    }
                    if (ThermonuclearBomb.isSaltingAgent(world, p5)) {
                        ++salted4;
                    }
                }
            } else {
                if (!b1 || !t1 || !t2 || !t3 || !t4) break;
                return 0.0;
            }
            fission = fission1 + fission2 + fission3 + fission4;
            inert = inert1 + inert2 + inert3 + inert4;
            salted = salted1 + salted2 + salted3 + salted4;
        }
        for (z = endpoint6; z <= startpoint6; ++z) {
            p1 = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), z);
            p2 = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, z);
            p3 = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, z);
            p4 = new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), z);
            p5 = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), z);
            s1 = world.func_180495_p(p1);
            s2 = world.func_180495_p(p1);
            s3 = world.func_180495_p(p1);
            s4 = world.func_180495_p(p1);
            s5 = world.func_180495_p(p1);
            b1 = s1.func_177230_c() instanceof ThermonuclearCore && (s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.NORTH || s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.SOUTH);
            boolean t1 = ThermonuclearBomb.isValidTamper(world, p2);
            t2 = ThermonuclearBomb.isValidTamper(world, p3);
            t3 = ThermonuclearBomb.isValidTamper(world, p4);
            t4 = ThermonuclearBomb.isValidTamper(world, p5);
            if (t1 && ++depth1 <= 3) {
                if (ThermonuclearBomb.isLead(world, p2)) {
                    ++inert1;
                }
                if (ThermonuclearBomb.isFissionable(world, p2)) {
                    ++fission1;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p2)) {
                    ++salted1;
                }
            }
            if (t2 && ++depth2 <= 3) {
                if (ThermonuclearBomb.isLead(world, p3)) {
                    ++inert2;
                }
                if (ThermonuclearBomb.isFissionable(world, p3)) {
                    ++fission2;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p3)) {
                    ++salted2;
                }
            }
            if (t3 && ++depth3 <= 3) {
                if (ThermonuclearBomb.isLead(world, p4)) {
                    ++inert3;
                }
                if (ThermonuclearBomb.isFissionable(world, p4)) {
                    ++fission3;
                }
                if (ThermonuclearBomb.isSaltingAgent(world, p4)) {
                    ++salted3;
                }
            }
            if (t4) {
                if (++depth4 <= 3) {
                    if (ThermonuclearBomb.isLead(world, p5)) {
                        ++inert4;
                    }
                    if (ThermonuclearBomb.isFissionable(world, p5)) {
                        ++fission4;
                    }
                    if (ThermonuclearBomb.isSaltingAgent(world, p5)) {
                        ++salted4;
                    }
                }
            } else {
                if (!b1 || !t1 || !t2 || !t3 || !t4) break;
                return 0.0;
            }
            fission = fission1 + fission2 + fission3 + fission4;
            inert = inert1 + inert2 + inert3 + inert4;
            salted = salted1 + salted2 + salted3 + salted4;
        }
        double iM = Math.pow(1.1, inert);
        double fM = Math.pow(1.2, fission);
        double sM = Math.pow(1.05, salted);
        if (inert < 1) {
            iM = 0.0;
        }
        if (fission < 1) {
            fM = 0.0;
        }
        if (salted < 1) {
            sM = 0.0;
        }
        double total = iM + fM + sM;
        if (salt) {
            return salted;
        }
        return Math.max(1.0, total);
    }

    public static boolean ThermonuclearCheck(World world, BlockPos pos) {
        int z;
        int x;
        boolean t4;
        boolean t3;
        boolean t2;
        boolean t1;
        boolean b1;
        IBlockState s1;
        BlockPos p5;
        BlockPos p4;
        BlockPos p3;
        BlockPos p2;
        BlockPos p1;
        int y;
        int startpoint = pos.func_177956_o() + 1;
        int endpoint = pos.func_177956_o() + 3;
        int startpoint2 = pos.func_177956_o() - 1;
        int endpoint2 = pos.func_177956_o() - 3;
        int startpoint3 = pos.func_177958_n() + 1;
        int endpoint3 = pos.func_177958_n() + 3;
        int startpoint4 = pos.func_177958_n() - 1;
        int endpoint4 = pos.func_177958_n() - 3;
        int startpoint5 = pos.func_177952_p() + 1;
        int endpoint5 = pos.func_177952_p() + 3;
        int startpoint6 = pos.func_177952_p() - 1;
        int endpoint6 = pos.func_177952_p() - 3;
        int depth = 0;
        for (y = startpoint; y <= endpoint; ++y) {
            p1 = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
            p2 = new BlockPos(pos.func_177958_n() + 1, y, pos.func_177952_p());
            p3 = new BlockPos(pos.func_177958_n() - 1, y, pos.func_177952_p());
            p4 = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p() + 1);
            p5 = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p() - 1);
            s1 = world.func_180495_p(p1);
            boolean b12 = s1.func_177230_c() instanceof ThermonuclearCore && (s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.UP || s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.DOWN);
            boolean t12 = ThermonuclearBomb.isValidTamper(world, p2);
            boolean t22 = ThermonuclearBomb.isValidTamper(world, p3);
            boolean t32 = ThermonuclearBomb.isValidTamper(world, p4);
            boolean t42 = ThermonuclearBomb.isValidTamper(world, p5);
            if (b12 && t12 && t22 && t32 && t42) {
                if (++depth != 3) continue;
                return true;
            }
            if (!b12 || !t12 || !t22 || !t32 || !t42) break;
            return false;
        }
        for (y = endpoint2; y <= startpoint2; ++y) {
            p1 = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
            p2 = new BlockPos(pos.func_177958_n() + 1, y, pos.func_177952_p());
            p3 = new BlockPos(pos.func_177958_n() - 1, y, pos.func_177952_p());
            p4 = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p() + 1);
            p5 = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p() - 1);
            s1 = world.func_180495_p(p1);
            IBlockState s2 = world.func_180495_p(p1);
            IBlockState s3 = world.func_180495_p(p1);
            IBlockState s4 = world.func_180495_p(p1);
            IBlockState s5 = world.func_180495_p(p1);
            b1 = s1.func_177230_c() instanceof ThermonuclearCore && (s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.UP || s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.DOWN);
            t1 = ThermonuclearBomb.isValidTamper(world, p2);
            t2 = ThermonuclearBomb.isValidTamper(world, p3);
            t3 = ThermonuclearBomb.isValidTamper(world, p4);
            t4 = ThermonuclearBomb.isValidTamper(world, p5);
            if (b1 && t1 && t2 && t3 && t4) {
                if (++depth != 3) continue;
                return true;
            }
            if (!b1 || !t1 || !t2 || !t3 || !t4) break;
            return false;
        }
        for (x = startpoint3; x <= endpoint3; ++x) {
            p1 = new BlockPos(x, pos.func_177956_o(), pos.func_177952_p());
            p2 = new BlockPos(x, pos.func_177956_o() + 1, pos.func_177952_p());
            p3 = new BlockPos(x, pos.func_177956_o() - 1, pos.func_177952_p());
            p4 = new BlockPos(x, pos.func_177956_o(), pos.func_177952_p() + 1);
            p5 = new BlockPos(x, pos.func_177956_o(), pos.func_177952_p() - 1);
            s1 = world.func_180495_p(p1);
            IBlockState s2 = world.func_180495_p(p1);
            IBlockState s3 = world.func_180495_p(p1);
            IBlockState s4 = world.func_180495_p(p1);
            IBlockState s5 = world.func_180495_p(p1);
            b1 = s1.func_177230_c() instanceof ThermonuclearCore && (s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.WEST || s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.EAST);
            t1 = ThermonuclearBomb.isValidTamper(world, p2);
            t2 = ThermonuclearBomb.isValidTamper(world, p3);
            t3 = ThermonuclearBomb.isValidTamper(world, p4);
            t4 = ThermonuclearBomb.isValidTamper(world, p5);
            if (b1 && t1 && t2 && t3 && t4) {
                if (++depth != 3) continue;
                return true;
            }
            if (!b1 || !t1 || !t2 || !t3 || !t4) break;
            return false;
        }
        for (x = endpoint4; x <= startpoint4; ++x) {
            p1 = new BlockPos(x, pos.func_177956_o(), pos.func_177952_p());
            p2 = new BlockPos(x, pos.func_177956_o() + 1, pos.func_177952_p());
            p3 = new BlockPos(x, pos.func_177956_o() - 1, pos.func_177952_p());
            p4 = new BlockPos(x, pos.func_177956_o(), pos.func_177952_p() + 1);
            p5 = new BlockPos(x, pos.func_177956_o(), pos.func_177952_p() - 1);
            s1 = world.func_180495_p(p1);
            IBlockState s2 = world.func_180495_p(p1);
            IBlockState s3 = world.func_180495_p(p1);
            IBlockState s4 = world.func_180495_p(p1);
            IBlockState s5 = world.func_180495_p(p1);
            b1 = s1.func_177230_c() instanceof ThermonuclearCore && (s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.WEST || s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.EAST);
            t1 = ThermonuclearBomb.isValidTamper(world, p2);
            t2 = ThermonuclearBomb.isValidTamper(world, p3);
            t3 = ThermonuclearBomb.isValidTamper(world, p4);
            t4 = ThermonuclearBomb.isValidTamper(world, p5);
            if (b1 && t1 && t2 && t3 && t4) {
                if (++depth != 3) continue;
                return true;
            }
            if (!b1 || !t1 || !t2 || !t3 || !t4) break;
            return false;
        }
        for (z = startpoint5; z <= endpoint5; ++z) {
            p1 = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), z);
            p2 = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, z);
            p3 = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, z);
            p4 = new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), z);
            p5 = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), z);
            s1 = world.func_180495_p(p1);
            IBlockState s2 = world.func_180495_p(p1);
            IBlockState s3 = world.func_180495_p(p1);
            IBlockState s4 = world.func_180495_p(p1);
            IBlockState s5 = world.func_180495_p(p1);
            b1 = s1.func_177230_c() instanceof ThermonuclearCore && (s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.NORTH || s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.SOUTH);
            t1 = ThermonuclearBomb.isValidTamper(world, p2);
            t2 = ThermonuclearBomb.isValidTamper(world, p3);
            t3 = ThermonuclearBomb.isValidTamper(world, p4);
            t4 = ThermonuclearBomb.isValidTamper(world, p5);
            if (b1 && t1 && t2 && t3 && t4) {
                if (++depth != 3) continue;
                return true;
            }
            if (!b1 || !t1 || !t2 || !t3 || !t4) break;
            return false;
        }
        for (z = endpoint6; z <= startpoint6; ++z) {
            p1 = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), z);
            p2 = new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, z);
            p3 = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, z);
            p4 = new BlockPos(pos.func_177958_n() + 1, pos.func_177956_o(), z);
            p5 = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), z);
            s1 = world.func_180495_p(p1);
            IBlockState s2 = world.func_180495_p(p1);
            IBlockState s3 = world.func_180495_p(p1);
            IBlockState s4 = world.func_180495_p(p1);
            IBlockState s5 = world.func_180495_p(p1);
            b1 = s1.func_177230_c() instanceof ThermonuclearCore && (s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.NORTH || s1.func_177229_b((IProperty)ThermonuclearCore.FACING) == EnumFacing.SOUTH);
            t1 = ThermonuclearBomb.isValidTamper(world, p2);
            t2 = ThermonuclearBomb.isValidTamper(world, p3);
            t3 = ThermonuclearBomb.isValidTamper(world, p4);
            t4 = ThermonuclearBomb.isValidTamper(world, p5);
            if (b1 && t1 && t2 && t3 && t4) {
                if (++depth != 3) continue;
                return true;
            }
            if (!b1 || !t1 || !t2 || !t3 || !t4) break;
            return false;
        }
        return false;
    }
}

