/*
 * Decompiled with CFR 0.152.
 */
package trinity.world;

import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import trinity.world.BiomeContaminatedOcean;
import trinity.world.BiomeNuclearCrater;

@GameRegistry.ObjectHolder(value="trinity")
public class TrinityBiomes {
    public static final BiomeNuclearCrater NUCLEAR_CRATER = new BiomeNuclearCrater();
    public static final BiomeContaminatedOcean CONTAMINATED_OCEAN = new BiomeContaminatedOcean();

    public static void initBiomeManagerAndDictionary() {
        BiomeDictionary.addTypes((Biome)NUCLEAR_CRATER, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.HOT, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.WASTELAND});
        BiomeDictionary.addTypes((Biome)CONTAMINATED_OCEAN, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.DEAD, BiomeDictionary.Type.OCEAN});
    }

    @Mod.EventBusSubscriber(modid="trinity")
    public static class RegistrationHandler {
        @SubscribeEvent
        public static void onEvent(RegistryEvent.Register<Biome> event) {
            IForgeRegistry registry = event.getRegistry();
            registry.register(new BiomeNuclearCrater().setRegistryName("trinity", "nuclear_crater"));
            registry.register(new BiomeContaminatedOcean().setRegistryName("trinity", "contaminated_ocean"));
        }
    }
}

