/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.gogredux.client;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import dev.itsmeow.gogredux.GrimoireOfGaiaRedux;
import dev.itsmeow.gogredux.client.Replacements;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReplacementHandler {
    public static final Logger LOG = LogManager.getLogger();
    public static Map<RegistrationTime, Multimap<Pair<String, String>, Supplier<Supplier<ReplaceDefinition<?>>>>> replaceDefs = new HashMap();
    public static Map<RegistrationTime, Multimap<String, Supplier<Runnable>>> modActions = new HashMap<RegistrationTime, Multimap<String, Supplier<Runnable>>>();
    public static Map<String, Boolean> config = new HashMap<String, Boolean>();

    public static void preinit() {
        replaceDefs.values().forEach(m -> m.keySet().forEach(pair -> {
            boolean val = GrimoireOfGaiaRedux.config.getBoolean("replace_" + (String)pair.getRight(), "replacements." + (String)pair.getLeft(), true, "from " + (String)pair.getLeft());
            config.put((String)pair.getRight(), val);
            LOG.debug("Loaded config replace_" + (String)pair.getRight() + " from " + (String)pair.getLeft() + " as " + val);
        }));
        ReplacementHandler.runActions(RegistrationTime.PREINIT);
        ReplacementHandler.overwriteRenders(RegistrationTime.PREINIT);
    }

    public static void init() {
        ReplacementHandler.runActions(RegistrationTime.INIT);
        ReplacementHandler.overwriteRenders(RegistrationTime.INIT);
    }

    public static void mre() {
        ReplacementHandler.runActions(RegistrationTime.MODELREGISTRY);
        ReplacementHandler.overwriteRenders(RegistrationTime.MODELREGISTRY);
    }

    public static void postinit() {
        ReplacementHandler.runActions(RegistrationTime.POSTINIT);
        ReplacementHandler.overwriteRenders(RegistrationTime.POSTINIT);
    }

    public static void addReplace(RegistrationTime time, String modid, String name, Supplier<Supplier<ReplaceDefinition<?>>> definition) {
        replaceDefs.putIfAbsent(time, (Multimap<Pair<String, String>, Supplier<Supplier<ReplaceDefinition<?>>>>)MultimapBuilder.hashKeys().linkedHashSetValues().build());
        replaceDefs.get((Object)time).put((Object)Pair.of((Object)modid, (Object)name), definition);
        LOG.debug(String.format("Registering replace for %s from %s at %s", name, modid, time.name()));
    }

    public static void addAction(RegistrationTime time, String modid, Supplier<Runnable> action) {
        modActions.putIfAbsent(time, (Multimap<String, Supplier<Runnable>>)MultimapBuilder.hashKeys().linkedHashSetValues().build());
        modActions.get((Object)time).put((Object)modid, action);
        LOG.debug(String.format("Registering action for %s at %s", modid, time.name()));
    }

    public static boolean getEnabledAndLoaded(String id) {
        return config.containsKey(id) ? config.get(id) : false;
    }

    private static void overwriteRenders(RegistrationTime phase) {
        replaceDefs.putIfAbsent(phase, (Multimap<Pair<String, String>, Supplier<Supplier<ReplaceDefinition<?>>>>)MultimapBuilder.hashKeys().hashSetValues().build());
        replaceDefs.get((Object)phase).forEach((pair, definitionSupplier) -> {
            boolean doReplace = config.get(pair.getRight());
            if (Loader.isModLoaded((String)((String)pair.getLeft())) || ((String)pair.getLeft()).equals("minecraft")) {
                final ReplaceDefinition def = (ReplaceDefinition)((Supplier)definitionSupplier.get()).get();
                if (doReplace) {
                    if (def.type == ReplaceDefinition.RenderType.NEW) {
                        IRenderFactory<EntityLivingBase> factory = new IRenderFactory<EntityLivingBase>(){

                            public Render<? super EntityLivingBase> createRenderFor(RenderManager manager) {
                                return def.factory.apply(manager);
                            }
                        };
                        RenderingRegistry.registerEntityRenderingHandler(def.clazz, (IRenderFactory)factory);
                    } else {
                        RenderingRegistry.registerEntityRenderingHandler(def.clazz, def.factory.apply(Minecraft.func_71410_x().func_175598_ae()));
                    }
                    LOG.debug(String.format("Overriding %s / %s in %s with render type %s", pair.getRight(), def.clazz.getSimpleName(), pair.getLeft(), def.type.name()));
                } else {
                    LOG.debug(String.format("Was going to override %s / %s in %s with render type %s, but it is disabled!", pair.getRight(), def.clazz.getSimpleName(), pair.getLeft(), def.type.name()));
                }
            } else {
                LOG.debug(String.format("%s was not replaced, because %s is not loaded! Config %s", pair.getRight(), pair.getLeft(), doReplace));
            }
        });
    }

    private static void runActions(RegistrationTime phase) {
        modActions.putIfAbsent(phase, (Multimap<String, Supplier<Runnable>>)MultimapBuilder.hashKeys().hashSetValues().build());
        modActions.get((Object)phase).forEach((modid, action) -> {
            if (Loader.isModLoaded((String)modid) || modid.equals("minecraft")) {
                ((Runnable)action.get()).run();
                LOG.debug("Running action for " + modid);
            } else {
                LOG.debug("No action executed for " + modid + ", as it is not loaded.");
            }
        });
    }

    static {
        Replacements.addAll();
    }

    public static enum RegistrationTime {
        MODELREGISTRY,
        PREINIT,
        INIT,
        POSTINIT;

    }

    public static class ReplaceDefinition<T extends EntityLivingBase> {
        public final Class<T> clazz;
        public final Function<RenderManager, Render<? super T>> factory;
        public final RenderType type;

        public ReplaceDefinition(Class<T> clazz, Function<RenderManager, Render<? super T>> factory, RenderType type) {
            this.clazz = clazz;
            this.factory = factory;
            this.type = type;
        }

        public ReplaceDefinition(Class<T> clazz, IRenderFactory<T> factory, RenderType type) {
            this.clazz = clazz;
            this.factory = mgr -> factory.createRenderFor(mgr);
            this.type = type;
        }

        public static enum RenderType {
            OLD,
            NEW;

        }
    }
}

