/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.gogredux.client.model.layer;

import dev.itsmeow.gogredux.client.RenderUtil;
import dev.itsmeow.gogredux.client.model.ModelGoGRBase;
import dev.itsmeow.gogredux.client.render.generic.BaseRenderer;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLiving;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHandSide;

public class LayerHeldItem<T extends EntityLiving, A extends ModelGoGRBase>
implements LayerRenderer<T> {
    private final EntityEquipmentSlot slot;
    private final BaseRenderer<T, A> renderer;
    private Consumer<T> preRender;

    public LayerHeldItem(BaseRenderer<T, A> renderer, EntityEquipmentSlot slot, Consumer<T> preRender) {
        this.renderer = renderer;
        this.slot = slot == EntityEquipmentSlot.MAINHAND || slot == EntityEquipmentSlot.OFFHAND ? slot : EntityEquipmentSlot.MAINHAND;
        this.preRender = preRender;
    }

    public static <T extends EntityLiving, A extends ModelGoGRBase> LayerHeldItem<T, A> left(BaseRenderer<T, A> renderer, Consumer<T> preRender) {
        return new LayerHeldItem<T, A>(renderer, EntityEquipmentSlot.OFFHAND, preRender);
    }

    public static <T extends EntityLiving, A extends ModelGoGRBase> LayerHeldItem<T, A> right(BaseRenderer<T, A> renderer, Consumer<T> preRender) {
        return new LayerHeldItem<T, A>(renderer, EntityEquipmentSlot.MAINHAND, preRender);
    }

    public void doRenderLayer(T living, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        ItemStack stack = living.func_184582_a(this.slot);
        GlStateManager.func_179094_E();
        if (this.renderer.func_177087_b().field_78091_s) {
            GlStateManager.func_179109_b((float)0.0f, (float)0.625f, (float)0.0f);
            GlStateManager.func_179114_b((float)-20.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        }
        this.preRender.accept(living);
        if (this.slot == EntityEquipmentSlot.MAINHAND) {
            this.renderHeldItem(living, stack, ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND, EnumHandSide.RIGHT);
        } else {
            this.renderHeldItem(living, stack, ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND, EnumHandSide.LEFT);
        }
        GlStateManager.func_179121_F();
    }

    private void renderHeldItem(T living, ItemStack stack, ItemCameraTransforms.TransformType camera, EnumHandSide handSide) {
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            if (living.func_70093_af()) {
                GlStateManager.func_179109_b((float)0.0f, (float)0.2f, (float)0.0f);
            }
            RenderUtil.partTranslateRotate(this.renderer.getArm(this.slot));
            GlStateManager.func_179114_b((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            boolean flag = handSide == EnumHandSide.LEFT;
            GlStateManager.func_179109_b((float)((float)(flag ? -1 : 1) / 16.0f), (float)0.125f, (float)-0.625f);
            Minecraft.func_71410_x().func_175597_ag().func_187462_a(living, stack, camera, flag);
            GlStateManager.func_179121_F();
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

