/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.gogredux.client.render.generic;

import dev.itsmeow.gogredux.client.model.ModelGoGRBase;
import dev.itsmeow.gogredux.client.model.layer.LayerEyes;
import dev.itsmeow.gogredux.client.render.generic.BaseRenderer;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.EntityLiving;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;

public class RenderGoGR<T extends EntityLiving, A extends ModelGoGRBase>
extends BaseRenderer<T, A> {
    private final TextureContainer<T, A> textureContainer;
    private final ModelContainer<T, A> modelContainer;
    private final BiConsumer<T, Float> preRenderCallback;

    public RenderGoGR(RenderManager mgr, ShadowSize shadow, TextureContainer<T, A> textureContainer, ModelContainer<T, A> modelContainer, BiConsumer<T, Float> preRenderCallback) {
        super(mgr, modelContainer.getBaseModel(), shadow.size());
        this.textureContainer = textureContainer;
        this.modelContainer = modelContainer;
        this.preRenderCallback = preRenderCallback;
    }

    protected void preRenderCallback(T e, float p) {
        this.preRenderCallback.accept(e, Float.valueOf(p));
    }

    public void func_76986_a(T entity, double x, double y, double z, float entityYaw, float partialTicks) {
        this.field_77045_g = this.modelContainer.getModel(entity);
        super.func_76986_a(entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(T entity) {
        return this.textureContainer.getTexture(entity);
    }

    public static <T extends EntityLiving, A extends ModelGoGRBase> Builder<T, A> factory(String baseName, ShadowSize shadow) {
        return new Builder(baseName, shadow);
    }

    private static ResourceLocation tex(String location) {
        return new ResourceLocation("gogredux", "textures/entity/" + location + ".png");
    }

    public static class Builder<T extends EntityLiving, A extends ModelGoGRBase> {
        private final String baseName;
        private final ShadowSize shadow;
        private TextureContainer<T, A> tex;
        private ModelContainer<T, A> model;
        private Consumer<T> armsPre;
        private Function<T, Boolean> isMale;
        private BiConsumer<T, Float> preRender = (e, p) -> {};
        private ArrayList<Function<BaseRenderer<T, A>, LayerRenderer<T>>> layers = new ArrayList();

        protected Builder(String baseName, ShadowSize shadow) {
            this.baseName = baseName;
            this.shadow = shadow;
        }

        public Builder<T, A> arms() {
            this.arms(e -> {});
            return this;
        }

        public Builder<T, A> arms(Consumer<T> armsPre) {
            this.armsPre = armsPre;
            return this;
        }

        public Builder<T, A> eyes(String texture) {
            return this.layer(r -> new LayerEyes(r, RenderGoGR.tex(texture)));
        }

        public Builder<T, A> eyes() {
            return this.eyes("gaia_" + this.baseName + "_eyes");
        }

        public Builder<T, A> layer(Function<BaseRenderer<T, A>, LayerRenderer<T>> layer) {
            this.layers.add(layer);
            return this;
        }

        public Builder<T, A> gender(Function<T, Boolean> isMale) {
            this.isMale = isMale;
            return this;
        }

        public Builder<T, A> tSingle(String texture) {
            this.tex = new TextureContainer(RenderGoGR.tex(texture));
            return this;
        }

        public Builder<T, A> tSingle() {
            return this.tSingle("gaia_" + this.baseName);
        }

        public Builder<T, A> tGendered() {
            return this.tGendered("gaia_" + this.baseName + "_male", "gaia_" + this.baseName + "_female");
        }

        public Builder<T, A> tGendered(String male, String female) {
            if (this.isMale == null) {
                throw new IllegalArgumentException("Must call gender() before gendered texture call!");
            }
            this.tex = new TextureContainer(this.isMale, RenderGoGR.tex(male), RenderGoGR.tex(female));
            return this;
        }

        public Builder<T, A> tMapped(Function<T, String> texMapper) {
            this.tex = new TextureContainer(entity -> RenderGoGR.tex((String)texMapper.apply(entity)));
            return this;
        }

        public Builder<T, A> tNumber(Function<T, Integer> numFunction) {
            this.tMapped(entity -> "gaia_" + this.baseName + "_" + ((Integer)numFunction.apply(entity) + 1));
            return this;
        }

        public Builder<T, A> mSingle(A model) {
            this.model = new ModelContainer(model);
            return this;
        }

        public Builder<T, A> mMapped(Function<T, ModelGoGRBase> modelMapper, A baseModel) {
            this.model = new ModelContainer<T, A>(modelMapper, baseModel);
            return this;
        }

        public Builder<T, A> mGendered(A maleModel, ModelGoGRBase femaleModel) {
            if (this.isMale == null) {
                throw new IllegalArgumentException("Must call gender() before gendered model call!");
            }
            this.model = new ModelContainer<T, A>(this.isMale, maleModel, femaleModel);
            return this;
        }

        public Builder<T, A> preRender(BiConsumer<T, Float> preRender) {
            this.preRender = preRender;
            return this;
        }

        public Builder<T, A> childScale(Function<T, Boolean> isChild, float xScale, float yScale, float zScale) {
            this.preRender((e, p) -> {
                if (((Boolean)isChild.apply(e)).booleanValue()) {
                    GlStateManager.func_179152_a((float)xScale, (float)yScale, (float)zScale);
                }
            });
            return this;
        }

        public IRenderFactory<T> done() {
            if (this.tex == null || this.model == null) {
                throw new IllegalArgumentException("Must define both a texture and a model before calling build()!");
            }
            if (this.armsPre == null) {
                return mgr -> new RenderGoGR<T, A>(mgr, this.shadow, this.tex, this.model, this.preRender).layers(this.layers);
            }
            return mgr -> new RenderGoGR<T, A>(mgr, this.shadow, this.tex, this.model, this.preRender).arms(this.armsPre).layers(this.layers);
        }
    }

    public static enum ShadowSize {
        TINY(0.25f),
        SMALL(0.4f),
        MED(0.5f),
        LARGE(0.7f);

        private final float size;

        private ShadowSize(float size) {
            this.size = size;
        }

        public float size() {
            return this.size;
        }
    }

    public static enum Strategy {
        SINGLE,
        MAPPER,
        GENDERED;

    }

    public static class ModelContainer<T extends EntityLiving, A extends ModelGoGRBase> {
        private final Strategy strategy;
        private final A baseModel;
        private Function<T, ModelGoGRBase> modelMapper;
        private A maleModel;
        private ModelGoGRBase femaleModel;
        private Function<T, Boolean> isMale;

        public ModelContainer(A baseModel) {
            this.strategy = Strategy.SINGLE;
            this.baseModel = baseModel;
        }

        public ModelContainer(Function<T, ModelGoGRBase> modelMapper, A baseModel) {
            this.strategy = Strategy.MAPPER;
            this.modelMapper = modelMapper;
            this.baseModel = baseModel;
        }

        public ModelContainer(Function<T, Boolean> isMale, A maleModel, ModelGoGRBase femaleModel) {
            this.strategy = Strategy.GENDERED;
            this.isMale = isMale;
            this.maleModel = maleModel;
            this.femaleModel = femaleModel;
            this.baseModel = maleModel;
        }

        public ModelGoGRBase getModel(T entity) {
            switch (this.strategy) {
                case SINGLE: {
                    return this.baseModel;
                }
                case MAPPER: {
                    return this.modelMapper.apply(entity);
                }
                case GENDERED: {
                    return this.isMale.apply(entity) != false ? this.maleModel : this.femaleModel;
                }
            }
            return null;
        }

        public A getBaseModel() {
            return this.baseModel;
        }
    }

    public static class TextureContainer<T extends EntityLiving, A extends ModelGoGRBase> {
        private Strategy strategy;
        private ResourceLocation singleTexture;
        private Function<T, ResourceLocation> texMapper;
        private ResourceLocation maleTex;
        private ResourceLocation femaleTex;
        private Function<T, Boolean> isMale;

        public TextureContainer(ResourceLocation singleTexture) {
            this.strategy = Strategy.SINGLE;
            this.singleTexture = singleTexture;
        }

        public TextureContainer(Function<T, ResourceLocation> texMapper) {
            this.strategy = Strategy.MAPPER;
            this.texMapper = texMapper;
        }

        public TextureContainer(Function<T, Boolean> isMale, ResourceLocation maleTex, ResourceLocation femaleTex) {
            this.strategy = Strategy.GENDERED;
            this.isMale = isMale;
            this.maleTex = maleTex;
            this.femaleTex = femaleTex;
        }

        public ResourceLocation getTexture(T entity) {
            switch (this.strategy) {
                case SINGLE: {
                    return this.singleTexture;
                }
                case MAPPER: {
                    return this.texMapper.apply(entity);
                }
                case GENDERED: {
                    return this.isMale.apply(entity) != false ? this.maleTex : this.femaleTex;
                }
            }
            return null;
        }
    }
}

