/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.dsurround.registry.biome;

import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.orecruncher.dsurround.registry.biome.BiomeUtil;
import org.orecruncher.dsurround.registry.biome.IBiome;

@SideOnly(value=Side.CLIENT)
public class BiomeHandler
implements IBiome {
    protected final Biome biome;
    protected final int id;
    protected String name;
    protected final Set<BiomeDictionary.Type> types;

    public BiomeHandler(@Nonnull Biome biome) {
        this.biome = biome;
        this.id = Biome.func_185362_a((Biome)this.biome);
        this.types = BiomeUtil.getBiomeTypes(this.biome);
        this.name = BiomeUtil.getBiomeName(this.biome);
    }

    @Override
    public Biome getBiome() {
        return this.biome;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public ResourceLocation getKey() {
        return this.biome.getRegistryName();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<BiomeDictionary.Type> getTypes() {
        return this.types;
    }

    @Override
    public boolean canRain() {
        return this.biome.func_76738_d();
    }

    @Override
    public boolean getEnableSnow() {
        return this.biome.func_76746_c();
    }

    @Override
    public float getFloatTemperature(@Nonnull BlockPos pos) {
        return this.biome.func_180626_a(pos);
    }

    @Override
    public float getTemperature() {
        return this.biome.func_185353_n();
    }

    @Override
    public Biome.TempCategory getTempCategory() {
        return this.biome.func_150561_m();
    }

    @Override
    public boolean isHighHumidity() {
        return this.biome.func_76736_e();
    }

    @Override
    public float getRainfall() {
        return this.biome.func_76727_i();
    }

    @Nonnull
    public static ResourceLocation getKey(@Nonnull Biome biome) {
        ResourceLocation res = biome.getRegistryName();
        if (res == null) {
            String name = biome.getClass().getName() + "_" + biome.func_185359_l().replace(' ', '_').toLowerCase();
            res = new ResourceLocation("dsurround", name);
        }
        return res;
    }
}

