/*
 * Decompiled with CFR 0.152.
 */
package somdudewillson.archronos;

import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import org.apache.logging.log4j.Logger;
import somdudewillson.archronos.boxes.DimPropertyBox;
import somdudewillson.archronos.config.ARChronosConfig;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;

@Mod(modid="archronos", name="AR Chronos Addon", version="1.12.2-1.0.0.0", dependencies="required-after:advancedrocketry;", acceptedMinecraftVersions="[1.12.2]")
public class ARChronos {
    public static final String MODID = "archronos";
    public static final String NAME = "AR Chronos Addon";
    public static final String VERSION = "1.12.2-1.0.0.0";
    private static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        DimensionManager galaxy = DimensionManager.getInstance();
        logger.info("Patching Advanced Rocketry Dimensions...");
        for (Integer dimID : galaxy.getRegisteredDimensions()) {
            DimensionProperties prop = galaxy.getDimensionProperties(dimID.intValue());
            if (!ARChronosConfig.orbital_period_override.containsKey(prop.getName())) {
                ARChronosConfig.orbital_period_override.put(prop.getName(), -1);
                logger.info("Added Dimension: '" + prop.getName() + "' to config.");
            }
            galaxy.setDimProperties(dimID.intValue(), (DimensionProperties)new DimPropertyBox(prop));
            logger.info("Patched Dimension: '" + prop.getName() + "'");
        }
        logger.info(galaxy.getRegisteredDimensions().length + " Advanced Rocketry Dimensions patched.");
    }
}

