/*
 * Decompiled with CFR 0.152.
 */
package somdudewillson.archronos.boxes;

import net.minecraft.nbt.NBTTagCompound;
import somdudewillson.archronos.config.ARChronosConfig;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.dimension.DimensionProperties;

public class DimPropertyBox
extends DimensionProperties {
    private static final int SOLAR_K = 76737600;
    private static final int LUNAR_K = 124416;
    private double orbitThetaDeltaPerTick;

    public DimPropertyBox(DimensionProperties original) {
        super(original.getId(), original.getName());
        NBTTagCompound oldData = new NBTTagCompound();
        original.writeToNBT(oldData);
        super.readFromNBT(oldData);
        this.updateOrbitalDelta();
    }

    private void updateOrbitalDelta() {
        if (ARChronosConfig.orbital_period_override.containsKey(super.getName()) && ARChronosConfig.orbital_period_override.get(super.getName()) > 0) {
            this.orbitThetaDeltaPerTick = Math.PI * 2 / (double)ARChronosConfig.orbital_period_override.get(super.getName()).intValue();
        } else {
            int k = super.isMoon() ? 124416 : 76737600;
            this.orbitThetaDeltaPerTick = Math.PI * 2 / (Math.pow(super.getOrbitalDist(), 1.0) * Math.sqrt(k));
        }
    }

    public void updateOrbit() {
        this.prevOrbitalTheta = this.orbitTheta;
        this.orbitTheta = (double)AdvancedRocketry.proxy.getWorldTimeUniversal(0) * this.orbitThetaDeltaPerTick % (Math.PI * 2);
    }
}

