/*
 * Decompiled with CFR 0.152.
 */
package mezz.itemzoom.client;

import mezz.itemzoom.client.KeyBindings;
import mezz.itemzoom.client.ZoomRenderHelper;
import mezz.itemzoom.client.compat.JeiCompat;
import mezz.itemzoom.client.config.Config;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class EventHandler {
    public static boolean rendering = false;
    private static boolean renderedThisFrame = false;

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onGuiKeyboardEvent(GuiScreenEvent.KeyboardInputEvent.Post event) {
        if (Keyboard.getEventKeyState()) {
            int eventKey = Keyboard.getEventKey();
            if (KeyBindings.TOGGLE.isActiveAndMatches(eventKey)) {
                Config.toggleEnabled();
                event.setCanceled(true);
            } else if (KeyBindings.ZOOM_IN.isActiveAndMatches(eventKey)) {
                Config.increaseZoom();
                event.setCanceled(true);
            } else if (KeyBindings.ZOOM_OUT.isActiveAndMatches(eventKey)) {
                Config.decreaseZoom();
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onItemStackTooltip(RenderTooltipEvent.Pre event) {
        if (!Config.isToggledEnabled() && !EventHandler.isEnableKeyHeld()) {
            return;
        }
        ItemStack itemStack = event.getStack();
        if (itemStack == null || itemStack.func_190926_b()) {
            return;
        }
        if (Config.isJeiOnly() && !ItemStack.func_77989_b((ItemStack)itemStack, (ItemStack)JeiCompat.getStackUnderMouse())) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        GuiScreen currentScreen = minecraft.field_71462_r;
        if (currentScreen instanceof GuiContainer) {
            GuiContainer guiContainer = (GuiContainer)currentScreen;
            if (event.getX() > guiContainer.getGuiLeft()) {
                EventHandler.renderZoomedStack(itemStack, guiContainer, minecraft);
                renderedThisFrame = true;
            }
        }
    }

    @SubscribeEvent
    public void onDrawScreenPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        rendering = renderedThisFrame;
        renderedThisFrame = false;
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent eventArgs) {
        if ("itemzoom".equals(eventArgs.getModID())) {
            Config.load();
        }
    }

    private static boolean isEnableKeyHeld() {
        int eventKey;
        return Keyboard.getEventKeyState() && KeyBindings.HOLD.isActiveAndMatches(eventKey = Keyboard.getEventKey());
    }

    private static void renderZoomedStack(ItemStack itemStack, GuiContainer guiContainer, Minecraft minecraft) {
        ScaledResolution scaledResolution = new ScaledResolution(minecraft);
        float scale = (float)Config.getZoomAmount() / 100.0f * (float)guiContainer.getGuiLeft() / 17.0f;
        float xPosition = ((float)guiContainer.getGuiLeft() / scale - 16.0f) / 2.0f;
        float yPosition = ((float)scaledResolution.func_78328_b() / scale - 16.0f) / 2.0f;
        FontRenderer font = EventHandler.getFontRenderer(minecraft, itemStack);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        GlStateManager.func_179109_b((float)xPosition, (float)yPosition, (float)0.0f);
        ZoomRenderHelper.enableGUIStandardItemLighting(scale);
        minecraft.func_175599_af().field_77023_b += 100.0f;
        minecraft.func_175599_af().func_184391_a((EntityLivingBase)minecraft.field_71439_g, itemStack, 0, 0);
        EventHandler.renderItemOverlayIntoGUI(font, itemStack);
        minecraft.func_175599_af().field_77023_b -= 100.0f;
        GlStateManager.func_179084_k();
        RenderHelper.func_74518_a();
        GlStateManager.func_179121_F();
        if (Config.showHelpText()) {
            String modName = "Item Zoom";
            int stringWidth = font.func_78256_a(modName);
            int x = (guiContainer.getGuiLeft() - stringWidth) / 2;
            int y = (scaledResolution.func_78328_b() + Math.round(17.0f * scale)) / 2;
            font.func_78276_b(modName, x, y, 0x404040);
            if (Config.isToggledEnabled()) {
                String toggleText = KeyBindings.TOGGLE.getDisplayName();
                stringWidth = font.func_78256_a(toggleText);
                x = (guiContainer.getGuiLeft() - stringWidth) / 2;
                font.func_78276_b(toggleText, x, y += font.field_78288_b, 0x404040);
            }
        }
    }

    private static FontRenderer getFontRenderer(Minecraft minecraft, ItemStack itemStack) {
        FontRenderer fontRenderer = itemStack.func_77973_b().getFontRenderer(itemStack);
        if (fontRenderer == null) {
            fontRenderer = minecraft.field_71466_p;
        }
        return fontRenderer;
    }

    public static void renderItemOverlayIntoGUI(FontRenderer fr, ItemStack stack) {
        if (!stack.func_190926_b()) {
            EntityPlayerSP entityplayersp;
            float f3;
            if (Config.showStackSize() && stack.func_190916_E() != 1) {
                String s = String.valueOf(stack.func_190916_E());
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179084_k();
                fr.func_175063_a(s, (float)(17 - fr.func_78256_a(s)), 9.0f, 0xFFFFFF);
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
                GlStateManager.func_179147_l();
            }
            if (Config.showDamageBar() && stack.func_77973_b().showDurabilityBar(stack)) {
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179090_x();
                GlStateManager.func_179118_c();
                GlStateManager.func_179084_k();
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder bufferBuilder = tessellator.func_178180_c();
                double health = stack.func_77973_b().getDurabilityForDisplay(stack);
                int rgbfordisplay = stack.func_77973_b().getRGBDurabilityForDisplay(stack);
                int i = Math.round(13.0f - (float)health * 13.0f);
                EventHandler.draw(bufferBuilder, 2, 13, 13, 2, 0, 0, 0, 255);
                EventHandler.draw(bufferBuilder, 2, 13, i, 1, rgbfordisplay >> 16 & 0xFF, rgbfordisplay >> 8 & 0xFF, rgbfordisplay & 0xFF, 255);
                GlStateManager.func_179147_l();
                GlStateManager.func_179141_d();
                GlStateManager.func_179098_w();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
            float f = f3 = (entityplayersp = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : entityplayersp.func_184811_cZ().func_185143_a(stack.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
            if (f3 > 0.0f) {
                GlStateManager.func_179140_f();
                GlStateManager.func_179097_i();
                GlStateManager.func_179090_x();
                Tessellator tessellator1 = Tessellator.func_178181_a();
                BufferBuilder bufferBuilder = tessellator1.func_178180_c();
                EventHandler.draw(bufferBuilder, 0, MathHelper.func_76141_d((float)(16.0f * (1.0f - f3))), 16, MathHelper.func_76123_f((float)(16.0f * f3)), 255, 255, 255, 127);
                GlStateManager.func_179098_w();
                GlStateManager.func_179145_e();
                GlStateManager.func_179126_j();
            }
        }
    }

    private static void draw(BufferBuilder renderer, int x, int y, int width, int height, int red, int green, int blue, int alpha) {
        renderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        renderer.func_181662_b((double)x, (double)y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)x, (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)(y + height), 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        renderer.func_181662_b((double)(x + width), (double)y, 0.0).func_181669_b(red, green, blue, alpha).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }
}

