/*
 * Decompiled with CFR 0.152.
 */
package mezz.itemzoom.client.config;

import java.io.File;
import javax.annotation.Nullable;
import mezz.itemzoom.client.compat.JeiCompat;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class Config {
    @Nullable
    private static Configuration config;
    private static final String category = "itemzoom";
    private static final int MIN_ZOOM = 10;
    private static final int MAX_ZOOM = 100;
    private static final int DEFAULT_ZOOM = 80;
    private static boolean toggledEnabled;
    private static int zoomAmount;
    private static boolean jeiOnly;
    private static boolean showHelpText;
    private static boolean showDamageBar;
    private static boolean showStackSize;

    @Nullable
    public static Configuration getConfig() {
        return config;
    }

    public static String getCategory() {
        return category;
    }

    public static boolean isToggledEnabled() {
        return toggledEnabled;
    }

    public static void toggleEnabled() {
        boolean bl = toggledEnabled = !toggledEnabled;
        if (config != null) {
            String configComment = I18n.func_135052_a((String)"config.itemzoom.toggle.enabled", (Object[])new Object[0]);
            Property property = config.get(category, "toggled.enabled", true, configComment);
            property.set(toggledEnabled);
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    public static void increaseZoom() {
        int newZoomAmount = Math.round((float)Config.getZoomAmount() * 1.1f);
        Config.setZoomAmount(newZoomAmount);
    }

    public static void decreaseZoom() {
        int newZoomAmount = Math.round((float)Config.getZoomAmount() / 1.1f);
        Config.setZoomAmount(newZoomAmount);
    }

    public static int getZoomAmount() {
        return zoomAmount;
    }

    public static boolean showHelpText() {
        return showHelpText;
    }

    public static boolean showDamageBar() {
        return showDamageBar;
    }

    public static boolean showStackSize() {
        return showStackSize;
    }

    public static void setZoomAmount(int zoomAmount) {
        if (zoomAmount > 100) {
            zoomAmount = 100;
        } else if (zoomAmount < 10) {
            zoomAmount = 10;
        }
        if (Config.zoomAmount != zoomAmount) {
            Config.zoomAmount = zoomAmount;
            if (config != null) {
                String configComment = I18n.func_135052_a((String)"config.itemzoom.zoom.amount", (Object[])new Object[0]);
                configComment = configComment + " [range: " + 10 + " ~ " + 100 + ", default: " + 80 + "]";
                Property property = config.get(category, "zoom.amount", 80, configComment, 10, 100);
                property.set(Config.zoomAmount);
                if (config.hasChanged()) {
                    config.save();
                }
            }
        }
    }

    public static boolean isJeiOnly() {
        return jeiOnly && JeiCompat.isLoaded();
    }

    public static void preInit(FMLPreInitializationEvent event) {
        File configFile = new File(event.getModConfigurationDirectory(), "itemzoom.cfg");
        config = new Configuration(configFile, "1.0");
        Config.load();
    }

    public static void load() {
        if (config == null) {
            return;
        }
        String configComment = I18n.func_135052_a((String)"config.itemzoom.toggle.enabled.comment", (Object[])new Object[0]);
        toggledEnabled = config.getBoolean("toggled.enabled", category, true, configComment, "config.itemzoom.toggle.enabled");
        configComment = I18n.func_135052_a((String)"config.itemzoom.zoom.amount.comment", (Object[])new Object[0]);
        zoomAmount = config.getInt("zoom.amount", category, 80, 10, 100, configComment, "config.itemzoom.zoom.amount");
        configComment = I18n.func_135052_a((String)"config.itemzoom.jei.only.comment", (Object[])new Object[0]);
        jeiOnly = config.getBoolean("jei.only", category, false, configComment, "config.itemzoom.jei.only");
        configComment = I18n.func_135052_a((String)"config.itemzoom.show.help.text.comment", (Object[])new Object[0]);
        showHelpText = config.getBoolean("show.help.text", category, true, configComment, "config.itemzoom.show.help.text");
        configComment = I18n.func_135052_a((String)"config.itemzoom.show.damage.bar.comment", (Object[])new Object[0]);
        showDamageBar = config.getBoolean("show.damage.bar", category, false, configComment, "config.itemzoom.show.damage.bar");
        configComment = I18n.func_135052_a((String)"config.itemzoom.show.stack.size.comment", (Object[])new Object[0]);
        showStackSize = config.getBoolean("show.stack.size", category, false, configComment, "config.itemzoom.show.stack.size");
        if (config.hasChanged()) {
            config.save();
        }
    }

    static {
        toggledEnabled = true;
        zoomAmount = 80;
        jeiOnly = false;
        showHelpText = true;
        showDamageBar = false;
        showStackSize = false;
    }
}

