/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.potions;

import com.theundertaker11.geneticsreborn.api.capability.genes.EnumGenes;
import com.theundertaker11.geneticsreborn.api.capability.genes.Genes;
import com.theundertaker11.geneticsreborn.items.GRItems;
import com.theundertaker11.geneticsreborn.potions.GRPotions;
import com.theundertaker11.geneticsreborn.util.ModUtils;
import java.util.Arrays;
import java.util.List;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraftforge.common.brewing.IBrewingRecipe;

public class ComplexBrew
implements IBrewingRecipe {
    private PotionType pot;
    private Item item;
    private String cellType;
    private ItemStack output;
    private EnumGenes inputGene;
    private static final EnumGenes[] REQUIRED_GENES = new EnumGenes[]{EnumGenes.CURSED, EnumGenes.POISON_4, EnumGenes.WITHER, EnumGenes.WEAKNESS, EnumGenes.BLINDNESS, EnumGenes.SLOWNESS_6, EnumGenes.NAUSEA, EnumGenes.HUNGER, EnumGenes.FLAME, EnumGenes.MINING_WEAKNESS, EnumGenes.LEVITATION, EnumGenes.DEAD_CREEPERS, EnumGenes.DEAD_UNDEAD, EnumGenes.DEAD_HOSTILE, EnumGenes.DEAD_OLD_AGE};

    public ComplexBrew(PotionType pot, Item ingredient, String cellType, ItemStack output) {
        this.pot = pot;
        this.cellType = cellType;
        this.item = ingredient;
        this.output = output;
    }

    public ComplexBrew(PotionType pot, Item ingredient, String cellType, String gene, int outChance) {
        this.pot = pot;
        this.cellType = cellType;
        this.item = ingredient;
        this.output = new ItemStack(GRItems.Cell);
        NBTTagCompound tag = ModUtils.getTagCompound(this.output);
        if (pot == GRPotions.MUTATION_POTION) {
            tag.func_74757_a("mutation", true);
        }
        tag.func_74778_a("forceGene", gene);
        tag.func_74768_a("chance", outChance);
    }

    public ComplexBrew(PotionType pot, Item ingredient, String cellType, EnumGenes outGene, int outChance) {
        this(pot, ingredient, cellType, outGene.toGeneName(), outChance);
    }

    public ComplexBrew(PotionType pot, Item dNAHelix, EnumGenes geneIn, EnumGenes geneOut, int chance) {
        this.pot = pot;
        this.inputGene = geneIn;
        this.item = dNAHelix;
        this.output = this.newPotion(geneOut);
    }

    private final ItemStack newPotion(EnumGenes gene) {
        ItemStack out = PotionUtils.func_185188_a((ItemStack)new ItemStack(GRItems.ViralPotion), (PotionType)GRPotions.VIRAL_POTION);
        NBTTagCompound tag = ModUtils.getTagCompound(out);
        tag.func_74778_a("gene", gene.toGeneName());
        return out;
    }

    public boolean isInput(ItemStack input) {
        PotionType type = PotionUtils.func_185191_c((ItemStack)input);
        if (this.pot != null && this.pot != PotionTypes.field_185229_a && type == this.pot) {
            String match = null;
            if (input.func_77973_b() == GRItems.Cell && input.func_77942_o()) {
                match = input.func_77978_p().func_74779_i("entityName");
            } else if (input.func_77973_b() == GRItems.DNAHelix && input.func_77942_o()) {
                match = input.func_77978_p().func_74779_i("gene");
            } else if (type != PotionTypes.field_185229_a && input.func_77942_o() && (match = input.func_77978_p().func_74779_i("gene")).isEmpty()) {
                match = input.func_77978_p().func_74779_i("entityCodeName");
            }
            if (type == GRPotions.SUBSTRATE) {
                return true;
            }
            if (this.inputGene != null) {
                if (type == GRPotions.VIRAL_POTION && (!input.func_77942_o() || input.func_77942_o() && !input.func_77978_p().func_74764_b("gene"))) {
                    return true;
                }
                return this.inputGene.toGeneName().equals(match);
            }
            if (this.cellType == null) {
                if (type == GRPotions.GROWTH_POTION && input.func_77942_o() && !input.func_77978_p().func_74764_b("entityCodeName")) {
                    return true;
                }
                if (type == GRPotions.MUTATION_POTION && input.func_77942_o() && !input.func_77978_p().func_74764_b("entityCodeName")) {
                    return true;
                }
                if (type == PotionTypes.field_185231_c) {
                    return true;
                }
            } else {
                if (type == GRPotions.VIRAL_POTION) {
                    return true;
                }
                if (this.cellType.equals(match)) {
                    return true;
                }
                if (this.cellType.equals("*") && match != null && !match.isEmpty()) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isIngredient(ItemStack ingredient) {
        if (this.item == GRItems.GlassSyringe && ingredient.func_77973_b() == GRItems.GlassSyringe) {
            List<EnumGenes> required = Arrays.asList(REQUIRED_GENES);
            int found = 0;
            NBTTagCompound tag = ingredient.func_77978_p();
            if (tag != null) {
                for (int i = 0; i < Genes.TotalNumberOfGenes; ++i) {
                    EnumGenes gene;
                    String nbtname = "";
                    if (tag.func_74764_b(Integer.toString(i))) {
                        nbtname = tag.func_74779_i(Integer.toString(i));
                    }
                    if (!required.contains((Object)(gene = EnumGenes.fromGeneName(nbtname)))) continue;
                    ++found;
                }
            }
            return found == required.size();
        }
        if (this.inputGene != null) {
            NBTTagCompound tag = ingredient.func_77978_p();
            return tag != null && this.inputGene.toGeneName().equals(tag.func_74779_i("gene"));
        }
        if (this.cellType != null && ingredient.func_77973_b() == GRItems.DNAHelix) {
            return ingredient.func_77978_p().func_74779_i("gene").equals(this.cellType);
        }
        return ingredient.func_77973_b() == this.item;
    }

    public ItemStack getOutput(ItemStack input, ItemStack ingredient) {
        if (!this.isInput(input) || !this.isIngredient(ingredient)) {
            return ItemStack.field_190927_a;
        }
        ItemStack result = this.output.func_77946_l();
        if (ingredient.func_77942_o() && this.output.func_77973_b() == GRItems.Cell) {
            result.func_77982_d(ingredient.func_77978_p());
            result.func_77978_p().func_82580_o("forceGene");
            result.func_77978_p().func_82580_o("chance");
            return result;
        }
        PotionType type = PotionUtils.func_185191_c((ItemStack)input);
        if ((type == GRPotions.GROWTH_POTION || type == GRPotions.MUTATION_POTION) && this.output.func_77973_b() == GRItems.Cell) {
            result.func_77978_p().func_74778_a("entityName", ModUtils.getTagCompound(input).func_74779_i("entityName"));
            result.func_77978_p().func_74778_a("entityCodeName", ModUtils.getTagCompound(input).func_74779_i("entityCodeName"));
        } else if ((type == GRPotions.GROWTH_POTION || type == GRPotions.MUTATION_POTION) && ingredient.func_77973_b() == GRItems.Cell && ingredient.func_77942_o()) {
            ModUtils.getTagCompound(result).func_74778_a("entityName", ModUtils.getTagCompound(ingredient).func_74779_i("entityName"));
            ModUtils.getTagCompound(result).func_74778_a("entityCodeName", ModUtils.getTagCompound(ingredient).func_74779_i("entityCodeName"));
        }
        return result;
    }
}

