/*
 * Decompiled with CFR 0.152.
 */
package com.theundertaker11.geneticsreborn.tile;

import com.theundertaker11.geneticsreborn.GeneticsReborn;
import com.theundertaker11.geneticsreborn.blocks.StorageBlockBase;
import com.theundertaker11.geneticsreborn.util.CustomEnergyStorage;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class GRTileEntityBasicEnergyReceiver
extends TileEntity {
    private static final int SIZE = 1;
    protected CustomEnergyStorage storage = new CustomEnergyStorage(GeneticsReborn.maxEnergyStored, 20000);
    protected int overclockers;
    protected int ticksCooking;
    protected String name;
    protected ItemStackHandler itemStackHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            GRTileEntityBasicEnergyReceiver.this.func_70296_d();
        }
    };
    protected ItemStackHandler itemStackHandlerOutput = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            GRTileEntityBasicEnergyReceiver.this.func_70296_d();
        }
    };
    private static final byte TICKS_COOKING_FIELD_ID = 0;
    private static final byte ENERGY_STORED_FIELD_ID = 1;
    private static final byte OVERCLOCKERS_FIELD_ID = 2;
    protected byte NUMBER_OF_FIELDS = (byte)3;

    public GRTileEntityBasicEnergyReceiver() {
    }

    public GRTileEntityBasicEnergyReceiver(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74782_a("inputitem", (NBTBase)this.itemStackHandler.serializeNBT());
        compound.func_74782_a("outputitem", (NBTBase)this.itemStackHandlerOutput.serializeNBT());
        this.storage.writeToNBT(compound);
        compound.func_74768_a("overclockers", this.overclockers);
        return compound;
    }

    public static int getSIZE() {
        return 1;
    }

    public double getTotalTicks() {
        return 0.0;
    }

    public double percComplete() {
        return (double)this.ticksCooking / this.getTotalTicks();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        if (compound.func_74764_b("inputitem")) {
            this.itemStackHandler.deserializeNBT((NBTTagCompound)compound.func_74781_a("inputitem"));
        }
        if (compound.func_74764_b("outputitem")) {
            this.itemStackHandlerOutput.deserializeNBT((NBTTagCompound)compound.func_74781_a("outputitem"));
        }
        this.overclockers = compound.func_74762_e("overclockers");
        this.storage.readFromNBT(compound);
    }

    public double fractionOfEnergyRemaining() {
        return this.storage.getEnergyStored() / this.storage.getEnergyStored();
    }

    public void addOverclocker(EntityPlayer player, int maxOverclockers) {
        if (this.overclockers < maxOverclockers) {
            ++this.overclockers;
            player.func_184586_b(EnumHand.MAIN_HAND).func_190918_g(1);
        } else {
            player.func_145747_a((ITextComponent)new TextComponentString("Max Overclockers is " + maxOverclockers));
        }
    }

    public int getOverclockerCount() {
        return this.overclockers;
    }

    public boolean isUseableByPlayer(EntityPlayer playerIn) {
        return !this.func_145837_r() && playerIn.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) <= 64.0;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.func_145831_w().func_180495_p(this.field_174879_c).func_177230_c() instanceof StorageBlockBase) {
            EnumFacing rightSide = ((EnumFacing)this.func_145831_w().func_180495_p(this.field_174879_c).func_177229_b((IProperty)StorageBlockBase.FACING)).func_176732_a(EnumFacing.Axis.Y).func_176734_d();
            if (facing == EnumFacing.DOWN || facing == rightSide) {
                return (T)this.itemStackHandlerOutput;
            }
            return (T)this.itemStackHandler;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == EnumFacing.DOWN) {
                return (T)this.itemStackHandlerOutput;
            }
            return (T)this.itemStackHandler;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.storage);
        }
        return (T)super.getCapability(capability, facing);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound updateTagDescribingTileEntityState = this.func_189517_E_();
        boolean METADATA = false;
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, updateTagDescribingTileEntityState);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound updateTagDescribingTileEntityState = pkt.func_148857_g();
        this.handleUpdateTag(updateTagDescribingTileEntityState);
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        this.func_189515_b(nbtTagCompound);
        return nbtTagCompound;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    public int getField(int id) {
        if (id == 0) {
            return this.ticksCooking;
        }
        if (id == 1) {
            return this.storage.getEnergyStored();
        }
        if (id == 2) {
            return this.overclockers;
        }
        if (id > this.NUMBER_OF_FIELDS) {
            System.err.println("Invalid field ID in GRTileEntity.getField:" + id);
        }
        return 0;
    }

    public void setField(int id, int value) {
        if (id == 0) {
            this.ticksCooking = (short)value;
        } else if (id == 1) {
            this.storage.setEnergyStored((short)value);
        } else if (id == 2) {
            this.overclockers = (short)value;
        }
        if (id > this.NUMBER_OF_FIELDS) {
            System.err.println("Invalid field ID in GRTileEntity.getField:" + id);
        }
    }

    public int getFieldCount() {
        return this.NUMBER_OF_FIELDS;
    }

    public int getEnergyStored() {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.storage.getMaxEnergyStored();
    }
}

