/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.rewired.common.blocks;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.realmsclient.gui.ChatFormatting;
import com.mr208.rewired.ReWIRED;
import com.mr208.rewired.common.ReWIREDContent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneComparator;
import net.minecraft.block.BlockRedstoneDiode;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockRedstoneTorch;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.ArrayUtils;

public class BlockECG
extends Block {
    private static final EnumFacing[] facingsHorizontal = new EnumFacing[]{EnumFacing.WEST, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.SOUTH};
    private static final EnumFacing[] facingsVertical = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.UP};
    private static final EnumFacing[] facings = (EnumFacing[])ArrayUtils.addAll((Object[])facingsVertical, (Object[])facingsHorizontal);
    private List<BlockPos> turnOff = Lists.newArrayList();
    private List<BlockPos> turnOn = Lists.newArrayList();
    private final Set<BlockPos> updatedGlass = Sets.newLinkedHashSet();
    private static final Vec3i[] surroundingBlocksOffset;
    public static final PropertyInteger POWER;
    private boolean canProvidePower = false;
    private EnumDyeColor enumDyeColor = null;

    public BlockECG(EnumDyeColor color) {
        super(Material.field_151592_s);
        String name = "ecglass" + (color == null ? "" : "_" + color.func_176762_d());
        this.setEnumDyeColor(color);
        this.setRegistryName(new ResourceLocation("rewired", name));
        this.func_149663_c("rewired." + name);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(0)));
        this.func_149647_a(ReWIRED.creativeTab);
        ItemBlock itemBlock = new ItemBlock((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)this);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)itemBlock);
        ReWIREDContent.registeredItems.add((Item)itemBlock);
        ReWIREDContent.registeredBlocks.add(this);
        PropertyInteger property = POWER;
    }

    private void setEnumDyeColor(EnumDyeColor color) {
        this.enumDyeColor = color;
    }

    private EnumDyeColor getEnumDyeColor(BlockECG block) {
        return block.enumDyeColor;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149751_l(IBlockState state) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Integer)state.func_177229_b((IProperty)POWER) == 0 ? 0 : 255;
    }

    private void updateSurroundingGlass(World worldIn, BlockPos pos) {
        this.calculateCurrentChanges(worldIn, pos);
        LinkedHashSet blocksNeedingUpdate = Sets.newLinkedHashSet();
        for (BlockPos posi : this.updatedGlass) {
            this.addBlocksNeedingUpdate(worldIn, posi, blocksNeedingUpdate);
        }
        Iterator it = Lists.newLinkedList(this.updatedGlass).descendingIterator();
        while (it.hasNext()) {
            this.addAllSurroundingBlocks((BlockPos)it.next(), blocksNeedingUpdate);
        }
        blocksNeedingUpdate.removeAll(this.updatedGlass);
        this.updatedGlass.clear();
        for (BlockPos posi : blocksNeedingUpdate) {
            worldIn.func_175685_c(posi, (Block)this, true);
        }
    }

    private void calculateCurrentChanges(World worldIn, BlockPos position) {
        int newPower;
        int wirePower;
        int blockPower;
        int oldPower;
        IBlockState state;
        BlockPos pos;
        if (worldIn.func_180495_p(position).func_177230_c() instanceof BlockECG) {
            this.turnOff.add(position);
        } else {
            this.checkSurroundingGlass(worldIn, position);
        }
        while (!this.turnOff.isEmpty()) {
            pos = this.turnOff.remove(0);
            state = worldIn.func_180495_p(pos);
            oldPower = (Integer)state.func_177229_b((IProperty)POWER);
            this.canProvidePower = false;
            blockPower = worldIn.func_175687_A(pos);
            this.canProvidePower = true;
            wirePower = this.getSurroundingGlassPower(worldIn, pos);
            if ((newPower = Math.max(blockPower, --wirePower)) < oldPower) {
                if (blockPower > 0 && !this.turnOn.contains(pos)) {
                    this.turnOn.add(pos);
                }
                this.setGlassState(worldIn, pos, state, 0);
            } else if (newPower > oldPower) {
                this.setGlassState(worldIn, pos, state, newPower);
            }
            this.checkSurroundingGlass(worldIn, pos);
            worldIn.func_175679_n(pos);
        }
        while (!this.turnOn.isEmpty()) {
            pos = this.turnOn.remove(0);
            state = worldIn.func_180495_p(pos);
            oldPower = (Integer)state.func_177229_b((IProperty)POWER);
            this.canProvidePower = false;
            blockPower = worldIn.func_175687_A(pos);
            this.canProvidePower = true;
            wirePower = this.getSurroundingGlassPower(worldIn, pos);
            if ((newPower = Math.max(blockPower, --wirePower)) > oldPower) {
                this.setGlassState(worldIn, pos, state, newPower);
            }
            this.checkSurroundingGlass(worldIn, pos);
            worldIn.func_175679_n(pos);
        }
        this.turnOff.clear();
        this.turnOn.clear();
    }

    private void addGlassToList(World worldIn, BlockPos pos, int otherPower) {
        IBlockState state = worldIn.func_180495_p(pos);
        if (state.func_177230_c() instanceof BlockECG) {
            int power = (Integer)state.func_177229_b((IProperty)POWER);
            if (power < otherPower - 1 && !this.turnOn.contains(pos)) {
                this.turnOn.add(pos);
            }
            if (power > otherPower && !this.turnOff.contains(pos)) {
                this.turnOff.add(pos);
            }
        }
    }

    private void checkSurroundingGlass(World worldIn, BlockPos pos) {
        BlockPos offsetPos;
        IBlockState state = worldIn.func_180495_p(pos);
        int ownPower = 0;
        if (state.func_177230_c() instanceof BlockECG) {
            ownPower = (Integer)state.func_177229_b((IProperty)POWER);
        }
        for (EnumFacing facing : facingsHorizontal) {
            offsetPos = pos.func_177972_a(facing);
            if (!facing.func_176740_k().func_176722_c()) continue;
            this.addGlassToList(worldIn, offsetPos, ownPower);
        }
        for (EnumFacing facingVertical : facingsVertical) {
            offsetPos = pos.func_177972_a(facingVertical);
            for (EnumFacing facingHorizontal : facingsHorizontal) {
                this.addGlassToList(worldIn, offsetPos.func_177972_a(facingHorizontal), ownPower);
            }
            this.addGlassToList(worldIn, offsetPos, ownPower);
        }
    }

    private int getSurroundingGlassPower(World worldIn, BlockPos pos) {
        int glassPower = 0;
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            BlockPos offsetPos = pos.func_177972_a(enumfacing);
            glassPower = this.getMaxCurrentStrength(worldIn, offsetPos, glassPower);
            glassPower = this.getMaxCurrentStrength(worldIn, offsetPos.func_177984_a(), glassPower);
            glassPower = this.getMaxCurrentStrength(worldIn, offsetPos.func_177977_b(), glassPower);
        }
        glassPower = this.getMaxCurrentStrength(worldIn, pos.func_177984_a(), glassPower);
        glassPower = this.getMaxCurrentStrength(worldIn, pos.func_177977_b(), glassPower);
        return glassPower;
    }

    private void addBlocksNeedingUpdate(World worldIn, BlockPos pos, Set<BlockPos> set) {
        BlockPos offsetPos;
        List<EnumFacing> connectedSides = this.getSidesToPower(worldIn, pos);
        for (EnumFacing facing : facings) {
            offsetPos = pos.func_177972_a(facing);
            if (!connectedSides.contains(facing.func_176734_d()) && facing != EnumFacing.DOWN && (!facing.func_176740_k().func_176722_c() || !BlockECG.canConnectTo(worldIn.func_180495_p(offsetPos), facing)) || !this.canBlockBePoweredFromSide(worldIn.func_180495_p(offsetPos), facing, true)) continue;
            set.add(offsetPos);
        }
        for (EnumFacing facing : facings) {
            offsetPos = pos.func_177972_a(facing);
            if (!connectedSides.contains(facing.func_176734_d()) && facing != EnumFacing.DOWN || !worldIn.func_180495_p(offsetPos).func_185915_l()) continue;
            for (EnumFacing facing1 : facings) {
                if (!this.canBlockBePoweredFromSide(worldIn.func_180495_p(offsetPos.func_177972_a(facing1)), facing1, false)) continue;
                set.add(offsetPos.func_177972_a(facing1));
            }
        }
    }

    private boolean canBlockBePoweredFromSide(IBlockState state, EnumFacing side, boolean isWire) {
        if (state.func_177230_c() instanceof BlockRedstoneDiode && state.func_177229_b((IProperty)BlockRedstoneDiode.field_185512_D) != side.func_176734_d()) {
            return isWire && state.func_177230_c() instanceof BlockRedstoneComparator && ((EnumFacing)state.func_177229_b((IProperty)BlockRedstoneComparator.field_185512_D)).func_176740_k() != side.func_176740_k() && side.func_176740_k().func_176722_c();
        }
        if (state.func_177230_c() instanceof BlockRedstoneTorch) {
            return !isWire && state.func_177229_b((IProperty)BlockRedstoneTorch.field_176596_a) == side;
        }
        return state.func_177230_c() instanceof BlockECG;
    }

    private List<EnumFacing> getSidesToPower(World worldIn, BlockPos pos) {
        boolean eastwest;
        ArrayList<EnumFacing> retval = new ArrayList<EnumFacing>();
        for (EnumFacing facing : facingsHorizontal) {
            if (!this.isPowerSourceAt((IBlockAccess)worldIn, pos, facing)) continue;
            retval.add(facing);
        }
        if (retval.isEmpty()) {
            return Lists.newArrayList((Object[])facingsHorizontal);
        }
        boolean northsouth = retval.contains(EnumFacing.NORTH) || retval.contains(EnumFacing.SOUTH);
        boolean bl = eastwest = retval.contains(EnumFacing.EAST) || retval.contains(EnumFacing.WEST);
        if (northsouth) {
            retval.remove(EnumFacing.EAST);
            retval.remove(EnumFacing.WEST);
        }
        if (eastwest) {
            retval.remove(EnumFacing.NORTH);
            retval.remove(EnumFacing.SOUTH);
        }
        return retval;
    }

    private void addAllSurroundingBlocks(BlockPos pos, Set<BlockPos> set) {
        for (Vec3i vect : surroundingBlocksOffset) {
            set.add(pos.func_177971_a(vect));
        }
    }

    private void setGlassState(World worldIn, BlockPos pos, IBlockState state, int power) {
        state = state.func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(power));
        worldIn.func_180501_a(pos, state, 2);
        this.updatedGlass.add(pos);
    }

    private static boolean canConnectUpwardsTo(IBlockAccess worldIn, BlockPos pos) {
        return BlockECG.canConnectUpwardsTo(worldIn.func_180495_p(pos));
    }

    private static boolean canConnectUpwardsTo(IBlockState state) {
        return BlockECG.canConnectTo(state, null);
    }

    private static boolean canConnectTo(IBlockState blockState, @Nullable EnumFacing side) {
        Block block = blockState.func_177230_c();
        if (block instanceof BlockECG) {
            return true;
        }
        if (block == Blocks.field_150488_af) {
            return true;
        }
        if (Blocks.field_150413_aR.func_185547_C(blockState)) {
            EnumFacing enumfacing = (EnumFacing)blockState.func_177229_b((IProperty)BlockRedstoneRepeater.field_185512_D);
            return enumfacing == side || enumfacing.func_176734_d() == side;
        }
        return blockState.func_185897_m() && side != null;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!worldIn.field_72995_K) {
            this.updateSurroundingGlass(worldIn, pos);
            for (Vec3i vec : surroundingBlocksOffset) {
                worldIn.func_175685_c(pos.func_177971_a(vec), (Block)this, true);
            }
        }
    }

    private int getMaxCurrentStrength(World worldIn, BlockPos pos, int strength) {
        if (!(worldIn.func_180495_p(pos).func_177230_c() instanceof BlockECG)) {
            return strength;
        }
        int i = (Integer)worldIn.func_180495_p(pos).func_177229_b((IProperty)POWER);
        return i > strength ? i : strength;
    }

    public void func_180663_b(@Nonnull World worldIn, @Nonnull BlockPos pos, @Nonnull IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        if (!worldIn.field_72995_K) {
            this.updateSurroundingGlass(worldIn, pos);
            for (Vec3i vec : surroundingBlocksOffset) {
                worldIn.func_175685_c(pos.func_177971_a(vec), (Block)this, true);
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!worldIn.field_72995_K) {
            if (this.func_176196_c(worldIn, pos)) {
                this.updateSurroundingGlass(worldIn, pos);
            } else {
                this.func_176226_b(worldIn, pos, state, 0);
                worldIn.func_175698_g(pos);
            }
        }
    }

    public boolean func_176196_c(World worldIn, @Nonnull BlockPos pos) {
        return true;
    }

    public int func_176211_b(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return !this.canProvidePower ? 0 : blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        if (!this.canProvidePower) {
            return 0;
        }
        if (side == EnumFacing.UP || this.getSidesToPower((World)blockAccess, pos).contains(side) && ((World)blockAccess).func_180495_p(pos.func_177972_a(side.func_176734_d())).func_177230_c() == this) {
            return (Integer)blockState.func_177229_b((IProperty)POWER);
        }
        return 0;
    }

    private boolean isPowerSourceAt(IBlockAccess worldIn, BlockPos pos, EnumFacing side) {
        BlockPos blockpos = pos.func_177972_a(side);
        IBlockState iblockstate = worldIn.func_180495_p(blockpos);
        boolean flag = iblockstate.func_185915_l();
        boolean flag1 = worldIn.func_180495_p(pos.func_177984_a()).func_185915_l();
        return !flag1 && flag && BlockECG.canConnectUpwardsTo(worldIn, blockpos.func_177984_a()) || BlockECG.canConnectTo(iblockstate, side) || iblockstate.func_177230_c() == Blocks.field_150416_aS && iblockstate.func_177229_b((IProperty)BlockRedstoneDiode.field_185512_D) == side || !flag && BlockECG.canConnectUpwardsTo(worldIn, blockpos.func_177977_b());
    }

    public boolean func_149744_f(IBlockState state) {
        return this.canProvidePower;
    }

    @Nonnull
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)POWER, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)POWER);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{POWER});
    }

    public boolean func_176225_a(IBlockState blockState, @Nonnull IBlockAccess blockAccess, @Nonnull BlockPos pos, EnumFacing side) {
        IBlockState adjacentState = blockAccess.func_180495_p(pos.func_177972_a(side));
        if (blockState.func_177230_c() != adjacentState.func_177230_c()) {
            return true;
        }
        if ((Integer)blockState.func_177229_b((IProperty)POWER) == 0 && (Integer)blockState.func_177229_b((IProperty)POWER) == 0) {
            return false;
        }
        if ((Integer)blockState.func_177229_b((IProperty)POWER) == 0 && (Integer)adjacentState.func_177229_b((IProperty)POWER) != 0) {
            return true;
        }
        return (Integer)blockState.func_177229_b((IProperty)POWER) == 0 || (Integer)adjacentState.func_177229_b((IProperty)POWER) == 0;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World worldIn, BlockPos pos) {
        return (Integer)blockState.func_177229_b((IProperty)POWER);
    }

    public String func_149739_a() {
        return "tile.rewired.ecglass";
    }

    @SideOnly(value=Side.CLIENT)
    public String func_149732_F() {
        return super.func_149732_F() + "(" + I18n.func_135052_a((String)this.enumDyeColor.func_176762_d(), (Object[])new Object[0]) + ")";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        tooltip.add(ChatFormatting.GRAY + I18n.func_135052_a((String)"tile.rewired.ecglass.tooltip", (Object[])new Object[0]));
        super.func_190948_a(stack, player, tooltip, advanced);
    }

    static {
        LinkedHashSet set = Sets.newLinkedHashSet();
        for (EnumFacing facing : facings) {
            set.add(facing.func_176730_m());
        }
        for (EnumFacing facing1 : facings) {
            Vec3i v1 = facing1.func_176730_m();
            for (EnumFacing facing2 : facings) {
                Vec3i v2 = facing2.func_176730_m();
                set.add(new Vec3i(v1.func_177958_n() + v2.func_177958_n(), v1.func_177956_o() + v2.func_177956_o(), v1.func_177952_p() + v2.func_177952_p()));
            }
        }
        set.remove(new Vec3i(0, 0, 0));
        surroundingBlocksOffset = set.toArray(new Vec3i[set.size()]);
        POWER = PropertyInteger.func_177719_a((String)"power", (int)0, (int)15);
    }
}

