/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.rewired.common.handlers;

import com.mr208.rewired.common.ReWIREDContent;
import com.mr208.rewired.common.handlers.ConfigHandler;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.common.CyberwareContent;
import flaxbeard.cyberware.common.item.ItemBlueprint;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandom;
import net.minecraft.village.MerchantRecipe;
import net.minecraft.village.MerchantRecipeList;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="rewired")
public class VillagerHandler {
    public static VillagerRegistry.VillagerProfession cyberwareVillager;
    public static VillagerRegistry.VillagerCareer runnerCareer;

    public static void onPreInit() {
        cyberwareVillager = new VillagerRegistry.VillagerProfession("rewired:runner", "rewired:textures/entities/villagers/runner.png", "rewired:textures/entities/villagers/zombie_runner.png");
        runnerCareer = new VillagerRegistry.VillagerCareer(cyberwareVillager, "runner");
        runnerCareer.addTrade(1, new EntityVillager.ITradeList[]{new RandomItemsForEmeralds(new EntityVillager.PriceInfo(11, 17), VillagerHandler.getTradeEquipment())});
        runnerCareer.addTrade(1, new EntityVillager.ITradeList[]{new RandomItemsForEmeralds(new EntityVillager.PriceInfo(3, 6), VillagerHandler.getTradeConsumables())});
        runnerCareer.addTrade(2, new EntityVillager.ITradeList[]{new RandomCyberwareForEmeralds(CyberwareTrade.SCAVENGED)});
        runnerCareer.addTrade(2, new EntityVillager.ITradeList[]{new EmeraldsForRandomItem(new EntityVillager.PriceInfo(1, 3), new ItemStack(CyberwareContent.neuropozyne))});
        runnerCareer.addTrade(3, new EntityVillager.ITradeList[]{new RandomCyberwareForEmeralds(CyberwareTrade.MANUFACTURED)});
        runnerCareer.addTrade(3, new EntityVillager.ITradeList[]{new RandomCyberwareForEmeralds(CyberwareTrade.BLUEPRINT)});
        runnerCareer.addTrade(3, new EntityVillager.ITradeList[]{new RandomEnchantedItemForEmeralds(new EntityVillager.PriceInfo(11, 19), 35, VillagerHandler.getTradeEquipment())});
    }

    @SubscribeEvent
    public static void registerVillager(RegistryEvent.Register<VillagerRegistry.VillagerProfession> event) {
        if (ConfigHandler.Entities.enableVillager) {
            event.getRegistry().register((IForgeRegistryEntry)cyberwareVillager);
        }
    }

    protected static ItemStack[] getTradeEquipment() {
        ArrayList<ItemStack> cyberEquipment = new ArrayList<ItemStack>();
        cyberEquipment.add(new ItemStack((Item)CyberwareContent.trenchCoat));
        cyberEquipment.add(new ItemStack(CyberwareContent.jacket));
        cyberEquipment.add(new ItemStack(CyberwareContent.shades));
        cyberEquipment.add(new ItemStack(CyberwareContent.shades2));
        cyberEquipment.add(new ItemStack((Item)ReWIREDContent.armorARVisor));
        if (ConfigHandler.Equipment.shields.enableShields) {
            cyberEquipment.add(new ItemStack((Item)ReWIREDContent.itemShieldCarbon));
        }
        return cyberEquipment.toArray(new ItemStack[cyberEquipment.size()]);
    }

    protected static ItemStack[] getTradeConsumables() {
        ArrayList<ItemStack> consumables = new ArrayList<ItemStack>();
        consumables.add(new ItemStack(CyberwareContent.neuropozyne));
        consumables.add(new ItemStack((Item)ReWIREDContent.foodPowerbar));
        consumables.add(new ItemStack((Item)ReWIREDContent.foodSilverGorgon));
        return consumables.toArray(new ItemStack[consumables.size()]);
    }

    static enum CyberwareTrade {
        BLUEPRINT,
        SCAVENGED,
        MANUFACTURED;

    }

    static class RandomItemsForEmeralds
    implements EntityVillager.ITradeList {
        EntityVillager.PriceInfo price;
        ItemStack[] items;

        public RandomItemsForEmeralds(EntityVillager.PriceInfo priceInfo, ItemStack ... items) {
            this.price = priceInfo;
            this.items = items;
        }

        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int i = 1;
            if (this.price != null) {
                i = this.price.func_179412_a(random);
            }
            ItemStack emeraldsIn = new ItemStack(Items.field_151166_bC, i, 0);
            ItemStack itemOut = this.items.length == 1 ? this.items[0] : this.items[random.nextInt(this.items.length)].func_77946_l();
            recipeList.add((Object)new MerchantRecipe(emeraldsIn, itemOut));
        }
    }

    static class EmeraldsForRandomItem
    implements EntityVillager.ITradeList {
        ItemStack[] items;
        EntityVillager.PriceInfo price;

        public EmeraldsForRandomItem(EntityVillager.PriceInfo priceInfo, ItemStack ... items) {
            this.items = items;
            this.price = priceInfo;
        }

        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int i = 1;
            if (this.price != null) {
                i = this.price.func_179412_a(random);
            }
            ItemStack emeraldsOut = new ItemStack(Items.field_151166_bC, i, 0);
            ItemStack itemIn = this.items.length == 0 ? this.items[0].func_77946_l() : this.items[random.nextInt(this.items.length)].func_77946_l();
            recipeList.add((Object)new MerchantRecipe(itemIn, emeraldsOut));
        }
    }

    static class RandomEnchantedItemForEmeralds
    implements EntityVillager.ITradeList {
        ItemStack[] items;
        EntityVillager.PriceInfo price;
        int level;

        public RandomEnchantedItemForEmeralds(EntityVillager.PriceInfo priceInfo, int level, ItemStack ... items) {
            this.items = items;
            this.price = priceInfo;
            this.level = level;
        }

        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int i = 1;
            if (this.price != null) {
                i = this.price.func_179412_a(random);
            }
            ItemStack emeraldsIn = new ItemStack(Items.field_151166_bC, i, 0);
            ItemStack enchantedOut = this.items.length == 1 ? EnchantmentHelper.func_77504_a((Random)random, (ItemStack)this.items[0], (int)this.level, (boolean)true) : EnchantmentHelper.func_77504_a((Random)random, (ItemStack)this.items[random.nextInt(this.items.length)].func_77946_l(), (int)this.level, (boolean)true);
            recipeList.add((Object)new MerchantRecipe(emeraldsIn, enchantedOut));
        }
    }

    static class RandomCyberwareForEmeralds
    implements EntityVillager.ITradeList {
        CyberwareTrade tradeType;

        public RandomCyberwareForEmeralds(CyberwareTrade tradeType) {
            this.tradeType = tradeType;
        }

        public void func_190888_a(IMerchant merchant, MerchantRecipeList recipeList, Random random) {
            int emeraldCost = 0;
            CyberwareContent.ZombieItem randomZombieItem = (CyberwareContent.ZombieItem)WeightedRandom.func_76271_a((Random)random, (List)CyberwareContent.zombieItems);
            ItemStack randomItem = randomZombieItem.stack.func_77946_l();
            randomItem.func_190920_e(1);
            int itemWeight = randomZombieItem.field_76292_a;
            if (this.tradeType == CyberwareTrade.BLUEPRINT) {
                ItemStack itemStackOut = ItemBlueprint.getBlueprintForItem((ItemStack)randomItem);
                emeraldCost = (int)Math.floor(48.0f - 48.0f * ((float)itemWeight / 100.0f));
                ItemStack emeraldsIn = new ItemStack(Items.field_151166_bC, Math.max(1, emeraldCost), 0);
                recipeList.add((Object)new MerchantRecipe(emeraldsIn, itemStackOut));
            } else if (this.tradeType == CyberwareTrade.SCAVENGED) {
                ItemStack itemStackOut = CyberwareAPI.writeQualityTag((ItemStack)randomItem, (ICyberware.Quality)CyberwareAPI.QUALITY_SCAVENGED);
                emeraldCost = (int)Math.floor(32.0f - 32.0f * ((float)itemWeight / 100.0f));
                ItemStack emeraldsIn = new ItemStack(Items.field_151166_bC, Math.max(1, emeraldCost), 0);
                recipeList.add((Object)new MerchantRecipe(emeraldsIn, itemStackOut));
            } else if (this.tradeType == CyberwareTrade.MANUFACTURED) {
                ItemStack itemStackOut = CyberwareAPI.writeQualityTag((ItemStack)randomItem, (ICyberware.Quality)CyberwareAPI.QUALITY_MANUFACTURED);
                emeraldCost = (int)Math.floor(64.0f - 64.0f * ((float)itemWeight / 100.0f));
                ItemStack emeraldsIn = new ItemStack(Items.field_151166_bC, Math.max(1, emeraldCost), 0);
                recipeList.add((Object)new MerchantRecipe(emeraldsIn, itemStackOut));
            }
        }
    }
}

