/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.rewired.common.items.augments;

import com.mr208.rewired.common.handlers.ConfigHandler;
import com.mr208.rewired.common.items.augments.ItemAugment;
import com.mr208.rewired.common.util.CyberwareHelper;
import flaxbeard.cyberware.api.CyberwareAPI;
import flaxbeard.cyberware.api.CyberwareUpdateEvent;
import flaxbeard.cyberware.api.ICyberwareUserData;
import flaxbeard.cyberware.api.item.EnableDisableHelper;
import flaxbeard.cyberware.api.item.ICyberware;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSkinAugment
extends ItemAugment {
    public static final int META_CAMO = 0;
    public static final int META_AEGIS = 1;
    public static final int META_PLATES = 2;
    private static final AttributeModifier PLATE_ARMOR = new AttributeModifier(UUID.fromString("f21b6200-6181-4776-8705-4aa80f5ab035"), "Armor modifier", 4.0, 0);
    private static final AttributeModifier PLATE_TOUGHNESS = new AttributeModifier(UUID.fromString("fad806d4-3f6b-4539-83a2-2aad1396bdeb"), "Armor toughness", 2.0, 0);
    private static final AttributeModifier AEGIS_ARMOR = new AttributeModifier(UUID.fromString("f21b6200-6181-4776-8705-4d480f5ab035"), "Armor modifier", 10.0, 0);
    private static final AttributeModifier AEGIS_TOUGHNESS = new AttributeModifier(UUID.fromString("fad806d4-3f6b-4539-83a2-28dd1396bdeb"), "Armor toughness", 12.0, 0);
    private Set<UUID> lastAEGIS = new HashSet<UUID>();

    public ItemSkinAugment(String name, ICyberware.EnumSlot slots, String[] subnames) {
        super(name, slots, subnames);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onAdded(EntityLivingBase entityLivingBase, ItemStack itemStack) {
        if (!(entityLivingBase instanceof EntityPlayer) && itemStack.func_77952_i() == 0 && EnableDisableHelper.isEnabled((ItemStack)itemStack)) {
            EnableDisableHelper.toggle((ItemStack)itemStack);
        }
        if (itemStack.func_77952_i() == 1 && EnableDisableHelper.isEnabled((ItemStack)itemStack)) {
            EnableDisableHelper.toggle((ItemStack)itemStack);
        }
    }

    @Override
    public void onRemoved(EntityLivingBase entityLivingBase, ItemStack itemStack) {
        super.onRemoved(entityLivingBase, itemStack);
        if (itemStack.func_77952_i() == 1) {
            this.removeAEGISBonus(entityLivingBase);
        }
    }

    private void removeAEGISBonus(EntityLivingBase entityLivingBase) {
        entityLivingBase.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111124_b(AEGIS_ARMOR);
        entityLivingBase.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111124_b(AEGIS_TOUGHNESS);
        World world = entityLivingBase.func_130014_f_();
        world.func_184133_a(null, entityLivingBase.func_180425_c(), SoundEvents.field_187581_bW, SoundCategory.PLAYERS, 1.0f, 0.6f);
    }

    private void addAEGISBonus(EntityLivingBase entityLivingBase) {
        entityLivingBase.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(AEGIS_ARMOR);
        entityLivingBase.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111121_a(AEGIS_TOUGHNESS);
        World world = entityLivingBase.func_130014_f_();
        world.func_184133_a(null, entityLivingBase.func_180425_c(), SoundEvents.field_187581_bW, SoundCategory.PLAYERS, 1.0f, 0.6f);
    }

    @SubscribeEvent
    public void onDeath(LivingDeathEvent event) {
        ICyberwareUserData data = CyberwareAPI.getCapabilityOrNull((Entity)event.getEntityLiving());
        if (data != null && CyberwareHelper.isAugmentAvailable(event.getEntityLiving(), this.getCachedStack(1))) {
            EntityLivingBase entityLivingBase = event.getEntityLiving();
            this.removeAEGISBonus(entityLivingBase);
            EnableDisableHelper.toggle((ItemStack)data.getCyberware(this.getCachedStack(1)));
        }
    }

    @Override
    public int getPowerConsumption(ItemStack itemStack) {
        if (itemStack.func_77973_b() instanceof ItemSkinAugment) {
            switch (itemStack.func_77952_i()) {
                case 0: {
                    return ConfigHandler.Augments.TOC.ENERGY_COST;
                }
                case 1: {
                    return ConfigHandler.Augments.adm.ENERGY_COST;
                }
            }
            return super.getPowerConsumption(itemStack);
        }
        return super.getPowerConsumption(itemStack);
    }

    @Override
    public boolean hasMenu(ItemStack itemStack) {
        switch (itemStack.func_77952_i()) {
            case 0: 
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void use(Entity entity, ItemStack itemStack) {
        super.use(entity, itemStack);
        if (itemStack.func_77952_i() == 0) {
            if (!EnableDisableHelper.isEnabled((ItemStack)itemStack)) {
                ((EntityLivingBase)entity).func_184589_d(MobEffects.field_76441_p);
                entity.field_70170_p.func_72870_g(entity);
            }
            return;
        }
        if (itemStack.func_77952_i() == 1 && entity instanceof EntityLivingBase) {
            EntityLivingBase e = (EntityLivingBase)entity;
            if (!EnableDisableHelper.isEnabled((ItemStack)itemStack)) {
                this.removeAEGISBonus(e);
            } else {
                this.addAEGISBonus(e);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onRenderPlayerEvent(RenderLivingEvent.Pre event) {
        if (CyberwareHelper.isAugmentAvailable(event.getEntity(), this.getCachedStack(0)) && event.getEntity().func_70644_a(MobEffects.field_76441_p)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onCyberwareUpdate(CyberwareUpdateEvent event) {
        boolean powerUsed;
        EntityLivingBase entityLivingBase = event.getEntityLiving();
        if (entityLivingBase == null) {
            return;
        }
        if (entityLivingBase.field_70173_aa % 20 == 0 && CyberwareHelper.isAugmentAvailable(entityLivingBase, this.getCachedStack(0))) {
            ICyberwareUserData data = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
            if (data.usePower(this.getCachedStack(0), this.getPowerConsumption(this.getCachedStack(0)))) {
                entityLivingBase.func_70690_d(new PotionEffect(MobEffects.field_76441_p, Integer.MAX_VALUE, 0, true, false));
            } else {
                entityLivingBase.func_184589_d(MobEffects.field_76441_p);
            }
            data.updateCapacity();
            if (!entityLivingBase.field_70170_p.field_72995_K) {
                CyberwareAPI.updateData((Entity)entityLivingBase);
            }
        }
        boolean last = this.lastAEGIS.contains(entityLivingBase.func_110124_au());
        ICyberwareUserData data = CyberwareAPI.getCapabilityOrNull((Entity)entityLivingBase);
        boolean bl = powerUsed = data != null && CyberwareHelper.isAugmentAvailable(entityLivingBase, this.getCachedStack(1)) && entityLivingBase.field_70173_aa % 20 == 0 ? data.usePower(this.getCachedStack(1), this.getPowerConsumption(this.getCachedStack(1))) : last;
        if (powerUsed) {
            if (!this.lastAEGIS.contains(entityLivingBase.func_110124_au())) {
                this.lastAEGIS.add(entityLivingBase.func_110124_au());
            }
        } else {
            if (this.lastAEGIS.contains(entityLivingBase.func_110124_au())) {
                this.lastAEGIS.remove(entityLivingBase.func_110124_au());
            }
            if (CyberwareHelper.isAugmentAvailable(entityLivingBase, this.getCachedStack(1))) {
                EnableDisableHelper.toggle((ItemStack)this.getCachedStack(1));
            }
        }
    }
}

