/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.rewired.common.items.augments.overrides;

import com.mojang.realmsclient.gui.ChatFormatting;
import flaxbeard.cyberware.api.item.ICyberware;
import flaxbeard.cyberware.api.item.ICyberwareTabItem;
import flaxbeard.cyberware.api.item.IDeconstructable;
import flaxbeard.cyberware.common.item.ItemBodyPart;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBodyPartOverride
extends ItemBodyPart
implements ICyberware,
ICyberwareTabItem,
IDeconstructable,
ICyberware.ISidedLimb {
    public boolean[] isFood;
    public final int[] itemUseDuration;
    private final int[] healAmount;
    private final float[] saturationModifier;
    private boolean[] alwaysEdible;
    private PotionEffect[] potionEffect;
    private float[] effectProbability;

    public ItemBodyPartOverride(String name, ICyberware.EnumSlot[] slots, String[] subnames) {
        super("cyberware:" + name, slots, subnames);
        this.func_77655_b("cyberware." + name);
        this.isFood = new boolean[Math.max(subnames.length, 1)];
        this.itemUseDuration = new int[Math.max(subnames.length, 1)];
        this.healAmount = new int[Math.max(subnames.length, 1)];
        this.saturationModifier = new float[Math.max(subnames.length, 1)];
        this.alwaysEdible = new boolean[Math.max(subnames.length, 1)];
        this.potionEffect = new PotionEffect[Math.max(subnames.length, 1)];
        this.effectProbability = new float[Math.max(subnames.length, 1)];
        for (int i = 0; i < subnames.length; ++i) {
            this.isFood[i] = false;
            this.itemUseDuration[i] = 32;
            this.healAmount[i] = 0;
            this.saturationModifier[i] = 0.0f;
            this.alwaysEdible[i] = false;
            this.potionEffect[i] = new PotionEffect(MobEffects.field_76438_s, 600, 0);
            this.effectProbability[i] = 0.8f;
        }
    }

    public boolean hasContainerItem(ItemStack itemStack) {
        return itemStack.func_77952_i() > 7 && itemStack.func_77952_i() < 12 || super.hasContainerItem(itemStack);
    }

    public ItemStack getContainerItem(ItemStack itemStack) {
        return itemStack.func_77952_i() > 7 && itemStack.func_77952_i() < 12 ? new ItemStack(Items.field_151103_aS) : super.getContainerItem(itemStack);
    }

    public int getHealAmount(ItemStack stack) {
        return this.healAmount[stack.func_77952_i()];
    }

    public float getSaturationModifier(ItemStack stack) {
        return this.saturationModifier[stack.func_77952_i()];
    }

    public ItemBodyPartOverride setPotionEffect(int meta, PotionEffect effect, float probability) {
        this.potionEffect[meta] = effect;
        this.effectProbability[meta] = probability;
        return this;
    }

    public ItemBodyPartOverride setAlwaysEdible(int ... meta) {
        for (int i : meta) {
            this.alwaysEdible[i] = true;
        }
        return this;
    }

    public ItemBodyPartOverride setFoodStats(int meta, int healing, float saturation) {
        this.isFood[meta] = true;
        this.healAmount[meta] = healing;
        this.saturationModifier[meta] = saturation;
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(ChatFormatting.GOLD + I18n.func_135052_a((String)"tooltip.rewired.changed", (Object[])new Object[0]));
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer entityplayer = (EntityPlayer)entityLiving;
            entityplayer.func_71024_bL().func_75122_a(this.getHealAmount(stack), this.getSaturationModifier(stack));
            worldIn.func_184148_a((EntityPlayer)null, entityplayer.field_70165_t, entityplayer.field_70163_u, entityplayer.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            this.onFoodEaten(stack, worldIn, entityplayer);
            entityplayer.func_71029_a(StatList.func_188057_b((Item)this));
            if (entityplayer instanceof EntityPlayerMP) {
                CriteriaTriggers.field_193138_y.func_193148_a((EntityPlayerMP)entityplayer, stack);
            }
        }
        stack.func_190918_g(1);
        return stack;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (playerIn.func_71043_e(this.alwaysEdible[itemstack.func_77952_i()])) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemstack);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        if (this.isFood[stack.func_77952_i()]) {
            return EnumAction.EAT;
        }
        return super.func_77661_b(stack);
    }

    public int func_77626_a(ItemStack stack) {
        if (this.isFood[stack.func_77952_i()]) {
            return this.itemUseDuration[stack.func_77952_i()];
        }
        return super.func_77626_a(stack);
    }

    protected void onFoodEaten(ItemStack stack, World worldIn, EntityPlayer player) {
        if (!worldIn.field_72995_K && this.potionEffect[stack.func_77952_i()] != null && worldIn.field_73012_v.nextFloat() < this.effectProbability[stack.func_77952_i()]) {
            player.func_70690_d(new PotionEffect(this.potionEffect[stack.func_77952_i()]));
        }
    }
}

