/*
 * Decompiled with CFR 0.152.
 */
package com.mr208.rewired.common.items.equipment;

import com.mojang.realmsclient.gui.ChatFormatting;
import com.mr208.rewired.ReWIRED;
import com.mr208.rewired.common.items.ItemReWIRED;
import flaxbeard.cyberware.api.item.IDeconstructable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemRiotShield
extends ItemReWIRED
implements IDeconstructable {
    public Item.ToolMaterial shieldMaterial;
    private NonNullList<ItemStack> components = NonNullList.func_191196_a();

    public ItemRiotShield(Item.ToolMaterial material) {
        super("shield." + material.name().toLowerCase(), new String[0]);
        this.shieldMaterial = material;
        this.func_77637_a(ReWIRED.creativeTab);
        this.field_77777_bU = 1;
        this.func_77656_e(material.func_77997_a());
        this.func_185043_a(new ResourceLocation("blocking"), new IItemPropertyGetter(){

            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)ItemArmor.field_96605_cw);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    public void damageShield(ItemStack stackIn, int damageIn, EntityPlayer blockingEntity, Entity attackingEntity) {
        stackIn.func_77972_a(damageIn, (EntityLivingBase)blockingEntity);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)playerIn.func_184607_cu());
    }

    public boolean isShield(ItemStack stack, @Nullable EntityLivingBase entity) {
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.shieldMaterial.getRepairItemStack();
        return !mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false) || super.func_82789_a(toRepair, repair);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(ChatFormatting.DARK_GRAY + I18n.func_135052_a((String)(this.func_77658_a() + ".tooltip"), (Object[])new Object[0]));
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }

    public boolean canDestroy(ItemStack itemStack) {
        return !this.components.isEmpty();
    }

    public NonNullList<ItemStack> getComponents(ItemStack itemStack) {
        return this.components;
    }

    public void setComponents(NonNullList<ItemStack> components) {
        this.components = components;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public void handleShieldDamage(LivingAttackEvent event) {
        EntityPlayer player;
        if (event.getEntity() instanceof EntityPlayer && !(player = (EntityPlayer)event.getEntityLiving()).func_184607_cu().func_190926_b()) {
            ItemStack itemStack = player.func_184607_cu();
            float damageIn = event.getAmount();
            if (damageIn >= 2.5f && itemStack.func_77973_b() instanceof ItemRiotShield) {
                ((ItemRiotShield)itemStack.func_77973_b()).damageShield(itemStack, 1 + MathHelper.func_76141_d((float)damageIn), player, event.getSource().func_76346_g());
                if (itemStack.func_190916_E() <= 0) {
                    EnumHand activeHand = player.func_184600_cs();
                    ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)player.func_184607_cu(), (EnumHand)activeHand);
                    player.func_184201_a(activeHand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
                    player.func_184597_cx();
                    player.func_184185_a(SoundEvents.field_187769_eM, 0.8f, 0.8f + player.field_70170_p.field_73012_v.nextFloat() * 0.4f);
                }
            }
        }
    }
}

