/*
 * Decompiled with CFR 0.152.
 */
package ZombieAwareness;

import CoroUtil.forge.CULog;
import ZombieAwareness.WorldEventListener;
import ZombieAwareness.ZAUtil;
import ZombieAwareness.ZombieAwareness;
import ZombieAwareness.config.ZAConfig;
import net.minecraft.util.EnumHand;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.event.entity.PlaySoundAtEntityEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ZAEventHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SubscribeEvent
    public void soundEvent(PlaySoundAtEntityEvent event) {
        try {
            if (event.getEntity() == null) return;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public void setAttackTarget(LivingSetAttackTargetEvent event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            if (!ZAUtil.isZombieAwarenessActive(event.getEntityLiving().field_70170_p)) {
                return;
            }
            ZAUtil.hookSetAttackTarget(event);
        }
    }

    @SubscribeEvent
    public void breakSpeed(PlayerEvent.BreakSpeed event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            if (!ZAUtil.isZombieAwarenessActive(event.getEntityLiving().field_70170_p)) {
                return;
            }
            if (!ZAConfig.blockHittingEvent_Active) {
                return;
            }
            ZAUtil.hookBlockEvent((PlayerEvent)event, ZAConfig.blockHittingEvent_OddsTo1);
        }
    }

    @SubscribeEvent
    public void harvest(PlayerEvent.HarvestCheck event) {
        if (!event.getEntityLiving().field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void breakBlock(BlockEvent.HarvestDropsEvent event) {
        if (!event.getWorld().field_72995_K) {
            if (!ZAUtil.isZombieAwarenessActive(event.getWorld())) {
                return;
            }
            if (!ZAConfig.blockBreakEvent_Active) {
                return;
            }
            ZombieAwareness.dbg("HarvestDrops event");
            ZAUtil.handleBlockBasedEvent(event.getHarvester(), event.getWorld(), event.getPos(), 3);
        }
    }

    @SubscribeEvent
    public void interact(PlayerInteractEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K || event.getHand() == EnumHand.MAIN_HAND) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void tickServer(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (!ZAUtil.isZombieAwarenessActive((World)DimensionManager.getWorld((int)0))) {
                return;
            }
            ZombieAwareness.instance.onTick();
        }
    }

    @SubscribeEvent
    public void worldLoad(WorldEvent.Load event) {
        int dimID = event.getWorld().field_73011_w.getDimension();
        CULog.dbg((String)("adding ZA world listener for dimID: " + dimID + ", remote?: " + event.getWorld().field_72995_K));
        event.getWorld().func_72954_a((IWorldEventListener)new WorldEventListener(dimID));
    }

    @SubscribeEvent
    public void tickEntity(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntityLiving().field_70170_p.field_72995_K) {
            return;
        }
        ZombieAwareness.tickEntity(event.getEntityLiving());
    }

    @SubscribeEvent
    public void tickPlayer(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K || event.phase == TickEvent.Phase.END) {
            return;
        }
        if (event.player.field_70170_p.func_82737_E() % (long)ZAConfig.tickRatePlayerLoop == 0L) {
            if (event.player.field_70170_p.field_73011_w.getDimension() == 0) {
                // empty if block
            }
            ZAUtil.tickPlayer(event.player);
        }
    }

    @SubscribeEvent
    public void tickWorld(TickEvent.WorldTickEvent event) {
        if (event.world.field_72995_K || event.phase == TickEvent.Phase.END) {
            return;
        }
        ZombieAwareness.tickWorld(event.world);
    }
}

