/*
 * Decompiled with CFR 0.152.
 */
package levelup2.network;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import levelup2.LevelUp2;
import levelup2.api.BaseClass;
import levelup2.api.BaseSkill;
import levelup2.api.ICharacterClass;
import levelup2.api.IPlayerSkill;
import levelup2.config.LevelUpConfig;
import levelup2.items.ItemRespecBook;
import levelup2.player.IPlayerClass;
import levelup2.skills.SkillRegistry;
import levelup2.util.ClassProperties;
import levelup2.util.SkillProperties;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;

public class SkillPacketHandler {
    public static final String[] CHANNELS = new String[]{"levelupinit", "levelupclasses", "levelupskills", "levelupcfg", "levelupproperties", "leveluprefresh", "levelupclass", "leveluptoggle", "levelchange", "levelreturn"};
    public static FMLEventChannel initChannel;
    public static FMLEventChannel classChannel;
    public static FMLEventChannel skillChannel;
    public static FMLEventChannel configChannel;
    public static FMLEventChannel propertyChannel;
    public static FMLEventChannel refreshChannel;
    public static FMLEventChannel classPropChannel;
    public static FMLEventChannel toggleChannel;
    public static FMLEventChannel levelChannel;
    public static FMLEventChannel levelReturn;

    public static void init() {
        SkillPacketHandler handler = new SkillPacketHandler();
        initChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELS[0]);
        initChannel.register((Object)handler);
        classChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELS[1]);
        classChannel.register((Object)handler);
        skillChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELS[2]);
        skillChannel.register((Object)handler);
        configChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELS[3]);
        configChannel.register((Object)handler);
        propertyChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELS[4]);
        propertyChannel.register((Object)handler);
        refreshChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELS[5]);
        refreshChannel.register((Object)handler);
        classPropChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELS[6]);
        classPropChannel.register((Object)handler);
        toggleChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELS[7]);
        toggleChannel.register((Object)handler);
        levelChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELS[8]);
        levelChannel.register((Object)handler);
        levelReturn = NetworkRegistry.INSTANCE.newEventDrivenChannel(CHANNELS[9]);
        levelReturn.register((Object)handler);
        MinecraftForge.EVENT_BUS.register((Object)handler);
    }

    @SubscribeEvent
    public void onServerPacket(FMLNetworkEvent.ServerCustomPacketEvent evt) {
        ByteBuf in = evt.getPacket().payload();
        EntityPlayerMP player = ((NetHandlerPlayServer)evt.getHandler()).field_147369_b;
        if (evt.getPacket().channel().equals(CHANNELS[1])) {
            this.addTask(evt.getHandler(), () -> this.handleClassChange(in, player));
        } else if (evt.getPacket().channel().equals(CHANNELS[2])) {
            this.addTask(evt.getHandler(), () -> this.handlePacket(in, (EntityPlayer)player));
        } else if (evt.getPacket().channel().equals(CHANNELS[7])) {
            this.addTask(evt.getHandler(), () -> this.toggleActive(player));
        } else if (evt.getPacket().channel().equals(CHANNELS[8])) {
            this.addTask(evt.getHandler(), () -> this.addSkillLevel(in, player));
        }
    }

    @SubscribeEvent
    public void onClientPacket(FMLNetworkEvent.ClientCustomPacketEvent evt) {
        ByteBuf in = evt.getPacket().payload();
        if (evt.getPacket().channel().equals(CHANNELS[0])) {
            this.addTask(evt.getHandler(), () -> this.handleSkillsPacket(in, LevelUp2.proxy.getPlayer()));
        } else if (evt.getPacket().channel().equals(CHANNELS[3])) {
            this.addTask(evt.getHandler(), () -> this.handleConfig(in));
        } else if (evt.getPacket().channel().equals(CHANNELS[4])) {
            this.addTask(evt.getHandler(), () -> this.handleProperties(in));
        } else if (evt.getPacket().channel().equals(CHANNELS[5])) {
            this.addTask(evt.getHandler(), () -> this.refreshValues());
        } else if (evt.getPacket().channel().equals(CHANNELS[6])) {
            this.addTask(evt.getHandler(), () -> this.handleClassProps(in));
        } else if (evt.getPacket().channel().equals(CHANNELS[9])) {
            this.addTask(evt.getHandler(), () -> this.handleLevelPacket(in, LevelUp2.proxy.getPlayer()));
        }
    }

    private void addTask(INetHandler netHandler, Runnable runnable) {
        FMLCommonHandler.instance().getWorldThread(netHandler).func_152344_a(runnable);
    }

    private void addSkillLevel(ByteBuf buf, EntityPlayerMP player) {
        int level = buf.readInt();
        if (level == -1) {
            if (SkillRegistry.getPlayer((EntityPlayer)player).addLevelFromExperience((EntityPlayer)player)) {
                this.sendReturnPacket(player);
            }
        } else {
            SkillRegistry.getPlayer((EntityPlayer)player).changeLevelBank(level);
            this.sendReturnPacket(player);
        }
    }

    private void sendReturnPacket(EntityPlayerMP player) {
        levelReturn.sendTo(this.getLevelPacket(player), player);
    }

    private FMLProxyPacket getLevelPacket(EntityPlayerMP player) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeInt(SkillRegistry.getPlayer((EntityPlayer)player).getLevelBank());
        FMLProxyPacket pkt = new FMLProxyPacket(new PacketBuffer(buf), CHANNELS[9]);
        pkt.setTarget(Side.CLIENT);
        return pkt;
    }

    private void handleLevelPacket(ByteBuf buf, EntityPlayer player) {
        SkillRegistry.getPlayer(player).changeLevelBank(buf.readInt());
    }

    public static FMLProxyPacket getLevelUpPacket(int level) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeInt(level);
        FMLProxyPacket pkt = new FMLProxyPacket(new PacketBuffer(buf), CHANNELS[8]);
        pkt.setTarget(Side.SERVER);
        return pkt;
    }

    public static FMLProxyPacket getActivationPacket() {
        ByteBuf buf = Unpooled.buffer();
        buf.writeBoolean(false);
        FMLProxyPacket pkt = new FMLProxyPacket(new PacketBuffer(buf), CHANNELS[7]);
        pkt.setTarget(Side.SERVER);
        return pkt;
    }

    private void toggleActive(EntityPlayerMP player) {
        SkillRegistry.getPlayer((EntityPlayer)player).toggleActive();
        String active = SkillRegistry.getPlayer((EntityPlayer)player).isActive() ? "levelup.skill.active" : "levelup.skill.inactive";
        player.func_146105_b((ITextComponent)new TextComponentTranslation(active, new Object[0]), true);
    }

    public static FMLProxyPacket getClassChangePacket(ResourceLocation name, boolean reclass) {
        ByteBuf buf = Unpooled.buffer();
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)name.toString());
        buf.writeBoolean(reclass);
        FMLProxyPacket pkt = new FMLProxyPacket(new PacketBuffer(buf), CHANNELS[1]);
        pkt.setTarget(Side.SERVER);
        return pkt;
    }

    private void handleClassChange(ByteBuf buf, EntityPlayerMP player) {
        ResourceLocation cl = new ResourceLocation(ByteBufUtils.readUTF8String((ByteBuf)buf));
        boolean reclass = buf.readBoolean();
        if (SkillRegistry.getPlayer((EntityPlayer)player).getPlayerClass() == null || reclass && !SkillRegistry.getPlayer((EntityPlayer)player).getPlayerClass().equals((Object)cl)) {
            SkillRegistry.getPlayer((EntityPlayer)player).setPlayerClass(cl);
            SkillRegistry.loadPlayer((EntityPlayer)player);
            if (reclass && !player.field_71075_bZ.field_75098_d) {
                if (((ItemStack)player.field_71071_by.field_70462_a.get(player.field_71071_by.field_70461_c)).func_77973_b() instanceof ItemRespecBook) {
                    player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)ItemStack.field_190927_a);
                } else {
                    for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                        if (!(((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77973_b() instanceof ItemRespecBook)) continue;
                        player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
                        break;
                    }
                }
            }
        }
    }

    private void handlePacket(ByteBuf buf, EntityPlayer player) {
        this.handleSkillsPacket(buf, player);
        SkillRegistry.loadPlayer(player);
    }

    public static FMLProxyPacket getSkillPacket(Side side, int channel, Map<ResourceLocation, Integer> map, int levels, ResourceLocation cl) {
        ByteBuf buf = Unpooled.buffer();
        buf.writeInt(levels);
        NBTTagCompound tag = SkillPacketHandler.writeSkillsAsNBT(map);
        if (cl != null && channel == 0) {
            tag.func_74778_a("class", cl.toString());
        }
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
        FMLProxyPacket pkt = new FMLProxyPacket(new PacketBuffer(buf), CHANNELS[channel]);
        pkt.setTarget(side);
        return pkt;
    }

    public static FMLProxyPacket getConfigPacket(NBTTagCompound dat) {
        ByteBuf buf = Unpooled.buffer();
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)dat);
        FMLProxyPacket pkt = new FMLProxyPacket(new PacketBuffer(buf), CHANNELS[3]);
        pkt.setTarget(Side.CLIENT);
        return pkt;
    }

    private void handleConfig(ByteBuf buf) {
        LevelUpConfig.useServerProperties(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public static FMLProxyPacket getPropertyPackets(IPlayerSkill skill) {
        SkillProperties prop = SkillRegistry.getProperty(skill);
        ByteBuf buf = Unpooled.buffer();
        if (prop != null) {
            prop.writeToBytes(buf);
        }
        FMLProxyPacket pkt = new FMLProxyPacket(new PacketBuffer(buf), CHANNELS[4]);
        pkt.setTarget(Side.CLIENT);
        return pkt;
    }

    public static FMLProxyPacket getClassPackets(ICharacterClass cl) {
        ClassProperties prop = SkillRegistry.getProperty(cl);
        ByteBuf buf = Unpooled.buffer();
        if (prop != null) {
            prop.writeToBytes(buf);
        }
        FMLProxyPacket pkt = new FMLProxyPacket(new PacketBuffer(buf), CHANNELS[6]);
        pkt.setTarget(Side.CLIENT);
        return pkt;
    }

    private void handleProperties(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        SkillProperties prop = SkillProperties.fromNBT(tag);
        SkillRegistry.addSkill(BaseSkill.fromProps(prop));
    }

    private void handleClassProps(ByteBuf buf) {
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        ClassProperties prop = ClassProperties.fromNBT(tag);
        SkillRegistry.addClass(BaseClass.fromProperties(prop));
    }

    public static FMLProxyPacket getRefreshPacket() {
        ByteBuf buf = Unpooled.buffer();
        buf.writeBoolean(true);
        FMLProxyPacket pkt = new FMLProxyPacket(new PacketBuffer(buf), CHANNELS[5]);
        pkt.setTarget(Side.CLIENT);
        return pkt;
    }

    private void refreshValues() {
        SkillRegistry.calculateHighLow();
    }

    private void handleSkillsPacket(ByteBuf buf, EntityPlayer player) {
        IPlayerClass p = SkillRegistry.getPlayer(player);
        p.changeLevelBank(buf.readInt());
        Map<ResourceLocation, Integer> skills = this.readSkillsFromNBT(player, ByteBufUtils.readTag((ByteBuf)buf));
        if (!skills.isEmpty()) {
            for (ResourceLocation name : skills.keySet()) {
                p.setSkillLevel(name, skills.get(name));
            }
        }
    }

    private static NBTTagCompound writeSkillsAsNBT(Map<ResourceLocation, Integer> map) {
        NBTTagCompound tag = new NBTTagCompound();
        if (!map.isEmpty()) {
            for (ResourceLocation name : map.keySet()) {
                tag.func_74768_a(name.toString(), map.get(name).intValue());
            }
        }
        return tag;
    }

    private Map<ResourceLocation, Integer> readSkillsFromNBT(EntityPlayer player, NBTTagCompound tag) {
        HashMap skills = Maps.newHashMap();
        IPlayerClass cl = SkillRegistry.getPlayer(player);
        for (ResourceLocation name : cl.getSkills().keySet()) {
            if (!tag.func_74764_b(name.toString())) continue;
            skills.put(name, tag.func_74762_e(name.toString()));
        }
        if (tag.func_74764_b("class")) {
            SkillRegistry.getPlayer(player).setPlayerClass(new ResourceLocation(tag.func_74779_i("class")));
        }
        return skills;
    }
}

