/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.refinedstoragerequestify.proxy.block.network;

import com.buuz135.refinedstoragerequestify.proxy.block.tile.TileRequester;
import com.buuz135.refinedstoragerequestify.proxy.config.RequestifyConfig;
import com.raoulvdberge.refinedstorage.api.autocrafting.task.ICraftingTask;
import com.raoulvdberge.refinedstorage.api.network.node.INetworkNode;
import com.raoulvdberge.refinedstorage.api.util.Action;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.inventory.fluid.FluidInventory;
import com.raoulvdberge.refinedstorage.inventory.item.ItemHandlerBase;
import com.raoulvdberge.refinedstorage.inventory.listener.ListenerNetworkNode;
import com.raoulvdberge.refinedstorage.tile.config.IType;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;

public class NetworkNodeRequester
extends NetworkNode
implements IType {
    public static final String ID = "requester";
    private static final String NBT_TYPE = "Type";
    private static final String NBT_FLUID_FILTERS = "FluidFilter";
    private static final String NBT_AMOUNT = "Amount";
    private static final String NBT_MISSING = "MissingItems";
    private ItemHandlerBase itemFilter = new ItemHandlerBase(1, (Consumer)new ListenerNetworkNode((INetworkNode)this), new Predicate[0]);
    private FluidInventory fluidFilter = new FluidInventory(1, (Consumer)new ListenerNetworkNode((INetworkNode)this));
    private int type = 0;
    private int amount = 0;
    private boolean isMissingItems = false;
    private ICraftingTask craftingTask = null;

    public NetworkNodeRequester(World world, BlockPos pos) {
        super(world, pos);
    }

    public void update() {
        super.update();
        if (this.network == null) {
            return;
        }
        if (this.canUpdate() && this.ticks % 10 == 0 && (this.craftingTask == null || !this.network.getCraftingManager().getTasks().contains(this.craftingTask))) {
            int count;
            ItemStack current;
            ItemStack filter;
            if (this.type == 0 && !(filter = this.itemFilter.getStackInSlot(0)).func_190926_b()) {
                current = this.network.extractItem(filter, this.amount, Action.SIMULATE);
                if (current == null || current.func_190926_b() || current.func_190916_E() < this.amount) {
                    int n = count = current == null || current.func_190926_b() ? this.amount : this.amount - current.func_190916_E();
                    if (count > 0) {
                        this.craftingTask = this.network.getCraftingManager().request((Object)this, filter, Math.min(RequestifyConfig.MAX_CRAFT_AMOUNT, count));
                        this.isMissingItems = true;
                    }
                } else {
                    this.isMissingItems = false;
                }
            }
            if (this.type == 1 && (filter = this.fluidFilter.getFluid(0)) != null) {
                current = this.network.extractFluid((FluidStack)filter, this.amount, Action.SIMULATE);
                if (current == null || current.amount < this.amount) {
                    int n = count = current == null ? this.amount : this.amount - current.amount;
                    if (count > 0) {
                        this.craftingTask = this.network.getCraftingManager().request((Object)this, (FluidStack)filter, count);
                        this.isMissingItems = true;
                    }
                } else {
                    this.isMissingItems = false;
                }
            }
        }
    }

    public int getEnergyUsage() {
        return 10;
    }

    public String getId() {
        return ID;
    }

    public int getType() {
        return this.world.field_72995_K ? (Integer)TileRequester.TYPE.getValue() : this.type;
    }

    public void setType(int type) {
        this.type = type;
        this.markDirty();
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.markDirty();
    }

    public boolean isMissingItems() {
        return this.isMissingItems && this.craftingTask == null;
    }

    public IItemHandlerModifiable getItemFilters() {
        return this.itemFilter;
    }

    public FluidInventory getFluidFilters() {
        return this.fluidFilter;
    }

    public void read(NBTTagCompound tag) {
        super.read(tag);
        StackUtils.readItems((IItemHandlerModifiable)this.itemFilter, (int)0, (NBTTagCompound)tag);
        if (tag.func_74764_b(NBT_AMOUNT)) {
            this.amount = tag.func_74762_e(NBT_AMOUNT);
        }
        if (tag.func_74764_b(NBT_MISSING)) {
            this.isMissingItems = tag.func_74767_n(NBT_MISSING);
        }
    }

    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.itemFilter, (int)0, (NBTTagCompound)tag);
        tag.func_74768_a(NBT_AMOUNT, this.amount);
        tag.func_74757_a(NBT_MISSING, this.isMissingItems);
        return tag;
    }

    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_TYPE, this.type);
        StackUtils.writeItems((IItemHandler)this.itemFilter, (int)0, (NBTTagCompound)tag);
        tag.func_74782_a(NBT_FLUID_FILTERS, (NBTBase)this.fluidFilter.writeToNbt());
        tag.func_74768_a(NBT_AMOUNT, this.amount);
        tag.func_74757_a(NBT_MISSING, this.isMissingItems);
        return tag;
    }

    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_TYPE)) {
            this.type = tag.func_74762_e(NBT_TYPE);
        }
        StackUtils.readItems((IItemHandlerModifiable)this.itemFilter, (int)0, (NBTTagCompound)tag);
        if (tag.func_74764_b(NBT_FLUID_FILTERS)) {
            this.fluidFilter.readFromNbt(tag.func_74775_l(NBT_FLUID_FILTERS));
        }
        if (tag.func_74764_b(NBT_AMOUNT)) {
            this.amount = tag.func_74762_e(NBT_AMOUNT);
        }
        if (tag.func_74764_b(NBT_MISSING)) {
            this.isMissingItems = tag.func_74767_n(NBT_MISSING);
        }
    }
}

