/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.pickupnotifier.asm.hook;

import com.fuzs.pickupnotifier.client.util.DisplayEntry;
import com.fuzs.pickupnotifier.client.util.ExperienceDisplayEntry;
import com.fuzs.pickupnotifier.client.util.ItemDisplayEntry;
import com.fuzs.pickupnotifier.config.ConfigBuildHandler;
import com.fuzs.pickupnotifier.config.EntryCollectionBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.projectile.EntitySpectralArrow;
import net.minecraft.entity.projectile.EntityTippedArrow;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class AddEntriesHook {
    public static final List<DisplayEntry> PICK_UPS = Lists.newArrayList();
    private static final Set<Item> BLACKLIST = Sets.newHashSet();

    public static void onEntityPickup(Entity entity, Entity livingentity) {
        if (livingentity == Minecraft.func_71410_x().field_71439_g) {
            if (entity instanceof EntityItem) {
                AddEntriesHook.addItemEntry(((EntityItem)entity).func_92059_d());
            } else if (entity instanceof EntityTippedArrow) {
                AddEntriesHook.addItemEntry(new ItemStack(Items.field_151032_g));
            } else if (entity instanceof EntitySpectralArrow) {
                AddEntriesHook.addItemEntry(new ItemStack(Items.field_185166_h));
            } else if (entity instanceof EntityXPOrb) {
                AddEntriesHook.addExperienceEntry((EntityXPOrb)entity);
            }
        }
    }

    private static void addItemEntry(ItemStack stack) {
        if (!stack.func_190926_b() && stack.func_190916_E() > 0 && !BLACKLIST.contains(stack.func_77973_b())) {
            stack = stack.func_77946_l();
            AddEntriesHook.addEntry(new ItemDisplayEntry(stack));
        }
    }

    private static void addExperienceEntry(EntityXPOrb orb) {
        if (ConfigBuildHandler.generalConfig.displayExperience && orb.field_70530_e > 0) {
            AddEntriesHook.addEntry(new ExperienceDisplayEntry(orb));
        }
    }

    private static void addEntry(DisplayEntry entry) {
        Optional duplicateOptional;
        float scale = (float)ConfigBuildHandler.displayConfig.scale / 6.0f;
        int scaledHeight = (int)((float)new ScaledResolution(Minecraft.func_71410_x()).func_78328_b() / scale);
        int length = (int)((double)scaledHeight * ConfigBuildHandler.displayConfig.height / 18.0) - 1;
        Optional<Object> optional = duplicateOptional = ConfigBuildHandler.generalConfig.combineEntries ? PICK_UPS.stream().filter(it -> it.canMerge(entry)).findFirst() : Optional.empty();
        if (duplicateOptional.isPresent()) {
            DisplayEntry duplicate = (DisplayEntry)duplicateOptional.get();
            duplicate.merge(entry);
            PICK_UPS.remove(duplicate);
            PICK_UPS.add(duplicate);
        } else {
            if (PICK_UPS.size() >= length) {
                PICK_UPS.remove(0);
            }
            PICK_UPS.add(entry);
        }
    }

    public static void sync() {
        EntryCollectionBuilder builder = new EntryCollectionBuilder(ForgeRegistries.ITEMS);
        BLACKLIST.clear();
        ArrayList blacklist = Lists.newArrayList((Object[])ConfigBuildHandler.generalConfig.blacklist);
        BLACKLIST.addAll(builder.buildEntrySet(blacklist));
    }
}

