/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.pickupnotifier.client.util;

import com.fuzs.pickupnotifier.config.ConfigBuildHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.EnumRarity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.mutable.MutableFloat;

public abstract class DisplayEntry {
    public static final int HEIGHT = 18;
    private static final int MARGIN = 4;
    private final EnumRarity rarity;
    protected int count;
    private final MutableFloat life;

    protected DisplayEntry(int count, EnumRarity rarity) {
        this.count = Math.min(count, ConfigBuildHandler.generalConfig.maxCount);
        this.rarity = rarity;
        this.life = new MutableFloat((float)ConfigBuildHandler.generalConfig.displayTime);
    }

    public boolean isDead() {
        return this.life.compareTo(new MutableFloat(0.0f)) < 1;
    }

    public final void tick(float f) {
        this.life.subtract(f);
    }

    public final int getCount() {
        return this.count;
    }

    public boolean canMerge(DisplayEntry entry) {
        return this.rarity == entry.rarity;
    }

    public final void addCount(int i) {
        this.count = Math.min(this.count + i, ConfigBuildHandler.generalConfig.maxCount);
    }

    protected abstract ITextComponent getName();

    private ITextComponent getNameComponent() {
        ITextComponent name = this.getName().func_150259_f();
        if (this.count <= 0) {
            return name;
        }
        if (ConfigBuildHandler.displayConfig.position.isMirrored()) {
            return new TextComponentString(this.count + "x ").func_150257_a(name);
        }
        return name.func_150258_a(" x" + this.count);
    }

    public final float getRelativeLife() {
        return 1.0f - Math.min(1.0f, this.getLife() / (float)Math.min(ConfigBuildHandler.generalConfig.moveTime, ConfigBuildHandler.generalConfig.displayTime));
    }

    protected final float getLife() {
        return Math.max(0.0f, this.life.floatValue());
    }

    public final void resetLife() {
        this.life.setValue((float)ConfigBuildHandler.generalConfig.displayTime);
    }

    public void merge(DisplayEntry entry) {
        this.addCount(entry.getCount());
        this.resetLife();
    }

    private Style getStyle() {
        if (!ConfigBuildHandler.generalConfig.ignoreRarity && this.rarity != EnumRarity.COMMON) {
            return new Style().func_150238_a(this.rarity.field_77937_e);
        }
        return new Style().func_150238_a(ConfigBuildHandler.generalConfig.color.getChatColor());
    }

    private String getNameString() {
        return this.getNameComponent().func_150255_a(this.getStyle()).func_150254_d();
    }

    private int getTextWidth(Minecraft mc) {
        String s = this.getNameComponent().func_150260_c();
        return mc.field_71466_p.func_78256_a(TextFormatting.func_110646_a((String)s));
    }

    public int getTotalWidth(Minecraft mc) {
        int length = this.getTextWidth(mc);
        return ConfigBuildHandler.generalConfig.showSprite ? length + 4 + 16 : length;
    }

    public final void render(Minecraft mc, int posX, int posY, float alpha) {
        int k;
        boolean mirrored = ConfigBuildHandler.displayConfig.position.isMirrored();
        boolean sprite = ConfigBuildHandler.generalConfig.showSprite;
        int i = mirrored || !sprite ? posX : posX + 16 + 4;
        int textWidth = this.getTextWidth(mc);
        int n = k = ConfigBuildHandler.generalConfig.fadeAway ? 255 - (int)(255.0f * alpha) : 255;
        if (k >= 5) {
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            mc.field_71466_p.func_175063_a(this.getNameString(), (float)i, (float)(posY + 3), 0xFFFFFF + (k << 24));
            GlStateManager.func_179084_k();
            if (sprite) {
                this.renderSprite(mc, mirrored ? posX + textWidth + 4 : posX, posY);
            }
        }
    }

    protected abstract void renderSprite(Minecraft var1, int var2, int var3);

    public abstract DisplayEntry copy();
}

