/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.pickupnotifier.config;

import com.fuzs.pickupnotifier.client.util.PositionPreset;
import com.fuzs.pickupnotifier.client.util.TextColor;
import net.minecraftforge.common.config.Config;

@Config(modid="pickupnotifier")
public class ConfigBuildHandler {
    @Config.Name(value="general")
    public static GeneralConfig generalConfig = new GeneralConfig();
    @Config.Name(value="display")
    public static DisplayConfig displayConfig = new DisplayConfig();

    public static class DisplayConfig {
        @Config.Name(value="Screen Corner")
        @Config.Comment(value={"Screen corner for entry list to be drawn in."})
        public PositionPreset position = PositionPreset.BOTTOM_RIGHT;
        @Config.Name(value="X-Offset")
        @Config.Comment(value={"Offset on x-axis from screen border."})
        @Config.RangeInt(min=0)
        public int xOffset = 8;
        @Config.Name(value="Y-Offset")
        @Config.Comment(value={"Offset on y-axis from screen border."})
        @Config.RangeInt(min=0)
        public int yOffset = 4;
        @Config.Name(value="Maximum Height")
        @Config.Comment(value={"Percentage of relative screen height entries are allowed to fill at max."})
        @Config.RangeDouble(min=0.0, max=1.0)
        public double height = 0.5;
        @Config.Name(value="Custom Scale")
        @Config.Comment(value={"Scale of entries. A lower scale will make room for more rows to show. Works in tandem with \"GUI Scale\" option in \"Video Settings\"."})
        @Config.RangeInt(min=1, max=24)
        public int scale = 4;
    }

    public static class GeneralConfig {
        @Config.Name(value="Blacklist")
        @Config.Comment(value={"Disable specific items or content from whole mods from showing.", "Format for every entry is \"<namespace>:<path>\". Path may use single asterisk as wildcard parameter."})
        public String[] blacklist = new String[0];
        @Config.Name(value="Draw Sprites")
        @Config.Comment(value={"Show a small sprite next to the name of each entry showing its contents."})
        public boolean showSprite = true;
        @Config.Name(value="Text Color")
        @Config.Comment(value={"Color of the entry name text."})
        public TextColor color = TextColor.WHITE;
        @Config.Name(value="Ignore Rarity")
        @Config.Comment(value={"Ignore rarity of items and always use color specified in \"Text Color\" instead."})
        public boolean ignoreRarity = false;
        @Config.Name(value="Combine Entries")
        @Config.Comment(value={"Combine entries of the same type instead of showing each one individually."})
        public boolean combineEntries = true;
        @Config.Name(value="Display Time")
        @Config.Comment(value={"Amount of ticks each entry will be shown for. Set to 0 to only remove entries when space for new ones is needed."})
        @Config.RangeInt(min=0)
        public int displayTime = 80;
        @Config.Name(value="Move Out Of Screen")
        @Config.Comment(value={"Make outdated entries slowly move out of the screen instead of disappearing in place."})
        public boolean move = true;
        @Config.Name(value="Move Time")
        @Config.Comment(value={"Amount of ticks it takes for an entry to move out of the screen. Value cannot be larger than \"Display Time\"."})
        @Config.RangeInt(min=0)
        public int moveTime = 20;
        @Config.Name(value="Fade Away")
        @Config.Comment(value={"Make outdated entry names slowly fade away instead of simply vanishing."})
        public boolean fadeAway = true;
        @Config.Name(value="Maximum Amount")
        @Config.Comment(value={"Maximum count number displayed. Setting this to 0 will prevent the count from being displayed at all."})
        @Config.RangeInt(min=0)
        public int maxCount = 9999;
        @Config.Name(value="Display Experience")
        @Config.Comment(value={"Include experience orbs the player has collected as part of the list of entries."})
        public boolean displayExperience = true;
    }
}

