/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.pickupnotifier.config;

import com.fuzs.pickupnotifier.config.StringListParser;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EntryCollectionBuilder<T extends IForgeRegistryEntry<T>>
extends StringListParser<T> {
    public EntryCollectionBuilder(IForgeRegistry<T> registry) {
        super(registry);
    }

    public Set<T> buildEntrySet(List<String> locations) {
        return this.buildEntrySetWithCondition(locations, flag -> true, "");
    }

    public Map<T, Double> buildEntryMap(List<String> locations) {
        return this.buildEntryMapWithCondition(locations, (entry, value) -> true, "");
    }

    public Set<T> buildEntrySetWithCondition(List<String> locations, Predicate<T> condition, String message) {
        HashSet set = Sets.newHashSet();
        for (String source : locations) {
            this.getEntryFromRegistry(source.trim()).forEach(entry -> {
                if (condition.test(entry)) {
                    if (this.checkOverwrite(set.contains(entry), source)) {
                        set.add(entry);
                    }
                } else {
                    ENTRY_LOGGER.accept(source, message);
                }
            });
        }
        return set;
    }

    public Map<T, Double> buildEntryMapWithCondition(List<String> locations, BiPredicate<T, Double> condition, String message) {
        HashMap map = Maps.newHashMap();
        for (String source : locations) {
            String[] s = (String[])Arrays.stream(source.split(",")).map(String::trim).toArray(String[]::new);
            if (s.length == 2) {
                List entries = this.getEntryFromRegistry(s[0]);
                if (entries.isEmpty()) continue;
                Optional<Object> size = Optional.empty();
                try {
                    size = Optional.of(Double.parseDouble(s[1]));
                }
                catch (NumberFormatException ignored) {
                    ENTRY_LOGGER.accept(source, "Invalid number format");
                }
                size.ifPresent(value -> entries.forEach(entry -> {
                    if (condition.test((T)entry, (Double)value)) {
                        if (this.checkOverwrite(map.containsKey(entry), entry.toString())) {
                            map.put(entry, value);
                        }
                    } else {
                        ENTRY_LOGGER.accept(source, message);
                    }
                }));
                continue;
            }
            ENTRY_LOGGER.accept(source, "Insufficient number of arguments");
        }
        return map;
    }
}

