/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary;

import java.io.InputStream;
import java.io.OutputStream;

public class CircularStream
extends OutputStream {
    private byte[] buffer;
    private int dataStart = 0;
    private int dataEnd = 0;
    private boolean isEmpty = true;
    private int maxBufferSize;
    private boolean closed = false;
    private CircularStreamInput in = new CircularStreamInput();

    public CircularStream(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
        this.buffer = new byte[maxBufferSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) {
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            while (this.getBufferSize() >= this.maxBufferSize && !this.closed) {
                try {
                    this.buffer.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.closed) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
            if (this.dataEnd == this.buffer.length) {
                this.dataEnd = 0;
            }
            this.buffer[this.dataEnd] = (byte)b;
            ++this.dataEnd;
            this.isEmpty = false;
            this.buffer.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private int getBufferSize() {
        if (this.dataEnd == this.dataStart) {
            return this.isEmpty ? 0 : this.maxBufferSize;
        }
        if (this.dataEnd > this.dataStart) {
            return this.dataEnd - this.dataStart;
        }
        return this.dataEnd - this.dataStart + this.maxBufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int offset, int length) {
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            while (length > 0 && !this.closed) {
                while (this.getBufferSize() >= this.maxBufferSize && !this.closed) {
                    try {
                        this.buffer.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.closed) {
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
                if (this.dataEnd == this.buffer.length) {
                    this.dataEnd = 0;
                }
                int canWrite = Math.min(this.maxBufferSize - this.dataEnd, this.maxBufferSize - this.getBufferSize());
                int toWrite = Math.min(canWrite, length);
                System.arraycopy(b, offset, this.buffer, this.dataEnd, toWrite);
                this.dataEnd += toWrite;
                offset += toWrite;
                length -= toWrite;
                this.isEmpty = false;
                this.buffer.notifyAll();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    public CircularStreamInput getInput() {
        return this.in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.closed = true;
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            this.buffer.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public class CircularStreamInput
    extends InputStream {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() {
            byte[] byArray = CircularStream.this.buffer;
            synchronized (byArray) {
                while (CircularStream.this.getBufferSize() < 1 && !CircularStream.this.closed) {
                    try {
                        CircularStream.this.buffer.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (CircularStream.this.closed && CircularStream.this.getBufferSize() < 1) {
                    return -1;
                }
                if (CircularStream.this.dataStart == CircularStream.this.buffer.length) {
                    CircularStream.this.dataStart = 0;
                }
                byte data = CircularStream.this.buffer[CircularStream.this.dataStart];
                CircularStream.this.dataStart++;
                if (CircularStream.this.dataStart == CircularStream.this.dataEnd) {
                    CircularStream.this.isEmpty = true;
                }
                CircularStream.this.buffer.notifyAll();
                return (data + 256) % 256;
            }
        }

        @Override
        public int available() {
            return CircularStream.this.getBufferSize();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] data, int offset, int length) {
            byte[] byArray = CircularStream.this.buffer;
            synchronized (byArray) {
                int read = 0;
                while (read < 1 || length > 0 && CircularStream.this.getBufferSize() > 0) {
                    while (CircularStream.this.getBufferSize() < 1 && !CircularStream.this.closed) {
                        try {
                            CircularStream.this.buffer.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (CircularStream.this.closed && CircularStream.this.getBufferSize() < 1) {
                        return read > 0 ? read : -1;
                    }
                    if (CircularStream.this.dataStart == CircularStream.this.buffer.length) {
                        CircularStream.this.dataStart = 0;
                    }
                    int canRead = Math.min(CircularStream.this.maxBufferSize - CircularStream.this.dataStart, CircularStream.this.getBufferSize());
                    int toRead = Math.min(canRead, length);
                    System.arraycopy(CircularStream.this.buffer, CircularStream.this.dataStart, data, offset, toRead);
                    CircularStream.this.dataStart = CircularStream.this.dataStart + toRead;
                    offset += toRead;
                    length -= toRead;
                    read += toRead;
                    if (CircularStream.this.dataStart == CircularStream.this.dataEnd) {
                        CircularStream.this.isEmpty = true;
                    }
                    CircularStream.this.buffer.notifyAll();
                }
                return read;
            }
        }

        @Override
        public void close() {
            CircularStream.this.close();
        }
    }
}

