/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Queue<T>
implements Iterable<T> {
    protected QueueEntry head;
    protected QueueEntry tail;
    protected int size;

    public synchronized void enqueue(T obj) {
        QueueEntry t = new QueueEntry(obj);
        if (this.head == null || this.tail == null) {
            this.head = t;
            this.tail = t;
            this.size = 1;
        } else {
            this.tail.next = t;
            this.tail = t;
            ++this.size;
        }
    }

    public synchronized T dequeue() {
        if (this.head == null) {
            this.size = 0;
            return null;
        }
        Object obj = this.head.obj;
        this.head = this.head.next;
        --this.size;
        return obj;
    }

    public synchronized T peek() {
        if (this.head == null) {
            return null;
        }
        return this.head.obj;
    }

    public synchronized void clear() {
        this.head = null;
        this.tail = null;
        this.size = 0;
    }

    public int size() {
        return this.recountSize();
    }

    public boolean isEmpty() {
        return this.head == null;
    }

    public ArrayList<T> toList() {
        ArrayList t = new ArrayList(this.size);
        QueueEntry h = this.head;
        while (h != null) {
            t.add(h.obj);
            h = h.next;
        }
        return t;
    }

    public Queue<T> copy() {
        Queue q = new Queue();
        QueueEntry h = this.head;
        while (h != null) {
            q.enqueue(h.obj);
            h = h.next;
        }
        return q;
    }

    public Queue<T> shallow() {
        Queue<T> q = new Queue<T>();
        q.head = this.head;
        q.tail = this.tail;
        q.size = this.size;
        return q;
    }

    public int recountSize() {
        QueueEntry h = this.head;
        this.size = 0;
        while (h != null) {
            ++this.size;
            h = h.next;
        }
        return this.size;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            QueueEntry last = null;
            QueueEntry previous = null;
            boolean removed = true;

            @Override
            public boolean hasNext() {
                return this.last == null && Queue.this.head != null || this.last != null && this.last.next != null;
            }

            @Override
            public T next() {
                Object obj;
                Object t = obj = this.last == null ? Queue.this.head.obj : this.last.next.obj;
                if (!this.removed) {
                    this.previous = this.last;
                }
                this.removed = false;
                this.last = this.last == null ? Queue.this.head : this.last.next;
                return obj;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                if (this.removed) {
                    return;
                }
                this.removed = true;
                Queue queue = Queue.this;
                synchronized (queue) {
                    if (this.last == Queue.this.head) {
                        Queue.this.head = this.last.next;
                    } else if (this.previous != null) {
                        this.previous.next = this.last.next;
                        if (this.previous.next == null) {
                            Queue.this.tail = this.previous;
                        }
                    }
                    --Queue.this.size;
                }
            }
        };
    }

    @Override
    public Spliterator<T> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 16);
    }

    public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Stream<T> streamContent() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return !Queue.this.isEmpty();
            }

            @Override
            public T next() {
                return Queue.this.dequeue();
            }
        }, 16), false);
    }

    protected class QueueEntry {
        protected T obj;
        protected QueueEntry next;

        protected QueueEntry(T obj) {
            this.obj = obj;
        }
    }
}

