/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary;

import java.util.ArrayList;
import java.util.Iterator;

public class Stack<T>
implements Iterable<T> {
    private StackEntry top;
    private int size;

    public void push(T obj) {
        StackEntry t = new StackEntry(obj);
        if (this.top == null) {
            this.top = t;
            this.size = 1;
        } else {
            t.next = this.top;
            this.top = t;
            ++this.size;
        }
    }

    public T pop() {
        if (this.top == null) {
            this.size = 0;
            return null;
        }
        Object obj = this.top.obj;
        this.top = this.top.next;
        --this.size;
        return obj;
    }

    public T peek() {
        if (this.top == null) {
            return null;
        }
        return this.top.obj;
    }

    public void clear() {
        this.top = null;
        this.size = 0;
    }

    public int size() {
        return this.recountSize();
    }

    public boolean isEmpty() {
        return this.top == null;
    }

    public ArrayList<T> toList() {
        ArrayList<T> t = new ArrayList<T>(this.size);
        for (T i : this) {
            t.add(i);
        }
        return t;
    }

    public Stack<T> copy() {
        StackEntry h2;
        Stack<T> q = new Stack<T>();
        if (this.top == null) {
            return q;
        }
        StackEntry h = this.top.next;
        q.top = h2 = new StackEntry(this.top.obj);
        while (h != null) {
            h2 = h2.next = new StackEntry(h.obj);
            h = h.next;
        }
        return q;
    }

    public int recountSize() {
        StackEntry h = this.top;
        this.size = 0;
        while (h != null) {
            ++this.size;
            h = h.next;
        }
        return this.size;
    }

    public boolean contains(T obj) {
        for (T t : this) {
            if ((t != null || obj != null) && (obj == null || !obj.equals(t))) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            StackEntry next;
            {
                this.next = Stack.this.top;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public T next() {
                Object obj = this.next.obj;
                this.next = this.next.next;
                return obj;
            }
        };
    }

    protected class StackEntry {
        protected T obj;
        protected StackEntry next;

        private StackEntry(T obj) {
            this.obj = obj;
        }
    }
}

