/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.GregorianCalendar;
import java.util.Random;
import org.lwjgl.Version;
import simplelibrary.ErrorList;
import simplelibrary.config.Config;
import simplelibrary.error.ErrorAdapter;
import simplelibrary.error.ErrorCategory;
import simplelibrary.error.ErrorHandler;
import simplelibrary.error.ErrorLevel;
import simplelibrary.game.GameHelper;

public class Sys {
    public static File errorLog;
    public static ArrayList<String> generatedStrings;
    private static ArrayList<String> generatedPasskeys;
    static ErrorHandler handler;
    private static boolean initialized;
    static boolean log;
    private static final Random rand;
    private static File root;
    private static Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private static boolean useLWJGL;
    public static ErrorList suppressedErrors;
    private static ErrorCategory[] suppress;
    private static boolean suppressUncaughtExceptionHandler;

    public static boolean canUseLWJGL() {
        return useLWJGL;
    }

    public static void error(ErrorLevel level, String message, Throwable error, ErrorCategory category) {
        Sys.error(level, message, error, category, log);
    }

    public static void error(ErrorLevel level, String message, Throwable error, ErrorCategory category, boolean log) {
        if (!initialized) {
            throw new RuntimeException(error);
        }
        if (level == null && error != null) {
            level = ErrorLevel.minor;
        } else if (level == null) {
            Sys.error(ErrorLevel.severe, null, new IllegalArgumentException("Error must have a level or an exception!"), ErrorCategory.bug);
            return;
        }
        if (message == null && error == null) {
            Sys.error(ErrorLevel.severe, null, new IllegalArgumentException("A message or exception must be tied to an error!"), ErrorCategory.bug);
            return;
        }
        if (error == null && (level == ErrorLevel.critical || level == ErrorLevel.severe)) {
            error = new UnknownError();
        }
        if (message == null) {
            message = "";
        }
        if (level == null || category == null) {
            String amessage = "";
            if (level == null && category == null) {
                amessage = "Error must be assigned a level and a catagory!";
            } else if (level == null) {
                amessage = "Error must be assigned a level!";
            } else if (category == null) {
                amessage = "Error must be assigned a catagory!";
            }
            Sys.error(ErrorLevel.severe, null, new IllegalArgumentException(amessage), ErrorCategory.bug);
            return;
        }
        for (ErrorCategory c : suppress) {
            if (category != c) continue;
            Sys.suppress(level, message, error, category, log);
            return;
        }
        if (log) {
            Sys.log(message, error);
        }
        level.error(handler, message, error, category);
        if (suppressedErrors.getCount() > 0) {
            suppressedErrors.throwAll();
        }
    }

    public static void suppress(ErrorLevel level, String message, Throwable error, ErrorCategory category) {
        suppressedErrors.add(level, message, error, category);
    }

    public static void suppress(ErrorLevel level, String message, Throwable error, ErrorCategory category, boolean log) {
        suppressedErrors.add(level, message, error, category, log);
    }

    public static void suppressAll(ErrorCategory ... categories) {
        if (categories != null) {
            suppress = categories;
        }
    }

    public static boolean hasSuppressed() {
        return suppressedErrors.getCount() > 0;
    }

    public static String generateRandomString(int characters) {
        String value;
        for (int taken = 0; generatedStrings.contains(value = Sys.genRandString(characters)) && taken < 500000; ++taken) {
        }
        if (generatedStrings.contains(value)) {
            return null;
        }
        generatedStrings.add(value);
        return value;
    }

    public static String generateRandomPasskey(int characters, String allowedChars, Random rand) {
        String value;
        for (int taken = 0; generatedPasskeys.contains(value = Sys.genRandPasskey(characters, allowedChars, rand)) && taken < 500000; ++taken) {
        }
        if (generatedPasskeys.contains(value)) {
            return null;
        }
        generatedPasskeys.add(value);
        return value;
    }

    public static ErrorHandler getErrorHandler() {
        return Sys.checkHandler(handler);
    }

    public static File getRoot() {
        return root;
    }

    public static Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        if (uncaughtExceptionHandler != null) {
            return uncaughtExceptionHandler;
        }
        return Sys.createUncaughtExceptionHandler();
    }

    public static Config init(File root, ErrorHandler handler, String settings) {
        Sys.init(root, handler);
        if (!suppressUncaughtExceptionHandler) {
            Thread.setDefaultUncaughtExceptionHandler(Sys.getUncaughtExceptionHandler());
        }
        Config config = settings == null ? null : Config.loadConfig(settings);
        return config;
    }

    public static void init(File root, ErrorHandler handler) {
        if (root == null) {
            throw new IllegalArgumentException("Root folder cannot be null!");
        }
        Sys.root = root;
        Sys.handler = Sys.checkHandler(handler);
        if (!suppressUncaughtExceptionHandler) {
            Thread.setDefaultUncaughtExceptionHandler(Sys.getUncaughtExceptionHandler());
        }
        initialized = true;
    }

    public static Config initLWJGL(File root, ErrorHandler handler, String settings) {
        Config config = Sys.init(root, handler, settings);
        useLWJGL = true;
        System.out.println("Using LWJGL v" + Version.getVersion());
        return config;
    }

    public static void initLWJGL(File root, ErrorHandler handler) {
        Sys.init(root, handler);
        useLWJGL = true;
    }

    public static Config initLWJGLGame(File root, ErrorHandler handler, String settings, GameHelper helper) {
        if (helper == null) {
            throw new IllegalArgumentException("Game helper cannot be null!");
        }
        Config config = Sys.initLWJGL(root, handler, settings);
        helper.start();
        return config;
    }

    public static Config initLWJGLGameUnlogged(File root, ErrorHandler handler, String settings, GameHelper helper) {
        log = false;
        return Sys.initLWJGLGame(root, handler, settings, helper);
    }

    public static Config initLWJGLUnlogged(File root, ErrorHandler handler, String settings) {
        log = false;
        return Sys.initLWJGL(root, handler, settings);
    }

    public static void initLWJGLUnlogged(File root, ErrorHandler handler) {
        Sys.initLWJGL(root, handler);
        log = false;
    }

    public static Config initUnlogged(File root, ErrorHandler handler, String settings) {
        log = false;
        return Sys.init(root, handler, settings);
    }

    public static void initUnlogged(File root, ErrorHandler handler) {
        Sys.init(root, handler);
        log = false;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static synchronized void log(String message, Throwable error) {
        if (!initialized) {
            return;
        }
        try (PrintWriter out = Sys.getErrorLog();){
            out.println(message);
            if (error != null) {
                StackTraceElement[] stack;
                out.println("error=" + error.getClass().getName());
                out.println("errorMessage=" + error.getMessage());
                for (StackTraceElement stack1 : stack = error.getStackTrace()) {
                    out.println(" at " + stack1.toString());
                }
                int sSize = stack.length;
                while ((error = error.getCause()) != null) {
                    out.println("causedBy=" + error.getClass().getName());
                    out.println("errorMessage=" + error.getMessage());
                    stack = error.getStackTrace();
                    for (int i = 0; i < stack.length - sSize; ++i) {
                        StackTraceElement stack1 = stack[i];
                        out.println("  at " + stack1.toString());
                    }
                    out.println("    ..." + sSize + " more");
                    sSize = stack.length;
                }
            } else {
                out.println("!!No Exception!!");
            }
            out.println("--END EXCEPTION--");
        }
    }

    public static Process restart(String[] vmArgs, String[] applicationArgs, String[] additionalFiles, Class<?> mainClass) throws URISyntaxException, IOException {
        return Sys.restart(vmArgs, applicationArgs, additionalFiles, mainClass, null);
    }

    public static Process restart(String[] vmArgs, String[] applicationArgs, String[] additionalFiles, Class<?> mainClass, File workingDir) throws URISyntaxException, IOException {
        ArrayList<String> params = new ArrayList<String>();
        params.add("java");
        params.addAll(Arrays.asList(vmArgs));
        params.add("-classpath");
        String filepath = mainClass.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        String separator = System.getProperty("path.separator");
        if (additionalFiles != null) {
            for (String str : additionalFiles) {
                filepath = filepath + separator + str;
            }
        }
        params.add(filepath);
        params.add(mainClass.getName());
        params.addAll(Arrays.asList(applicationArgs));
        ProcessBuilder builder = new ProcessBuilder(params);
        return builder.start();
    }

    public static String[] splitString(String string, char c) {
        char[] chars = new char[string.length()];
        string.getChars(0, string.length(), chars, 0);
        ArrayList<String> lst = new ArrayList<String>();
        String current = "";
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == c) {
                lst.add(current);
                current = "";
                continue;
            }
            current = current + chars[i];
        }
        lst.add(current);
        return lst.toArray(new String[lst.size()]);
    }

    public static Process startJava(String[] vmArgs, String[] applicationArgs, File file) throws IOException {
        ArrayList<String> params = new ArrayList<String>();
        params.add("java");
        params.addAll(Arrays.asList(vmArgs));
        params.add("-jar");
        params.add(file.getAbsolutePath());
        params.addAll(Arrays.asList(applicationArgs));
        ProcessBuilder builder = new ProcessBuilder(params);
        return builder.start();
    }

    public static Process startJavaw(String[] vmArgs, String[] applicationArgs, File file) throws IOException {
        ArrayList<String> params = new ArrayList<String>();
        params.add("javaw");
        params.addAll(Arrays.asList(vmArgs));
        params.add("-jar");
        params.add(file.getAbsolutePath());
        params.addAll(Arrays.asList(applicationArgs));
        ProcessBuilder builder = new ProcessBuilder(params);
        return builder.start();
    }

    public static boolean startSingleInstance(String programName) {
        final File singleInstanceFile = new File(System.getenv("APPDATA") + "\\Dolan Programmers\\Single Instance Locks\\" + programName + ".lock");
        if (singleInstanceFile.exists() && !singleInstanceFile.delete()) {
            return false;
        }
        final FileInputStream[] out = new FileInputStream[1];
        Thread unlocker = new Thread(){

            @Override
            public void run() {
                try {
                    out[0].close();
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
                singleInstanceFile.delete();
            }
        };
        singleInstanceFile.getParentFile().mkdirs();
        try {
            singleInstanceFile.createNewFile();
            out[0] = new FileInputStream(singleInstanceFile);
        }
        catch (IOException ex) {
            return false;
        }
        Runtime.getRuntime().addShutdownHook(unlocker);
        return true;
    }

    private static ErrorHandler checkHandler(ErrorHandler handler) {
        if (handler != null) {
            return handler;
        }
        return new ErrorAdapter(){};
    }

    private static Thread.UncaughtExceptionHandler createUncaughtExceptionHandler() {
        uncaughtExceptionHandler = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable error) {
                Sys.threadError(thread, error);
            }
        };
        return uncaughtExceptionHandler;
    }

    private static String genRandString(int characters) {
        char[] chars = new char[characters];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)rand.nextInt(65536);
        }
        return String.valueOf(chars);
    }

    private static String genRandPasskey(int characters, String allowedChars, Random rand) {
        if (rand == null) {
            rand = Sys.rand;
        }
        int strLength = allowedChars.length();
        char[] chars = new char[characters];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = allowedChars.charAt(rand.nextInt(strLength));
        }
        return String.valueOf(chars);
    }

    private static synchronized PrintWriter getErrorLog() {
        GregorianCalendar cal = new GregorianCalendar();
        if (errorLog == null) {
            root.mkdirs();
            errorLog = new File(root, "Error " + cal.getTime().toString().replace(':', '-') + ".log");
            int which = 1;
            while (errorLog.exists()) {
                errorLog = new File(root, "Error " + cal.getTime().toString().replace(':', '-') + " " + which + ".log");
                ++which;
            }
        }
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(errorLog, true));
            out.println("--EXCEPTION OCCURED--");
            out.println(cal.getTime().toString());
            return out;
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static void threadError(Thread thread, Throwable error) {
        if (error != null) {
            Sys.error(null, "Error in thread " + thread.getName() + ":  " + error.getMessage(), error, ErrorCategory.uncaught);
        } else {
            Sys.error(null, "Error in thread " + thread.getName() + "!", error, ErrorCategory.uncaught);
        }
    }

    private Sys() {
    }

    public static void suppressUncaughtExceptionHandler() {
        suppressUncaughtExceptionHandler = true;
    }

    static {
        generatedStrings = new ArrayList();
        generatedPasskeys = new ArrayList();
        log = true;
        rand = new Random(1L);
        suppressedErrors = new ErrorList();
        suppress = new ErrorCategory[0];
    }
}

