/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary;

import java.util.ArrayList;

public class VersionManager {
    public String currentVersion;
    private final ArrayList<String> versions = new ArrayList();
    private String backCompatibleTo;

    public VersionManager(String firstVersion) {
        this.addVersion(firstVersion);
        this.breakBackCompatability();
    }

    public void addVersion(String string) {
        if (this.versions.contains(string)) {
            throw new IllegalArgumentException("Cannot add same version twice!");
        }
        this.versions.add(string);
        this.currentVersion = string;
    }

    public int getVersionID(String version) {
        return this.versions.indexOf(version);
    }

    public String getVersion(int ID) {
        return this.versions.get(ID);
    }

    public void breakBackCompatability() {
        this.backCompatibleTo = this.currentVersion;
    }

    public boolean isCompatible(int versionID) {
        return this.getVersionID(this.backCompatibleTo) <= versionID;
    }
}

