/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.audio;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import simplelibrary.Sys;
import simplelibrary.error.ErrorCategory;
import simplelibrary.error.ErrorLevel;

public class AudioManager {
    private static final HashMap<String, String> sounds = new HashMap();

    public static Clip getSound(String name) {
        if (sounds.containsKey(name)) {
            try {
                InputStream in;
                String path = sounds.get(name);
                if (path.startsWith("/")) {
                    in = AudioManager.class.getResourceAsStream(path);
                } else {
                    in = new FileInputStream(new File(path));
                    in = new BufferedInputStream(in);
                }
                Clip clip = AudioSystem.getClip();
                AudioInputStream inputStream = AudioSystem.getAudioInputStream(in);
                clip.open(inputStream);
                return clip;
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException ex) {
                Sys.error(ErrorLevel.moderate, "Could not load sound at " + sounds.get(name) + "!", ex, ErrorCategory.audio);
            }
        } else {
            Sys.error(ErrorLevel.warning, "Could not find sound " + name + "!", new IllegalArgumentException("Sound Not Found!"), ErrorCategory.audio);
        }
        return null;
    }

    public static Clip playSound(String name) {
        Clip clip = AudioManager.getSound(name);
        if (clip != null) {
            clip.start();
        }
        return clip;
    }

    public static void addSound(String name, String path) {
        try {
            if (path.startsWith("/")) {
                InputStream s = AudioManager.class.getResourceAsStream(path);
                if (s == null) {
                    Sys.error(ErrorLevel.warning, "Could not find sound file " + path + "!", null, ErrorCategory.fileIO);
                    return;
                }
                s.close();
            } else if (!path.startsWith("/") && !new File(path).exists()) {
                Sys.error(ErrorLevel.warning, "Could not find sound file " + path + "!", null, ErrorCategory.fileIO);
                return;
            }
        }
        catch (Exception ex) {
            Sys.error(ErrorLevel.moderate, "Could not find sound file " + path + "!", ex, ErrorCategory.fileIO);
            return;
        }
        sounds.put(name, path);
    }

    private AudioManager() {
    }
}

