/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import simplelibrary.Sys;
import simplelibrary.error.ErrorCategory;
import simplelibrary.error.ErrorLevel;

public class Config {
    private final HashMap<String, String> map = new HashMap();
    protected File file;

    public static Config loadConfig(String path) {
        return path.startsWith("/") ? Config.loadConfig(Config.class.getResourceAsStream(path)) : Config.loadConfig(new File(path));
    }

    public static Config loadConfig(File file) {
        try {
            file.getParentFile().mkdirs();
            if (!file.exists()) {
                if (!file.createNewFile()) {
                    Sys.error(ErrorLevel.warning, "Could not create file " + file.getAbsolutePath() + "!", null, ErrorCategory.fileIO);
                    return null;
                }
                Config value = Config.loadConfig(new FileInputStream(file));
                value.setFile(file);
                return value;
            }
            Config value = Config.loadConfig(new FileInputStream(file));
            value.file = file;
            return value;
        }
        catch (IOException ex) {
            Sys.error(ErrorLevel.warning, "Could not find file " + file.getAbsolutePath() + "!", ex, ErrorCategory.fileIO);
            return null;
        }
    }

    public static Config loadConfig(InputStream stream) {
        Config value = null;
        if (stream == null) {
            return new Config();
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader(stream, Charset.forName("UTF-8")));){
            String line;
            value = new Config();
            while ((line = in.readLine()) != null) {
                String[] spl = line.split("=");
                if (spl.length < 2 || spl[0] == null || spl[0].isEmpty() || spl[1] == null || spl[1].isEmpty()) continue;
                value.map.put(spl[0], spl[1]);
            }
        }
        catch (IOException ex) {
            Sys.error(ErrorLevel.warning, "Could not read config from stream!", ex, ErrorCategory.config);
        }
        return value;
    }

    public String str(String key) {
        if (key == null || key.isEmpty() || key.contains("..")) {
            throw new IllegalArgumentException("Empty strings cannot be keys!");
        }
        if (this.hasProperty(key)) {
            return this.map.get(key);
        }
        return null;
    }

    public boolean hasProperty(String key) {
        return this.map.get(key) != null && !this.map.get(key).isEmpty();
    }

    public void save() {
        if (this.file == null) {
            Sys.error(ErrorLevel.severe, "Cannot save a config that has no file!", null, ErrorCategory.config);
        }
        this.file.getParentFile().mkdirs();
        try (PrintWriter out = new PrintWriter(this.file, "UTF-8");){
            String[] keys;
            List<String> lst = Arrays.asList(this.map.keySet().toArray(new String[this.map.keySet().size()]));
            Collections.sort(lst);
            for (String key : keys = lst.toArray(new String[lst.size()])) {
                out.println(key + "=" + this.map.get(key));
            }
        }
        catch (IOException ex) {
            Logger.getLogger(Config.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void checkProperty(String key, String defaultValue) {
        if (!this.hasProperty(key)) {
            this.putProperty(key, defaultValue);
        }
    }

    public String remove(String key) {
        if (!this.hasProperty(key)) {
            return null;
        }
        String val = this.str(key);
        this.map.remove(key);
        return val;
    }

    public File getFile() {
        return this.file;
    }

    public void putProperty(String key, String value) {
        if (key.startsWith("#") || key.contains("=")) {
            Sys.error(ErrorLevel.severe, "Config keys cannot start with '#' or contain any '='s!", null, ErrorCategory.config);
        }
        if (key.equals("config-version")) {
            Sys.error(ErrorLevel.severe, "Cannot overwrite the key \"config-version\"!", null, ErrorCategory.config);
        }
        if (value.contains("=")) {
            Sys.error(ErrorLevel.severe, "Config values cannot contain any '='s!", null, ErrorCategory.config);
        }
        if (this.file == null) {
            Sys.error(ErrorLevel.warning, "Cannot change configs that have no file!", null, ErrorCategory.config);
            return;
        }
        if (!key.isEmpty() && !value.isEmpty()) {
            this.map.put(key, value);
        } else {
            Sys.error(ErrorLevel.warning, "Empty property setting- key=" + key + " & value=" + value, null, ErrorCategory.config);
        }
    }

    public void setFile(File file) {
        if (this.file == null) {
            this.file = file;
        }
    }

    public boolean hasFile() {
        return this.file != null;
    }

    public boolean isSameConfig(Config config) {
        if (config.getClass() != this.getClass()) {
            return false;
        }
        if (config.equals(this)) {
            return true;
        }
        if (config.file != null && this.file != null && this.file.getAbsolutePath().equals(config.file.getAbsolutePath())) {
            return true;
        }
        List<String> lst = Arrays.asList(config.map.keySet().toArray(new String[config.map.keySet().size()]));
        List<String> lst2 = Arrays.asList(this.map.keySet().toArray(new String[this.map.keySet().size()]));
        Collections.sort(lst);
        Collections.sort(lst2);
        String[] keys = lst.toArray(new String[lst.size()]);
        String[] keys2 = lst2.toArray(new String[lst2.size()]);
        if (keys.length != keys2.length) {
            return false;
        }
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].equals(keys2[i])) {
                return false;
            }
            if (config.str(keys[i]).equals(this.str(keys2[i]))) continue;
            return false;
        }
        return true;
    }

    public String[] properties() {
        return this.map.keySet().toArray(new String[this.map.keySet().size()]);
    }
}

