/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.config2;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import simplelibrary.Sys;
import simplelibrary.config2.ConfigBase;
import simplelibrary.config2.ConfigBoolean;
import simplelibrary.config2.ConfigByte;
import simplelibrary.config2.ConfigDouble;
import simplelibrary.config2.ConfigFloat;
import simplelibrary.config2.ConfigInteger;
import simplelibrary.config2.ConfigList;
import simplelibrary.config2.ConfigLong;
import simplelibrary.config2.ConfigNumberList;
import simplelibrary.config2.ConfigShort;
import simplelibrary.config2.ConfigString;
import simplelibrary.error.ErrorCategory;
import simplelibrary.error.ErrorLevel;

public class Config
extends ConfigBase
implements Cloneable {
    private static final int TYPE_ALONE = 1;
    private static final int TYPE_FILE = 2;
    private static final int TYPE_STRING = 3;
    private static final int TYPE_STREAM = 4;
    private File file;
    private int type = 1;
    private String path;
    private InputStream stream;
    private final ArrayList<String> keys = new ArrayList();
    private final HashMap<String, ConfigBase> data = new HashMap();
    public static final short CONFIG_VERSION = 1;

    public static Config newConfig(File file) {
        Config config = new Config();
        config.type = 2;
        config.file = file;
        return config;
    }

    public static Config newConfig(String path) {
        Config config = new Config();
        config.type = 3;
        config.path = path;
        return config;
    }

    public static Config newConfig(InputStream in) {
        Config config = new Config();
        config.type = 4;
        config.stream = in;
        return config;
    }

    public static Config newConfig() {
        return new Config();
    }

    @Override
    void read(DataInputStream in, short version) throws IOException {
        int index;
        if (version == 0) {
            int index2;
            while ((index2 = in.read()) > 0) {
                ConfigBase base = this.newConfig(index2);
                String key = in.readUTF();
                base.read(in, version);
                this.dataput(key, base);
            }
            return;
        }
        while ((index = in.read()) > 0) {
            ConfigBase base = this.newConfig(index);
            base.read(in, version);
            this.dataput(in.readUTF(), base);
        }
    }

    @Override
    void write(DataOutputStream out) throws IOException {
        for (String str : this.keys) {
            ConfigBase base = this.data.get(str);
            out.write(base.getIndex());
            base.write(out);
            out.writeUTF(str);
        }
        out.write(0);
    }

    @Override
    Config getData() {
        return this;
    }

    public Config load() {
        switch (this.type) {
            case 2: {
                return this.load(this.file);
            }
            case 3: {
                return this.load(this.path);
            }
            case 1: {
                throw new UnsupportedOperationException("Cannot load a config with nothing to load from!");
            }
            case 4: {
                return this.load(this.stream);
            }
        }
        throw new AssertionError(this.type);
    }

    public boolean save() {
        switch (this.type) {
            case 2: {
                return this.save(this.file);
            }
            case 3: {
                return this.save(this.path);
            }
            case 1: {
                throw new UnsupportedOperationException("Cannot save a config with nothing to save to!");
            }
            case 4: {
                throw new UnsupportedOperationException("Cannot save a config with nothing to save to!");
            }
        }
        throw new AssertionError(this.type);
    }

    public Config load(File file) {
        try {
            Config value;
            try (FileInputStream in = new FileInputStream(file);){
                value = this.load(new BufferedInputStream(in));
            }
            return value;
        }
        catch (Throwable ex) {
            return null;
        }
    }

    public boolean save(File file) {
        file = file.getAbsoluteFile();
        try {
            boolean value;
            file.getParentFile().mkdirs();
            if (!file.getParentFile().exists() || !file.getParentFile().isDirectory() || file.isDirectory()) {
                return false;
            }
            try (FileOutputStream out = new FileOutputStream(file);){
                value = this.save(out);
            }
            return value;
        }
        catch (Throwable ex) {
            return false;
        }
    }

    public Config load(String path) {
        if (path.startsWith("/")) {
            InputStream in = Config.class.getResourceAsStream(path);
            Config value = this.load(new BufferedInputStream(in));
            try {
                in.close();
            }
            catch (Throwable ex) {
                Sys.error(ErrorLevel.severe, "Could not close input stream!", ex, ErrorCategory.fileIO);
            }
            return value;
        }
        return this.load(new File(path));
    }

    public boolean save(String path) {
        if (path.startsWith("/")) {
            try {
                boolean flag;
                URL resource = Config.class.getResource(path);
                if (resource.getQuery() != null) {
                    return false;
                }
                File file = new File(resource.getFile());
                file.getParentFile().mkdirs();
                if (!file.getParentFile().exists() || !file.getParentFile().isDirectory() || file.isDirectory()) {
                    return false;
                }
                try (FileOutputStream out = new FileOutputStream(file);){
                    flag = this.save(out);
                }
                return flag;
            }
            catch (Throwable twbl) {
                return false;
            }
        }
        return this.save(new File(path));
    }

    public Config load(InputStream in) {
        if (in == null) {
            throw new IllegalArgumentException("Input stream cannot be null!");
        }
        this.data.clear();
        this.keys.clear();
        DataInputStream dataIn = new DataInputStream(in);
        boolean fail = false;
        try {
            short version = dataIn.readShort();
            if (version == 2) {
                fail = true;
                throw new IllegalArgumentException("File is not a Config file!  Open it with ConfigMulti!");
            }
            if (version > 1) {
                fail = true;
                throw new IllegalArgumentException("File is a newer version of format!");
            }
            this.read(dataIn, version);
        }
        catch (Throwable ex) {
            if (ex instanceof IllegalArgumentException && ((IllegalArgumentException)ex).getMessage().equals("File is a newer version of format!")) {
                throw (IllegalArgumentException)ex;
            }
            Sys.error(ErrorLevel.moderate, "Could not load config!", ex, ErrorCategory.config);
            return null;
        }
        return this;
    }

    public boolean save(OutputStream out) {
        if (out == null) {
            throw new IllegalArgumentException("Output stream cannot be null!");
        }
        out = new BufferedOutputStream(out);
        DataOutputStream dataOut = new DataOutputStream(out);
        try {
            dataOut.writeShort(1);
            this.write(dataOut);
            out.flush();
        }
        catch (Throwable ex) {
            Sys.error(ErrorLevel.moderate, "Could not save config!", ex, ErrorCategory.config);
            return false;
        }
        return true;
    }

    public <V> V get(String key) {
        if (!this.data.containsKey(key)) {
            return null;
        }
        return (V)this.data.get(key).getData();
    }

    public <V> V get(String key, V defaultValue) {
        if (!this.data.containsKey(key)) {
            this.set(key, defaultValue);
            return defaultValue;
        }
        return (V)this.data.get(key).getData();
    }

    public Config getConfig(String key) {
        return (Config)this.get(key);
    }

    public String getString(String key) {
        return (String)this.get(key);
    }

    public int getInt(String key) {
        return (Integer)this.get(key);
    }

    public boolean getBoolean(String key) {
        return (Boolean)this.get(key);
    }

    public float getFloat(String key) {
        return ((Float)this.get(key)).floatValue();
    }

    public long getLong(String key) {
        return (Long)this.get(key);
    }

    public double getDouble(String key) {
        return (Double)this.get(key);
    }

    public byte getByte(String key) {
        return (Byte)this.get(key);
    }

    public short getShort(String key) {
        return (Short)this.get(key);
    }

    public ConfigNumberList getConfigNumberList(String key) {
        return (ConfigNumberList)this.get(key);
    }

    public ConfigList getConfigList(String key) {
        return (ConfigList)this.get(key);
    }

    public Config getConfig(String key, Config defaultValue) {
        return this.get(key, defaultValue);
    }

    public String getString(String key, String defaultValue) {
        return this.get(key, defaultValue);
    }

    public int getInt(String key, int defaultValue) {
        return this.get(key, defaultValue);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.get(key, defaultValue);
    }

    public float getFloat(String key, float defaultValue) {
        return this.get(key, Float.valueOf(defaultValue)).floatValue();
    }

    public long getLong(String key, long defaultValue) {
        return this.get(key, defaultValue);
    }

    public double getDouble(String key, double defaultValue) {
        return this.get(key, defaultValue);
    }

    public byte getByte(String key, byte defaultValue) {
        return this.get(key, defaultValue);
    }

    public short getShort(String key, short defaultValue) {
        return this.get(key, defaultValue);
    }

    public ConfigNumberList getConfigNumberList(String key, ConfigNumberList defaultValue) {
        return this.get(key, defaultValue);
    }

    public ConfigList getConfigList(String key, ConfigList defaultValue) {
        return this.get(key, defaultValue);
    }

    public String[] properties() {
        return this.keys.toArray(new String[this.keys.size()]);
    }

    public <V> V removeProperty(String key) {
        V val = this.get(key);
        this.data.remove(key);
        this.keys.remove(key);
        return val;
    }

    public boolean hasProperty(String key) {
        return this.data.containsKey(key);
    }

    public void setProperty(String key, Config value) {
        this.dataput(key, value);
    }

    public void setProperty(String key, String value) {
        this.dataput(key, new ConfigString(value));
    }

    public void setProperty(String key, int value) {
        this.dataput(key, new ConfigInteger(value));
    }

    public void setProperty(String key, boolean value) {
        this.dataput(key, new ConfigBoolean(value));
    }

    public void setProperty(String key, float value) {
        this.dataput(key, new ConfigFloat(value));
    }

    public void setProperty(String key, long value) {
        this.dataput(key, new ConfigLong(value));
    }

    public void setProperty(String key, double value) {
        this.dataput(key, new ConfigDouble(value));
    }

    public void setProperty(String key, byte value) {
        this.dataput(key, new ConfigByte(value));
    }

    public void setProperty(String key, short value) {
        this.dataput(key, new ConfigShort(value));
    }

    public void setProperty(String key, ConfigNumberList value) {
        this.dataput(key, value);
    }

    public void setProperty(String key, ConfigList value) {
        this.dataput(key, value);
    }

    public void set(String key, Config value) {
        this.dataput(key, value);
    }

    public void set(String key, String value) {
        this.dataput(key, new ConfigString(value));
    }

    public void set(String key, int value) {
        this.dataput(key, new ConfigInteger(value));
    }

    public void set(String key, boolean value) {
        this.dataput(key, new ConfigBoolean(value));
    }

    public void set(String key, float value) {
        this.dataput(key, new ConfigFloat(value));
    }

    public void set(String key, long value) {
        this.dataput(key, new ConfigLong(value));
    }

    public void set(String key, double value) {
        this.dataput(key, new ConfigDouble(value));
    }

    public void set(String key, ConfigList value) {
        this.dataput(key, value);
    }

    public void set(String key, ConfigNumberList value) {
        this.dataput(key, value);
    }

    public void set(String key, byte value) {
        this.dataput(key, new ConfigByte(value));
    }

    public void set(String key, short value) {
        this.dataput(key, new ConfigShort(value));
    }

    public void set(String key, Object value) {
        if (value != null) {
            if (value instanceof Config) {
                this.set(key, (Config)value);
            } else if (value instanceof String) {
                this.set(key, (String)value);
            } else if (value instanceof Integer) {
                this.set(key, (Integer)value);
            } else if (value instanceof Boolean) {
                this.set(key, (Boolean)value);
            } else if (value instanceof Float) {
                this.set(key, ((Float)value).floatValue());
            } else if (value instanceof Long) {
                this.set(key, (Long)value);
            } else if (value instanceof Double) {
                this.set(key, (Double)value);
            } else if (value instanceof ConfigList) {
                this.set(key, (ConfigList)value);
            } else if (value instanceof ConfigNumberList) {
                this.set(key, (ConfigNumberList)value);
            } else if (value instanceof Byte) {
                this.set(key, (Byte)value);
            } else if (value instanceof Short) {
                this.set(key, (Short)value);
            }
        }
    }

    private void dataput(String key, ConfigBase base) {
        if (base == null) {
            throw new IllegalArgumentException("Cannot set null values to a config!");
        }
        if (!this.keys.contains(key)) {
            this.keys.add(key);
        }
        this.data.put(key, base);
    }

    public Config clone() {
        Config c = Config.newConfig();
        c.file = this.file;
        c.type = this.type;
        c.path = this.path;
        c.stream = this.stream;
        c.keys.addAll(this.keys);
        for (String s : this.data.keySet()) {
            ConfigBase b = this.data.get(s);
            if (b instanceof Config) {
                c.data.put(s, ((Config)b).clone());
                continue;
            }
            c.data.put(s, b);
        }
        return c;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        Config c = (Config)obj;
        if (c.keys.size() != this.keys.size()) {
            return false;
        }
        for (String k : this.keys) {
            if (!c.keys.contains(k)) {
                return false;
            }
            if (this.get(k).equals(c.get(k))) continue;
            return false;
        }
        return true;
    }
}

