/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.config2;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import simplelibrary.config2.Config;
import simplelibrary.config2.ConfigBase;
import simplelibrary.config2.ConfigBoolean;
import simplelibrary.config2.ConfigByte;
import simplelibrary.config2.ConfigDouble;
import simplelibrary.config2.ConfigFloat;
import simplelibrary.config2.ConfigInteger;
import simplelibrary.config2.ConfigLong;
import simplelibrary.config2.ConfigNumberList;
import simplelibrary.config2.ConfigShort;
import simplelibrary.config2.ConfigString;

public class ConfigList
extends ConfigBase {
    private ArrayList<ConfigBase> lst = new ArrayList();

    public ConfigList() {
    }

    public ConfigList(Collection<?> lst) {
        for (Object o : lst) {
            this.add(o);
        }
    }

    @Override
    void read(DataInputStream in, short version) throws IOException {
        int oneType;
        int n = oneType = version == 0 ? 2 : in.read();
        if (oneType == 0) {
            return;
        }
        if (oneType == 1) {
            int count = in.readInt();
            int index = in.read();
            for (int i = 0; i < count; ++i) {
                ConfigBase base = this.newConfig(index);
                base.read(in, version);
                this.lst.add(base);
            }
        } else {
            int index;
            while ((index = in.read()) > 0) {
                ConfigBase base = this.newConfig(index);
                if (version == 0) {
                    in.readShort();
                }
                base.read(in, version);
                this.lst.add(base);
            }
        }
    }

    @Override
    void write(DataOutputStream out) throws IOException {
        boolean oneType;
        if (this.lst.isEmpty()) {
            out.write(0);
            return;
        }
        boolean bl = oneType = this.lst.size() > 4;
        if (oneType) {
            ConfigBase ref = this.lst.get(0);
            for (ConfigBase b : this.lst) {
                if (b.getClass() == ref.getClass()) continue;
                oneType = false;
                break;
            }
        }
        out.write(oneType ? 1 : 2);
        if (oneType) {
            out.writeInt(this.lst.size());
            out.write(this.lst.get(0).getIndex());
            for (ConfigBase b : this.lst) {
                b.write(out);
            }
        } else {
            for (ConfigBase base : this.lst) {
                out.write(base.getIndex());
                base.write(out);
            }
            out.write(0);
        }
    }

    @Override
    ConfigList getData() {
        return this;
    }

    public <V> V get(int index) {
        if (index >= this.size() || index < 0) {
            return null;
        }
        return (V)this.lst.get(index).getData();
    }

    public Config getConfig(int index) {
        return (Config)this.get(index);
    }

    public String getString(int index) {
        return (String)this.get(index);
    }

    public int getInt(int index) {
        return (Integer)this.get(index);
    }

    public boolean getBoolean(int index) {
        return (Boolean)this.get(index);
    }

    public float getFloat(int index) {
        return ((Float)this.get(index)).floatValue();
    }

    public long getLong(int index) {
        return (Long)this.get(index);
    }

    public double getDouble(int index) {
        return (Double)this.get(index);
    }

    public byte getByte(int index) {
        return (Byte)this.get(index);
    }

    public short getShort(int index) {
        return (Short)this.get(index);
    }

    public ConfigNumberList getConfigNumberList(int index) {
        return (ConfigNumberList)this.get(index);
    }

    public ConfigList getConfigList(int index) {
        return (ConfigList)this.get(index);
    }

    public <V> Collection<V> copyTo(Collection<V> lst) {
        for (V v : this.iterable()) {
            lst.add(v);
        }
        return lst;
    }

    public <V> Iterable<V> iterable() {
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return ConfigList.this.iterator();
            }
        };
    }

    public <V> Iterator<V> iterator() {
        return new Iterator<V>(){
            Iterator<ConfigBase> it;
            V next;
            {
                this.it = ConfigList.this.lst.iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.next == null && this.it.hasNext()) {
                    try {
                        this.next = this.it.next().getData();
                    }
                    catch (ClassCastException classCastException) {}
                }
                return this.next != null;
            }

            @Override
            public V next() {
                this.hasNext();
                Object val = this.next;
                this.next = null;
                return val;
            }
        };
    }

    public int size() {
        return this.lst.size();
    }

    public <V> V remove(int index) {
        V val = this.get(index);
        if (index >= 0 && index < this.size()) {
            this.lst.remove(index);
        }
        return val;
    }

    public boolean contains(Object value) {
        if (value == null) {
            return false;
        }
        for (ConfigBase b : this.lst) {
            if (!b.getData().equals(value)) continue;
            return true;
        }
        return false;
    }

    public void add(Config value) {
        this.doAdd(value);
    }

    public void add(String value) {
        this.doAdd(new ConfigString(value));
    }

    public void add(int value) {
        this.doAdd(new ConfigInteger(value));
    }

    public void add(boolean value) {
        this.doAdd(new ConfigBoolean(value));
    }

    public void add(float value) {
        this.doAdd(new ConfigFloat(value));
    }

    public void add(long value) {
        this.doAdd(new ConfigLong(value));
    }

    public void add(double value) {
        this.doAdd(new ConfigDouble(value));
    }

    public void add(byte value) {
        this.doAdd(new ConfigByte(value));
    }

    public void add(short value) {
        this.doAdd(new ConfigShort(value));
    }

    public void add(ConfigList value) {
        this.doAdd(value);
    }

    public void add(ConfigNumberList value) {
        this.doAdd(value);
    }

    public void add(Object value) {
        if (value != null) {
            if (value instanceof Config) {
                this.add((Config)value);
            } else if (value instanceof String) {
                this.add((String)value);
            } else if (value instanceof Integer) {
                this.add((Integer)value);
            } else if (value instanceof Boolean) {
                this.add((Boolean)value);
            } else if (value instanceof Float) {
                this.add(((Float)value).floatValue());
            } else if (value instanceof Long) {
                this.add((Long)value);
            } else if (value instanceof Double) {
                this.add((Double)value);
            } else if (value instanceof Byte) {
                this.add((Byte)value);
            } else if (value instanceof Short) {
                this.add((Short)value);
            } else if (value instanceof ConfigList) {
                this.add((ConfigList)value);
            } else if (value instanceof ConfigNumberList) {
                this.add((ConfigNumberList)value);
            }
        }
    }

    private void doAdd(ConfigBase b) {
        if (b == null) {
            throw new IllegalArgumentException("Cannot set null values to a config!");
        }
        this.lst.add(b);
    }
}

