/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.config2;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import simplelibrary.config2.ConfigBase;

public class ConfigNumberList
extends ConfigBase {
    private ArrayList<Number> lst = new ArrayList();

    public ConfigNumberList() {
    }

    public ConfigNumberList(Collection<? extends Number> lst) {
        for (Number number : lst) {
            this.add(number);
        }
    }

    @Override
    ConfigNumberList getData() {
        return this;
    }

    public long get(int index) {
        if (index >= this.size() || index < 0) {
            return 0L;
        }
        return (Long)this.lst.get(index);
    }

    public int size() {
        return this.lst.size();
    }

    public long remove(int index) {
        long val = this.get(index);
        if (index >= 0 && index < this.size()) {
            this.lst.remove(index);
        }
        return val;
    }

    public <V extends Number> Collection<V> copyTo(Collection<V> lst) {
        for (Number v : this.iterable()) {
            lst.add(v);
        }
        return lst;
    }

    public <V extends Number> Iterable<V> iterable() {
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return ConfigNumberList.this.iterator();
            }
        };
    }

    public <V extends Number> Iterator<V> iterator() {
        return new Iterator<V>(){
            Iterator<Number> it;
            V next;
            {
                this.it = ConfigNumberList.this.lst.iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.next == null && this.it.hasNext()) {
                    try {
                        this.next = this.it.next();
                    }
                    catch (ClassCastException classCastException) {}
                }
                return this.next != null;
            }

            @Override
            public V next() {
                this.hasNext();
                Object val = this.next;
                this.next = null;
                return val;
            }
        };
    }

    public <V extends Number> boolean contains(V value) {
        if (value == null) {
            return false;
        }
        for (Number n : this.lst) {
            if (!n.equals(value)) continue;
            return true;
        }
        return false;
    }

    public void add(Number value) {
        if (value == null) {
            throw new NullPointerException("Cannot add null to a ConfigNumberList!");
        }
        if (!(value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte)) {
            throw new IllegalArgumentException("ConfigNumberList can only take primitive integral types!");
        }
        this.doAdd(value);
    }

    public void add(long value) {
        this.add((Number)value);
    }

    public void add(int value) {
        this.add((Number)value);
    }

    public void add(short value) {
        this.add((Number)value);
    }

    public void add(byte value) {
        this.add((Number)value);
    }

    private void doAdd(Number value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot set null values to a ConfigNumberList!");
        }
        this.lst.add(value.longValue());
    }

    @Override
    void write(DataOutputStream out) throws IOException {
        int sizeClass = 0;
        int size = this.lst.size();
        if (size > 63) {
            ++sizeClass;
        }
        if (size > 16383) {
            ++sizeClass;
        }
        if (size > 0x3FFFFFFF) {
            ++sizeClass;
        }
        switch (sizeClass <<= 6) {
            case 192: {
                out.write(sizeClass);
                out.writeInt(size);
                break;
            }
            case 128: {
                out.writeInt(sizeClass << 24 | size);
                break;
            }
            case 64: {
                out.writeShort((short)(sizeClass << 8 | size));
                break;
            }
            case 0: {
                out.write(sizeClass | size);
                break;
            }
            default: {
                throw new IllegalStateException("This shouldn't be possible.");
            }
        }
        if (size == 0) {
            return;
        }
        int maxDigits = 0;
        boolean hasNeg = false;
        boolean verbatum = false;
        for (Number n : this.lst) {
            long l = n.longValue();
            if (l == Long.MIN_VALUE) {
                verbatum = true;
                break;
            }
            if (l < 0L) {
                l = -l;
                hasNeg = true;
            }
            int digits = 0;
            while (l > 0L) {
                ++digits;
                l >>= 1;
            }
            if (digits <= maxDigits) continue;
            maxDigits = digits;
        }
        if (hasNeg) {
            maxDigits |= 0x40;
        }
        if (verbatum) {
            maxDigits |= 0x80;
        }
        out.write(maxDigits);
        if (maxDigits == 0) {
            return;
        }
        int currentByte = 0;
        int left = 8;
        long nextNumber = 0L;
        int nextLeft = 0;
        for (Number n : this.lst) {
            nextNumber = n.longValue();
            if (verbatum) {
                out.writeLong(nextNumber);
                continue;
            }
            if (hasNeg) {
                currentByte |= (nextNumber < 0L ? 1 : 0) << left - 1;
                --left;
                nextNumber = Math.abs(nextNumber);
            }
            nextLeft = maxDigits & 0x3F;
            while (nextLeft > 0 || left < 1) {
                if (left < 1) {
                    out.write(currentByte);
                    currentByte = 0;
                    left = 8;
                    continue;
                }
                int bits = Math.min(nextLeft, left);
                long mask = 255L >> 8 - bits << nextLeft - bits;
                int txfr = (int)((nextNumber & mask) >> nextLeft - bits);
                currentByte |= txfr << left - bits;
                left -= bits;
                nextLeft -= bits;
            }
        }
        if (left < 8) {
            out.write(currentByte);
        }
    }

    @Override
    void read(DataInputStream in, short version) throws IOException {
        boolean hasNeg;
        boolean verbatum;
        if (version < 1) {
            throw new IllegalArgumentException("ConfigNumberList didn't exist in version " + version + "!");
        }
        int abyte = in.read();
        int sizeClass = (abyte & 0xC0) >> 6;
        int size = 0;
        switch (sizeClass) {
            case 0: {
                size = abyte & 0x3F;
                break;
            }
            case 1: {
                size = (abyte & 0x3F) << 8 | in.read();
                break;
            }
            case 2: {
                size = (abyte & 0x3F) << 24 | in.read() << 16 | in.read() << 8 | in.read();
                break;
            }
            case 3: {
                size = in.readInt();
                break;
            }
            default: {
                throw new IllegalStateException("This shouldn't be possible.");
            }
        }
        if (size == 0) {
            return;
        }
        int digits = in.read();
        boolean bl = verbatum = (digits & 0x80) > 0;
        if (verbatum) {
            for (int i = 0; i < size; ++i) {
                this.add(in.readLong());
            }
            return;
        }
        boolean bl2 = hasNeg = (digits & 0x40) > 0;
        if ((digits &= 0x3F) == 0) {
            for (int i = 0; i < size; ++i) {
                this.add(0);
            }
            return;
        }
        int currentByte = 0;
        int left = 0;
        long number = 0L;
        int nextLeft = 0;
        boolean isNeg = false;
        for (int i = 0; i < size; ++i) {
            if (left < 1) {
                currentByte = in.read();
                left = 8;
            }
            if (hasNeg) {
                isNeg = (currentByte & 1 << left - 1) > 0;
                --left;
            }
            number = 0L;
            nextLeft = digits;
            while (nextLeft > 0) {
                if (left < 1) {
                    currentByte = in.read();
                    left = 8;
                }
                int bits = Math.min(nextLeft, left);
                long mask = 255L >> 8 - bits << left - bits;
                long txfr = (int)(((long)currentByte & mask) >> left - bits);
                number |= txfr << nextLeft - bits;
                nextLeft -= bits;
                left -= bits;
            }
            if (isNeg) {
                number = -number;
            }
            this.add(number);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ConfigNumberList l = (ConfigNumberList)obj;
        if (l.lst.size() != this.lst.size()) {
            return false;
        }
        for (int i = 0; i < this.lst.size(); ++i) {
            if (this.lst.get(i).longValue() == l.lst.get(i).longValue()) continue;
            return false;
        }
        return true;
    }
}

