/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.encryption;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import simplelibrary.encryption.DecryptionInputStream;
import simplelibrary.encryption.EncryptionNotFoundException;
import simplelibrary.encryption.EncryptionOutputStream;

public abstract class Encryption {
    private static final HashMap<String, Encryption> encryptions = new HashMap();
    public static final ReadyEncryption UNENCRYPTED = new NothingEncryption();
    public final String name;

    public static boolean isSupported(String encryption) {
        String[] components;
        for (String s : components = encryption.split(" + ")) {
            if (encryptions.containsKey(s)) continue;
            return false;
        }
        return true;
    }

    public Encryption(String name) {
        this.name = name;
        if (!(this instanceof ReadyEncryption) || this instanceof NothingEncryption) {
            if (encryptions.containsKey(name)) {
                throw new IllegalArgumentException("Encryption already exists by that name!");
            }
            if (name.contains(" + ") && !(this instanceof LayeredEncryption)) {
                throw new IllegalArgumentException("Single encryptions cannot have ' + ' in their names!");
            }
            encryptions.put(this.name, this);
        }
    }

    public static Encryption getEncryption(String encryption) throws EncryptionNotFoundException {
        String[] components;
        for (String s : components = encryption.split(" + ")) {
            if (encryptions.containsKey(s)) continue;
            throw new EncryptionNotFoundException(s);
        }
        if (components.length == 1) {
            return encryptions.get(components[0]);
        }
        ArrayList<String> encryptions = new ArrayList<String>(Arrays.asList(components));
        for (int i = encryptions.size(); i > 1; --i) {
            for (int j = 0; j <= encryptions.size() - i; ++j) {
                int k;
                String title = encryptions.get(j);
                for (k = 1; k < i; ++k) {
                    title = title + " + " + encryptions.get(j + k);
                }
                if (!Encryption.encryptions.containsKey(title)) continue;
                for (k = i - 1; k > 0; ++k) {
                    encryptions.remove(k + j);
                }
                encryptions.set(j, title);
            }
        }
        if (encryptions.size() == 1) {
            return Encryption.encryptions.get(encryptions.get(0));
        }
        Encryption e = Encryption.encryptions.get(encryptions.get(0));
        for (int i = 1; i < encryptions.size(); ++i) {
            e = new LayeredEncryption(e, Encryption.encryptions.get(encryptions.get(0)));
        }
        return e;
    }

    public final ReadyEncryption ready(String key) {
        if (this instanceof NothingEncryption) {
            return (ReadyEncryption)this;
        }
        if (this instanceof LayeredEncryption) {
            return new ReadyLayeredEncryption((LayeredEncryption)this, new String[]{key});
        }
        return new ReadyEncryption(this, key);
    }

    protected abstract EncryptionOutputStream encrypt(OutputStream var1, String var2);

    protected abstract DecryptionInputStream decrypt(InputStream var1, String var2);

    public static class NothingEncryption
    extends ReadyEncryption {
        public NothingEncryption() {
            super("");
        }

        @Override
        protected EncryptionOutputStream encrypt(OutputStream out, String key) {
            return new EncryptionOutputStream(out){

                @Override
                public void write(int b) throws IOException {
                    this.out.write(b);
                }

                @Override
                public void flush() throws IOException {
                    this.out.flush();
                }
            };
        }

        @Override
        protected DecryptionInputStream decrypt(InputStream in, String key) {
            return new DecryptionInputStream(in){

                @Override
                public int read() throws IOException {
                    return this.in.read();
                }
            };
        }

        @Override
        public EncryptionOutputStream encrypt(OutputStream out) {
            return this.encrypt(out, null);
        }

        @Override
        public DecryptionInputStream decrypt(InputStream in) {
            return this.decrypt(in, null);
        }
    }

    public static class ReadyLayeredEncryption
    extends ReadyEncryption {
        ArrayList<ReadyEncryption> encryptions;

        private ReadyLayeredEncryption(LayeredEncryption encryption, String ... keys) {
            super((Encryption)encryption);
            int index = 0;
            ArrayList<Encryption> lst = new ArrayList<Encryption>();
            lst.add(encryption);
            while (!lst.isEmpty()) {
                Encryption e = (Encryption)lst.remove(0);
                if (!(e instanceof LayeredEncryption)) {
                    this.encryptions.add(e.ready(keys[index]));
                    index = (index + 1) % keys.length;
                    continue;
                }
                LayeredEncryption le = (LayeredEncryption)e;
                lst.add(0, le.secondLayer);
                lst.add(0, le.firstLayer);
            }
        }

        @Override
        public EncryptionOutputStream encrypt(OutputStream out) {
            for (ReadyEncryption encryption : this.encryptions) {
                out = encryption.encrypt(out);
            }
            return (EncryptionOutputStream)out;
        }

        @Override
        public DecryptionInputStream decrypt(InputStream in) {
            for (ReadyEncryption encryption : this.encryptions) {
                in = encryption.decrypt(in);
            }
            return (DecryptionInputStream)in;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            ReadyLayeredEncryption o = (ReadyLayeredEncryption)obj;
            if (o.encryptions.size() != this.encryptions.size()) {
                return false;
            }
            for (int i = 0; i < this.encryptions.size(); ++i) {
                if (this.encryptions.get(i).equals(o.encryptions.get(i))) continue;
                return false;
            }
            return true;
        }
    }

    public static class ReadyEncryption
    extends Encryption {
        private String key;
        private final Encryption encryption;

        private ReadyEncryption(String name) {
            super(name);
            this.encryption = null;
        }

        private ReadyEncryption(Encryption encryption) {
            super(encryption.name);
            this.encryption = encryption;
        }

        private ReadyEncryption(Encryption encryption, String key) {
            this(encryption);
            this.key = key;
        }

        @Override
        protected EncryptionOutputStream encrypt(OutputStream out, String key) {
            return this.encryption.encrypt(out, key);
        }

        @Override
        protected DecryptionInputStream decrypt(InputStream in, String key) {
            return this.encryption.decrypt(in, key);
        }

        public EncryptionOutputStream encrypt(OutputStream out) {
            return this.encryption.encrypt(out, this.key);
        }

        public DecryptionInputStream decrypt(InputStream in) {
            return this.encryption.decrypt(in, this.key);
        }

        public boolean equals(Object obj) {
            return obj != null && obj.getClass() == this.getClass() && this.key.equals(((ReadyEncryption)obj).key);
        }
    }

    public static class LayeredEncryption
    extends Encryption {
        private final Encryption firstLayer;
        private final Encryption secondLayer;

        private LayeredEncryption(Encryption innerLayer, Encryption outerLayer) {
            super(innerLayer.name + " + " + outerLayer.name);
            this.firstLayer = innerLayer;
            this.secondLayer = outerLayer;
        }

        @Override
        protected EncryptionOutputStream encrypt(OutputStream out, String key) {
            return this.secondLayer.encrypt(this.firstLayer.encrypt(out, key), key);
        }

        @Override
        protected DecryptionInputStream decrypt(InputStream in, String key) {
            return this.firstLayer.decrypt(this.secondLayer.decrypt(in, key), key);
        }

        public final ReadyEncryption readyLayers(String ... key) {
            return new ReadyLayeredEncryption(this, key);
        }
    }
}

