/*
 * Decompiled with CFR 0.152.
 */
package simplelibrary.game;

import simplelibrary.Sys;
import simplelibrary.game.GameHelper;
import simplelibrary.opengl.ImageStash;

public class Framebuffer {
    public final GameHelper helper;
    public final String name;
    public final int width;
    public final int height;
    public final ImageStash stash;

    public Framebuffer(GameHelper helper, String name, int width, int height) {
        this(helper, ImageStash.instance, name, width, height);
    }

    public Framebuffer(GameHelper helper, ImageStash stash, String name, int width, int height) {
        if (name == null) {
            name = Sys.generateRandomString(20);
        }
        this.helper = helper;
        this.name = name;
        this.width = width;
        this.height = height;
        this.stash = stash;
        if (stash.hasBuffer(name)) {
            throw new IllegalStateException("Framebuffer \"" + name + "\" already exists in ImageStash!");
        }
        stash.configureBuffer(stash.getBuffer(name), width, height);
    }

    public void bindTexture() {
        this.stash.bindTexture(this.getTexture());
    }

    public void bindRenderTarget2D() {
        this.bindRenderTarget(1, 1.0f);
    }

    public void bindRenderTargetCentered() {
        this.bindRenderTarget(2, 1.0f);
    }

    public void bindRenderTarget3D() {
        this.bindRenderTarget(3, 1.0f);
    }

    public void bindRenderTarget(int mode, float guiScale) {
        this.helper.renderTargetFramebuffer(this.stash.getBuffer(this.name), mode, this.width, this.height, guiScale);
    }

    public void releaseRenderTarget() {
        this.helper.renderTargetFramebuffer(0, 0, 0, 0, 0.0f);
    }

    protected void finalize() throws Throwable {
        this.stash.deleteBuffer(this.stash.getBuffer(this.name));
        super.finalize();
    }

    public int getTexture() {
        return this.stash.getTextureForBuffer(this.stash.getBuffer(this.name));
    }
}

